--[[
	ActionButtonUnabridged

	By sarf

	This mod expands action button tooltips into more informative ones.

	Thanks also goes to Bayta (on the official WoW community boards), who came up with the idea, 
	as well as karconn (Bayta's nick on the CosmosUI.org forums) for providing feedback.
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=266
	
	Bayta's Thread URL:
	http://www.worldofwarcraft.com/thread.aspx?fn=wow-interface-customization&t=7287
   ]]


-- Constants

-- Variables
ActionButtonUnabridged_BookTypes = { BOOKTYPE_PET, BOOKTYPE_SPELL, BOOKTYPE_PET };
ActionButtonUnabridged_Saved_ActionButton_SetTooltip = nil;
ActionButtonUnabridged_Enabled = nil;

function ActionButtonUnabridged_OnLoad()
	ActionButtonUnabridged_Register();
end

function ActionButtonUnabridged_Register()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ABUNABRIDGED_HEADER",
			"SEPARATOR",
			ABUNABRIDGED_CONFIG_HEADER,
			ABUNABRIDGED_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_ABUNABRIDGED_ENABLED",
			"CHECKBOX",
			ABUNABRIDGED_ENABLED,
			ABUNABRIDGED_ENABLED_INFO,
			ActionButtonUnabridged_Toggle_Enabled,
			0
		);
	else
		SlashCmdList["ABUNABRIDGEDSLASHENABLE"] = ActionButtonUnabridged_Enable_ChatCommandHandler;
		SLASH_ABUNABRIDGEDSLASHENABLE1 = "/actionbuttonunabridgedenable";
		SLASH_ABUNABRIDGEDSLASHENABLE2 = "/abuenable";
		SLASH_ABUNABRIDGEDSLASHENABLE3 = "/actionbuttonunabridgeddisable";
		SLASH_ABUNABRIDGEDSLASHENABLE4 = "/abudisable";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local ActionButtonUnabridgedEnableCommands = {"/actionbuttonunabridgedenable","/ldenable","/actionbuttonunabridgeddisable","/lddisable"};
		Cosmos_RegisterChatCommand (
			"ABUNABRIDGED_ENABLE_COMMANDS", -- Some Unique Group ID
			ActionButtonUnabridgedEnableCommands, -- The Commands
			ActionButtonUnabridged_Enable_ChatCommandHandler,
			ABUNABRIDGED_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end

function ActionButtonUnabridged_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		ActionButtonUnabridged_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			ActionButtonUnabridged_Toggle_Enabled(0);
		else
			ActionButtonUnabridged_Toggle_Enabled(-1);
		end
	end
end

function ActionButtonUnabridged_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( ActionButton_SetTooltip ~= ActionButtonUnabridged_ActionButton_SetTooltip ) and (ActionButtonUnabridged_Saved_ActionButton_SetTooltip == nil) ) then
			ActionButtonUnabridged_Saved_ActionButton_SetTooltip = ActionButton_SetTooltip;
			ActionButton_SetTooltip = ActionButtonUnabridged_ActionButton_SetTooltip;
		end
	else
		if ( ActionButton_SetTooltip == ActionButtonUnabridged_ActionButton_SetTooltip) then
			ActionButton_SetTooltip = ActionButtonUnabridged_Saved_ActionButton_SetTooltip;
			ActionButtonUnabridged_Saved_ActionButton_SetTooltip = nil;
		end
	end
end


function ActionButtonUnabridged_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if(Cosmos_RegisterConfiguration == nil) then
			local value = getglobal("COS_ABUNABRIDGED_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			ActionButtonUnabridged_Toggle_Enabled(value);
		end
	end
end

function ActionButtonUnabridged_Toggle_Enabled(toggle)
	local oldvalue = ActionButtonUnabridged_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	ActionButtonUnabridged_Enabled = newvalue;
	setglobal("COS_ABUNABRIDGED_ENABLED_X", newvalue);
	ActionButtonUnabridged_Setup_Hooks(newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			ActionButtonUnabridged_Print(ABUNABRIDGED_CHAT_ENABLED);
		else
			ActionButtonUnabridged_Print(ABUNABRIDGED_CHAT_DISABLED);
		end
	end
	if ( Cosmos_RegisterConfiguration == nil ) then 
		RegisterForSave("COS_ABUNABRIDGED_ENABLED_X");	
	end
end

function ActionButtonUnabridged_ActionButton_SetTooltip()
	if ( ActionButtonUnabridged_Saved_ActionButton_SetTooltip ) then
		ActionButtonUnabridged_Saved_ActionButton_SetTooltip();
	end
	if ( (ActionButtonUnabridged_Enabled == 1) ) then
		local spellName, spellRank = ActionButtonUnabridged_GetSpellNameAndRank("GameTooltip");
		local tmpID, tmpRank;
		for k, v in ActionButtonUnabridged_BookTypes do
			tmpID, tmpRank = ActionButtonUnabridged_FindThingByNameAndRank(spellName, spellRank);
			if (tmpID ~= nil) then
				GameTooltip:SetSpell(tmpID, v);
				return;
			end
		end
	end
end
	
	
function ActionButtonUnabridged_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end

function ActionButtonUnabridged_GetStringsNonNil(stringsElement)
	if ( stringsElement.right ~= nil ) then
		return stringsElement.right;
	end
	if ( stringsElement.left ~= nil ) then
		return stringsElement.left;
	end
	if ( stringsElement ~= nil ) then
		return stringsElement;
	end
	return nil;
end

function ActionButtonUnabridged_GetRankFromString(rankString)
	local foo, bar, spellRank = find(spellRank, "Rank %d");
	return spellRank;
end

function ActionButtonUnabridged_GetSpellNameAndRank(tooltip)
	local strings = ActionButtonUnabridgedTooltip_ScanTooltip(tooltip);
	if ( ( strings ~= nil ) and ( table.getn(strings) > 1) ) then
		local spellName = ActionButtonUnabridged_GetStringsNonNil(strings[1]);
		local spellRank = ActionButtonUnabridged_GetStringsNonNil(strings[2]);
		spellRank = ActionButtonUnabridged_GetRankFromString(spellRank);
		return spellName, spellRank;
	else
		return nil, nil;
	end
end

-- Helper methods from Cosmos
-- All credit should go to the Cosmos team for this one!

-- Gets all lines out of a tooltip.
function ActionButtonUnabridgedTooltip_ScanTooltip(TooltipNameBase)
	if ( TooltipNameBase == nil ) then 
		TooltipNameBase = "ActionButtonUnabridgedTooltip";
	end
	
	local strings = {};
	for idx = 1, 10 do
		local textLeft = nil;
		local textRight = nil;
		ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textLeft = ttext:GetText();
		end
		ttext = getglobal(TooltipNameBase.."TextRight"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textRight = ttext:GetText();
		end
		if (textLeft or textRight)
		then
			strings[idx] = {};
			strings[idx].left = textLeft;
			strings[idx].right = textRight;
		end
	end
	
	return strings;
end

-- Obtains all information about a bag/slot and returns it as an array 
function ActionButtonUnabridgedTooltip_GetItemInfoStrings(bag,slot, TooltipNameBase)
	if ( TooltipNameBase == nil ) then 
		TooltipNameBase = "ActionButtonUnabridgedTooltip";
	end

	--ClearTooltip(TooltipNameBase);

	local tooltip = getglobal(TooltipNameBase);
	
	-- Open tooltip & read contents
	tooltip:SetBagItem( bag, slot );
	local strings = ActionButtonUnabridgedTooltip_ScanTooltip(TooltipNameBase);

	-- Done our duty, send report
	return strings;
end


-- the following was taken and adapted from ActionButtonUnabridged, an AddOn by Munelear.

function ActionButtonUnabridged_findSpell(name,rank,bookType)
	local spellName = nil;
	local subSpellName = nil;
	local i = 1;
	local j = 1;
	
	local tempID,tempRank = nil;
	
	spellName, subSpellName = GetSpellName(i,bookType);
	while spellName do
	  	if ( string.find(spellName,name) ~= nil ) then
	  		if (subSpellName) then
	  			if(rank) then
	  				tempRank = ActionButtonUnabridged_GetRankFromString(subSpellName);
	  				if (tempRank == rank) then
	  					return tempID, tempRank;
	  				end
	  			end
	  		else
	  			if(rank) then
	  			else
					tempID,tempRank = i,0;
				end
	  		end
	  	end

		i = i + 1;
		spellName,subSpellName = nil;
		spellName,subSpellName = GetSpellName(i,bookType);
	end
	
	return tempID,tempRank;
end

