--[[
	CtrlPetCast

	By sarf

	This mod allows you to use Ctrl and cast spells on your pet.

	Thanks goes to SageOHaze on the cosmostesters channel which suggested this.
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=???
   ]]


-- Constants

-- Variables
CtrlPetCast_Saved_UseAction = nil;
CtrlPetCast_Cosmos_Registered = 0;

CtrlPetCast_Enabled = 0;

CtrlPetCast_DebugEnabled = 1;

function CtrlPetCast_OnLoad()
	CtrlPetCast_Register();
end

function CtrlPetCast_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( CtrlPetCast_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_CTRLPETCAST_HEADER",
			"SEPARATOR",
			CTRLPETCAST_CONFIG_HEADER,
			CTRLPETCAST_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_CTRLPETCAST_ENABLED",
			"CHECKBOX",
			CTRLPETCAST_ENABLED,
			CTRLPETCAST_ENABLED_INFO,
			CtrlPetCast_Toggle_Enabled,
			0
		);
		CtrlPetCast_Cosmos_Registered = 1;
	end
end

function CtrlPetCast_Register()
	if ( Cosmos_RegisterConfiguration ) then
		CtrlPetCast_Register_Cosmos();
	else
		SlashCmdList["CTRLPETCASTSLASHENABLE"] = CtrlPetCast_Enable_ChatCommandHandler;
		SLASH_CTRLPETCASTSLASHENABLE1 = "/ctrlpetcastenable";
		SLASH_CTRLPETCASTSLASHENABLE2 = "/cpcenable";
		SLASH_CTRLPETCASTSLASHENABLE3 = "/ctrlpetcastdisable";
		SLASH_CTRLPETCASTSLASHENABLE4 = "/cpcdisable";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local CtrlPetCastEnableCommands = {"/ctrlpetcastenable","/cpcenable","/ctrlpetcastdisable","/cpcdisable"};
		Cosmos_RegisterChatCommand (
			"CTRLPETCAST_ENABLE_COMMANDS", -- Some Unique Pet ID
			CtrlPetCastEnableCommands, -- The Commands
			CtrlPetCast_Enable_ChatCommandHandler,
			CTRLPETCAST_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end

function CtrlPetCast_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		CtrlPetCast_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			CtrlPetCast_Toggle_Enabled(0);
		else
			CtrlPetCast_Toggle_Enabled(-1);
		end
	end
end

function CtrlPetCast_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( UseAction ~= CtrlPetCast_UseAction ) and (CtrlPetCast_Saved_UseAction == nil) ) then
			CtrlPetCast_Saved_UseAction = UseAction;
			UseAction = CtrlPetCast_UseAction;
		end
	else
		if ( UseAction == CtrlPetCast_UseAction) then
			UseAction = CtrlPetCast_Saved_UseAction;
			CtrlPetCast_Saved_UseAction = nil;
		end
	end
end

function CtrlPetCast_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( CtrlPetCast_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_CTRLPETCAST_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			CtrlPetCast_Toggle_Enabled(value);
		end
		return;
	end
end

function CtrlPetCast_Toggle_Enabled(toggle)
	local oldvalue = CtrlPetCast_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	CtrlPetCast_Enabled = newvalue;
	setglobal("COS_CTRLPETCAST_ENABLED_X", newvalue);
	CtrlPetCast_Setup_Hooks(newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			CtrlPetCast_Print(CTRLPETCAST_CHAT_ENABLED);
		else
			CtrlPetCast_Print(CTRLPETCAST_CHAT_DISABLED);
		end
	end
	CtrlPetCast_Register_Cosmos();
	--if ( CtrlPetCast_Cosmos_Registered == 0 ) then 
		RegisterForSave("COS_CTRLPETCAST_ENABLED_X");
	--end
end


function CtrlPetCast_UseAction_Call(id, number, onSelf, override)
	if ( (override == 1) and (AltSelfCast_UseAction) ) then
		if ( CtrlPetCast_Saved_UseAction == AltSelfCast_UseAction ) then
			AltSelfCast_Saved_UseAction(id, number, onSelf);
		else
			CtrlPetCast_Saved_UseAction(id, number, onSelf);
		end
	elseif ( (override == 1) and (CtrlGroupCast_UseAction) ) then
		if ( CtrlPetCast_Saved_UseAction == CtrlGroupCast_UseAction ) then
			CtrlGroupCast_Saved_UseAction(id, number, onSelf);
		else
			CtrlPetCast_Saved_UseAction(id, number, onSelf);
		end
	else
	else
		CtrlPetCast_Saved_UseAction(id, number, onSelf);
	end
end

function CtrlPetCast_HasAPet()
	local unitName = UnitName("pet");
	if ( unitName ) then
		return true;
	else
		return false;
	end
end

function CtrlPetCast_UseAction(id, number, onSelf)
	if ( (CtrlPetCast_Enabled == 1) and ( IsControlKeyDown() ) and (CtrlPetCast_HasAPet()) )  then
		local wantedTarget = "pet";
		local unitName;
		if( UnitIsFriend("player", "target") ) then
			unitName = UnitName("target");
			if ( unitName ~= wantedTarget ) then
				TargetUnit(wantedTarget);
			else
				unitName = nil;
			end
		end
		CtrlPetCast_UseAction_Call(id, number, onSelf, 1);
		if( SpellIsTargeting() ) then
			SpellTargetUnit(wantedTarget);
		end
		if( unitName ) then
			TargetByName(unitName);
		end
	else
		CtrlPetCast_UseAction_Call(id, number, onSelf);
	end
end

function CtrlPetCast_DebugPrint(msg, debugLevel)
	if ( not debugLevel ) then
		debugLevel = 1;
	end
	if ( CtrlPetCast_DebugEnabled >= debugLevel ) then
		CtrlPetCast_Print(msg);
	end
end

function CtrlPetCast_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
