-- the time that is allowed to elapse from automatic dismount to remount. set to nil / 0 to disable this check.
EASYMOUNT_TIMEOUT = 30;

-- how much time to allow the user to loot
EASYMOUNT_TIME_AFTER_LOOT = 1;

-- how much time to allow the user to loot when using a "multiple" gathering skill (i.e. Mining).
EASYMOUNT_TIME_AFTER_LOOT_MULTIPLE = 3;

-- time between updates
EASYMOUNT_TIME_BETWEEN_UPDATES = 0.1;

EASYMOUNT_MAILBOXTIMEOUT = 0.5;


-- maximum time to wait after combat has stopped
EASYMOUNT_COMBATTIMEOUT = 5;

EASYMOUNT_MODE_DOMOUNT = 1;
EASYMOUNT_MODE_DOMAILBOXCHECK = 2;
EASYMOUNT_MODE_DOCOMBATLOOTCHECK = 3;



EasyMount_ShouldMountAt = nil;

EasyMount_Saved_GameTooltip_Show = nil;
EasyMount_Saved_GameTooltip_OnHide = nil;
EasyMount_LastShownTooltip = nil;
EasyMount_LastHiddenTooltip = nil;
EasyMount_LastCombatStopped = nil;
EasyMount_TooltipStrings = {};

EasyMount_HandledItem = nil;
EasyMount_LastDismount = nil;
EasyMount_HasMining = false;
EasyMount_HasHerbalism = false;
EasyMount_HasSkinning = false;
EasyMount_LastMailboxHidden = nil;

EasyMount_Options_Default = {
	["enabled"] = true,
	["handleGathering"] = true,
	["handleMailbox"] = true,
	["remountWhenClosingMailbox"] = true,
	["remountWithMailboxOpen"] = true,
	["gatheringRemountTimeout"] = EASYMOUNT_TIMEOUT,
	["timeAfterLoot"] = EASYMOUNT_TIME_AFTER_LOOT,
	["timeAfterLootMultiple"] = EASYMOUNT_TIME_AFTER_LOOT_MULTIPLE,
	["mailboxTooltipTimeout"] = EASYMOUNT_MAILBOXTIMEOUT,
	["mountAfterCombat"] = false,
	["timeToMountAfterCombat"] = EASYMOUNT_COMBATTIMEOUT
};

EasyMount_Options = EasyMount_Options_Default;


function EasyMount_OnLoad()
	EasyMount_Options_OnLoad();
	
	EasyMount_Saved_GameTooltip_Show = GameTooltip.Show;
	GameTooltip.Show = EasyMount_GameTooltip_Show;
	EasyMount_Saved_GameTooltip_OnHide = GameTooltip_OnHide;
	GameTooltip_OnHide = EasyMount_GameTooltip_OnHide;

	local f = EasyMountFrame;
	f:RegisterEvent("VARIABLES_LOADED");
	f:RegisterEvent("SPELLS_CHANGED");
	f:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
	f:RegisterEvent("UI_ERROR_MESSAGE");
	f:RegisterEvent("MAIL_SHOW");
	f:RegisterEvent("MAIL_CLOSED");
	f:RegisterEvent("PLAYER_LEAVE_COMBAT");
	f:RegisterEvent("LOOT_OPENED");
end

function EasyMount_InStealth(state)
	local buff = nil;
	for i = 0, 15 do
		buff = GetPlayerBuffTexture(i);
		if ( buff ) and ( buff == "Interface\\Icons\\Ability_Stealth" ) then
			return true;
		end
	end
	return false;
end

function EasyMount_TurnOrAction(state)
	if ( EasyMount_Options.enabled ) and ( EasyMount_Options.handleMailbox ) then
		local mountBuffPos = AutoMount_GetMountBuffPosition();
		if ( mountBuffPos > -1 ) then
			local mountBuffPos = AutoMount_GetMountBuffPosition();
			if ( mountBuffPos > -1 ) then
				local mailboxStr = EasyMount_DismountableStringsMailbox;
				if ( EasyMount_TooltipStrings[1] == mailBoxStr ) then
					EasyMount_Dismount(mountBuffPos, mailBoxStr);
				end
			end
		end
	end
	EasyMount_TurnOrAction(state);
end

function EasyMount_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		EasyMount_SetupGatheringSkills();
		EasyMountFrame:UnregisterEvent(event);
		for k, v in EasyMount_Options_Default do
			if ( EasyMount_Options[k] == nil ) then
				EasyMount_Options[k] = v;
			end
		end
	end
	if ( event == "SPELLS_CHANGED" ) then
		EasyMount_SetupGatheringSkills();
	end
	if ( event == "CHAT_MSG_SPELL_SELF_BUFF" ) then
		EasyMount_HandlePerformChat(arg1);
	end
	if ( event == "MAIL_CLOSED" ) then
		if ( EasyMount_Options.enabled ) and ( EasyMount_Options.handleMailbox ) then
			if ( EasyMount_Options.remountWhenClosingMailbox ) then
				if ( not MailFrame:IsVisible() ) then
					EasyMount_Mount();
				end
			end
		end
	end
	if ( event == "MAIL_SHOW" ) then
		if ( EasyMount_Options.enabled ) and ( EasyMount_Options.handleMailbox ) then
			if ( EasyMount_Options.remountWithMailboxOpen ) then
				EasyMount_Mount();
			end
		end
	end
	if ( event == "UI_ERROR_MESSAGE" ) then
		if ( arg1 == SPELL_FAILED_NOT_MOUNTED ) then
			if ( not UnitOnTaxi("player") ) then
				EasyMount_FixMount();
			end
		end
	end
	if ( event == "PLAYER_LEAVE_COMBAT" ) then
		EasyMount_MountAfterCombat();
	end
	if ( event == "LOOT_OPENED" ) then
		-- TODO: add gathering check here too? hmm... not necessary tho
		if ( EasyMount_Mode == EASYMOUNT_MODE_DOCOMBATLOOTCHECK ) then
			EasyMount_ShouldMountAt = GetTime() + 1;
			EasyMount_SetMode(EASYMOUNT_MODE_DOMOUNT);
		end
	end
end

function EasyMount_MountAfterCombat()
	if ( EasyMount_Options.enabled ) and ( EasyMount_Options.mountAfterCombat ) and ( not EasyMount_InStealth() ) then
		local mountBuffPos = AutoMount_GetMountBuffPosition();
		if ( mountBuffPos > -1 ) then
			return true;
		end
		EasyMount_LastCombatStopped = GetTime();
		EasyMount_SetMode(EASYMOUNT_MODE_DOCOMBATLOOTCHECK);
	end
end


EasyMount_TooltipTextLeftNames = {
	[1] = "GameTooltipTextLeft1",
	[2] = "GameTooltipTextLeft2",
	[3] = "GameTooltipTextLeft3",
	[4] = "GameTooltipTextLeft4",
};

function EasyMount_GameTooltip_Show(tooltip)
	if ( EasyMount_Options.enabled ) and ( tooltip == GameTooltip ) then
		local curTime = GetTime();
		local obj = nil;
		for k, v in EasyMount_TooltipTextLeftNames do
			obj = getglobal(v);
			if ( obj ) then
				EasyMount_TooltipStrings[k] = obj:GetText();
			end
		end
		EasyMount_LastShownTooltip = curTime;
	end
	EasyMount_Saved_GameTooltip_Show(tooltip);
end

EasyMount_GameTooltip_OnHide_OldText = nil;

function EasyMount_GameTooltip_OnHide(tooltip)
	if ( not EasyMount_Options.enabled ) then
	elseif ( MailFrame:IsVisible() ) then
		EasyMount_LastMailboxHidden = nil;
	elseif ( ( not tooltip ) or ( tooltip == GameTooltip ) ) then
		local curTime = GetTime();
		local newvalue = nil;
		local obj = getglobal(EasyMount_TooltipTextLeftNames[1]);
		if ( obj ) then
			local oldFirst = obj:GetText();
			if ( oldFirst ) and ( oldFirst == EasyMount_DismountableStringsMailbox ) and ( oldFirst == EasyMount_GameTooltip_OnHide_OldText ) then 
				newvalue = curTime;
				EasyMount_LastMailboxHidden = newvalue;
			end
			EasyMount_GameTooltip_OnHide_OldText = oldFirst;
		end
		EasyMount_LastHiddenTooltip = curTime;
		if ( newvalue ) then
			EasyMount_SetMode(EASYMOUNT_MODE_DOMAILBOXCHECK);
		end
	end
	EasyMount_Saved_GameTooltip_OnHide(tooltip);
end

function EasyMount_HandlePerformed(action)
	if ( not EasyMount_Options.enabled ) then
		return false;
	end
	if ( not action ) then
		return false;
	end
	local ok = false;
	for k, v in EasyMount_Chat_SkillNames do
		if ( v == action ) then
			ok = true;
		end
	end
	if ( not ok ) then
		return false;
	end
	local n = tonumber(EasyMount_Options.gatheringRemountTimeout);
	if ( n ) then
		if ( not EasyMount_LastDismount ) or ( GetTime() - n > EASYMOUNT_TIMEOUT ) then
			return false;
		end
	end
	
	-- fix for mining
	local addTime = tonumber(EasyMount_Options.timeAfterLoot);
	for k, v in EasyMount_SkillNames_Multiple do
		if ( v == action ) then
			addTime = tonumber(EasyMount_Options.timeAfterLootMultiple);
			break;
		end
	end
	EasyMount_LastDismount = EasyMount_LastDismount + addTime;
	EasyMount_ShouldMountAt = GetTime() + addTime;
	EasyMount_SetMode(EASYMOUNT_MODE_DOMOUNT);
	return true;
end

function EasyMount_HandlePerformChat(msg)
	if ( not EasyMount_Options.enabled ) then
		return false;
	end
	if ( not EasyMount_Options.handleGathering ) then
		return false;
	end
	local pattern = nil;
	local index = nil;
	for k, v in EasyMount_Chat_PerformPatterns do
		pattern = v.pattern;
		index = v.actionIndex;
		for p1, p2, p3 in string.gfind(msg, pattern) do
			if ( index == 1 ) then
				EasyMount_HandlePerformed(p1);
			elseif ( index == 2 ) then
				EasyMount_HandlePerformed(p2);
			elseif ( index == 3 ) then
				EasyMount_HandlePerformed(p3);
			end
		end
	end
end


function EasyMount_SetupGatheringSkills()
	local spellName = nil;
	EasyMount_HasMining = false;
	EasyMount_HasHerbalism = false;
	EasyMount_HasSkinning = false;
	for i = 1, 150 do
		spellName = GetSpellName(i, "spell");
		if ( not spellName ) then
			break;
		end
		if ( spellName == EasyMount_Skill_Mining ) then
			EasyMount_HasMining = true;
		end
		if ( spellName == EasyMount_Skill_Herbalism ) then
			EasyMount_HasHerbalism = true;
		end
		if ( spellName == EasyMount_Skill_Skinning ) then
			EasyMount_HasSkinning = true;
		end
	end
	EasyMount_SetupDismountableStrings();
end

function EasyMount_SetupDismountableStrings()
	EasyMount_DismountableStrings = {};
	if ( EasyMount_HasMining ) then
		for k, v in EasyMount_DismountableStringsMining do
			table.insert(EasyMount_DismountableStrings, v);
		end
	end
	if ( EasyMount_HasHerbalism ) then
		for k, v in EasyMount_DismountableStringsHerbalism do
			table.insert(EasyMount_DismountableStrings, v);
		end
	end
	for k, v in EasyMount_DismountableStringsOther do
		table.insert(EasyMount_DismountableStrings, v);
	end
end

function EasyMount_FixMount()
	if ( not EasyMount_Options.enabled ) then
		return false;
	end
	if ( UnitOnTaxi("player") ) then
		return false;
	end
	local curTime = GetTime();
	if ( not EasyMount_LastShownTooltip ) or ( curTime - EasyMount_LastShownTooltip > 1 ) then
		return false;
	end
	EasyMount_LastShownTooltip = nil;
	return EasyMount_CheckTooltipAndDismount();
end

function EasyMount_Dismount(mountBuffPos, itemName)
	if ( not mountBuffPos ) then
		mountBuffPos = AutoMount_GetMountBuffPosition();
	end
	if ( mountBuffPos <= -1 ) then
		return false;
	end
	if ( itemName ) then
		EasyMount_HandledItem = itemName;
	end
	CancelPlayerBuff(mountBuffPos);
	EasyMount_LastDismount = GetTime();
	return true;
end

function EasyMount_CheckTooltipAndDismount()
	if ( not EasyMount_Options.enabled ) then
		return false;
	end
	if ( UnitOnTaxi("player") ) then
		return false;
	end
	local mountBuffPos = AutoMount_GetMountBuffPosition();
	if ( mountBuffPos > -1 ) then
		local obj = nil;
		if ( EasyMount_HasSkinning ) then
			local msg = nil;
			for i = 3, 4 do
				msg = EasyMount_TooltipStrings[i];
				if ( msg ) and ( strlen(msg) > 0 ) then
					for k, v in EasyMount_DismountableStringsSkinning do
						EasyMount_Dismount(mountBuffPos, v);
						return true;
					end
				end
			end
		end
		local msg = EasyMount_TooltipStrings[1];
		if ( msg ) and ( strlen(msg) > 0 ) then
			for k, v in EasyMount_DismountableStrings do
				if ( string.find(msg, v) ) then
					EasyMount_Dismount(mountBuffPos, v);
					return true;
				end
			end
		end
	end
	return false;
end

function EasyMount_Mount()
	local mountBuffPos = AutoMount_GetMountBuffPosition();
	if ( mountBuffPos > -1 ) then
		return true;
	end
	if ( not EasyMount_Options.enabled ) then
		return false;
	end
	if ( PlayerFrame.inCombat ) then
		return false;
	end
	local bag, slot = AutoMount_GetMountItemBagSlot();
	if ( not bag ) or ( not slot ) then
		return false;
	end
	UseContainerItem(bag, slot);
	return true;
end

EasyMount_Mode = 0;
EasyMount_LastUpdate = 0;

function EasyMount_SetMode(mode)
	EasyMount_Mode = mode;
	if ( mode <= 0 ) then
		EasyMountFrame:Hide();
	else
		EasyMountFrame:Show();
	end
end

function EasyMount_OnUpdate(arg1)
	if ( not EasyMount_Options.enabled ) then
		EasyMountFrame:Hide();
		return false;
	end
	local curTime = GetTime();
	local diff = curTime - EasyMount_LastUpdate;
	if ( diff < EASYMOUNT_TIME_BETWEEN_UPDATES ) then
		return false;
	end
	EasyMount_LastUpdate = curTime;
	if ( EasyMount_Mode == EASYMOUNT_MODE_DOMOUNT ) then
		if ( EasyMount_ShouldMountAt ) then
			if ( not LootFrame:IsVisible() ) then
				if ( curTime >= EasyMount_ShouldMountAt ) then
					EasyMount_Mount();
					EasyMount_ShouldMountAt = nil;
					EasyMountFrame:Hide();
				end
			end
		else
			EasyMountFrame:Hide();
		end
	elseif ( EasyMount_Mode == EASYMOUNT_MODE_DOMAILBOXCHECK ) then
		local isVisible = MailFrame:IsVisible();
		if ( isVisible ) or ( not EasyMount_LastMailboxHidden ) then
			EasyMount_LastMailboxHidden = nil;
			EasyMountFrame:Hide();
		else
			if ( curTime - EasyMount_LastMailboxHidden > tonumber(EasyMount_Options.mailboxTooltipTimeout)) then
				local mountBuffPos = AutoMount_GetMountBuffPosition();
				if ( mountBuffPos > -1 ) then
					EasyMount_Dismount(mountBuffPos, EasyMount_DismountableStringsMailbox);
				end
				EasyMount_LastMailboxHidden = nil;
				EasyMountFrame:Hide();
			end
		end
	elseif ( EasyMount_Mode == EASYMOUNT_MODE_DOCOMBATLOOTCHECK ) then
		if ( PlayerFrame.inCombat ) or ( not EasyMount_LastCombatStopped ) then
			EasyMountFrame:Hide();
			return;
		end
		local isVisible = LootFrame:IsVisible();
		if ( isVisible ) then
			EasyMount_ShouldMountAt = GetTime() + 1;
			EasyMount_SetMode(EASYMOUNT_MODE_DOMOUNT);
		else
			if ( curTime - EasyMount_LastCombatStopped > tonumber(EasyMount_Options.timeToMountAfterCombat)) then
				EasyMount_Mount();
				local mountBuffPos = AutoMount_GetMountBuffPosition();
				if ( mountBuffPos > -1 ) then
					EasyMount_Dismount(mountBuffPos, EasyMount_DismountableStringsMailbox);
				end
				EasyMount_LastMailboxHidden = nil;
				EasyMountFrame:Hide();
			end
		end
	else
		EasyMountFrame:Hide();
	end
end