-- EASYMOUNT_COMBAT START

EASYMOUNT_KHAOS_FOLDER_ID			= "EasyMountID";
EASYMOUNT_KHAOS_SET_EASY_ID			= "EasyMountBasicSetID";
EASYMOUNT_KHAOS_SET_ADVANCED_ID		= "EasyMountAdvancedSetID";

function EasyMount_UpdateValue(name, value, cosName)
	if ( not name ) then
		return false;
	end
	EasyMount_Options[name] = value;
	if ( cosName ) then
		if ( value == true ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 1);
		elseif ( value == false ) or ( value == nil ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 0);
		else
			AddOnHelper_Generic_CosmosUpdateValue(cosName, value);
		end
	end
end

function EasyMount_Get_Khaos_CheckBox(pid, pkey, ptext, phelptext, pcheck, cb)
	local option1 = {
		id = pid;
		key = pkey;
		text = ptext;
		helptext = phelptext;
		check = true;
		callback = cb;
		type = K_TEXT;
		feedback = function(state) local s = EASYMOUNT_STATE_ENABLED; if ( not state.checked ) then s = EASYMOUNT_STATE_DISABLED; end return EASYMOUNT_KHAOS_GATHERING_TEXT.." "..s; end;
		default = {
			checked = pcheck;
		};
		disabled = {
			checked = false;
		};
	};
	return option1;
end

EasyMount_Folder = {
	id = EASYMOUNT_KHAOS_FOLDER_ID;
	text = EASYMOUNT_KHAOS_FOLDER_TEXT;
	helptext = EASYMOUNT_KHAOS_FOLDER_HELP;
	difficulty = 1;
};
function EasyMount_Register_Khaos()
	if ( not Khaos ) then
		return false;
	end
	Khaos.registerFolder(EasyMount_Folder);

	local optionSetEasy = {
		id = EASYMOUNT_KHAOS_SET_EASY_ID;
		text = EASYMOUNT_KHAOS_EASYSET_TEXT;
		helptext = EASYMOUNT_KHAOS_EASYSET_HELP;
		difficulty = 1;
		options = {};
		default = true;
	};

	local cb = function(state) EasyMount_UpdateValue("enabled", state.checked, "COS_EASYMOUNT_ENABLED"); end;
	table.insert(optionSetEasy.options, EasyMount_Get_Khaos_CheckBox("CheckBoxEnabled", "enabled", EASYMOUNT_KHAOS_ENABLE_TEXT, EASYMOUNT_KHAOS_ENABLE_HELP, true, cb));
	local cb2 = function(state) EasyMount_UpdateValue("handleGathering", state.checked, "COS_EASYMOUNT_GATHERING"); end;
	table.insert(optionSetEasy.options, EasyMount_Get_Khaos_CheckBox("CheckBoxGathering", "handleGathering", EASYMOUNT_KHAOS_GATHERING_TEXT, EASYMOUNT_KHAOS_GATHERING_HELP, true, cb2));
	local cb3 = function(state) EasyMount_UpdateValue("handleMailbox", state.checked, "COS_EASYMOUNT_MAILBOX"); end;
	table.insert(optionSetEasy.options, EasyMount_Get_Khaos_CheckBox("CheckBoxMailbox", "handleMailbox", EASYMOUNT_KHAOS_MAILBOX_TEXT, EASYMOUNT_KHAOS_MAILBOX_HELP, true, cb3));
	-- EASYMOUNT_COMBAT START
	local cb4 = function(state) EasyMount_UpdateValue("mountAfterCombat", state.checked, "COS_EASYMOUNT_COMBAT"); end;
	--table.insert(optionSetEasy.options, EasyMount_Get_Khaos_CheckBox("CheckBoxMountAfterCombat", "mountAfterCombat", EASYMOUNT_KHAOS_COMBAT_TEXT, EASYMOUNT_KHAOS_COMBAT_HELP, false, cb3));
	-- EASYMOUNT_COMBAT END

	local optionSetAdvanced = {
		id = EASYMOUNT_KHAOS_SET_ADVANCED_ID;
		text = EASYMOUNT_KHAOS_ADVANCEDSET_TEXT;
		helptext = EASYMOUNT_KHAOS_ADVANCEDSET_HELP;
		difficulty = 3;
		options = {};
		default = true;
	};

	local cb5 = function(state) EasyMount_UpdateValue("remountWhenClosingMailbox", state.checked); end;
	table.insert(optionSetAdvanced.options, EasyMount_Get_Khaos_CheckBox("CheckBoxMailboxClose", "remountWhenClosingMailbox", EASYMOUNT_KHAOS_MBREMOUNTCLOSE_TEXT, EASYMOUNT_KHAOS_MBREMOUNTCLOSE_HELP, true, cb5));
	local cb6 = function(state) EasyMount_UpdateValue("remountWhenClosingMailbox", state.checked); EasyMount_Options.remountWithMailboxOpen = state.checked; end;
	table.insert(optionSetAdvanced.options, EasyMount_Get_Khaos_CheckBox("CheckBoxMailboxOpen", "remountWithMailboxOpen", EASYMOUNT_KHAOS_MBREMOUNTOPEN_TEXT, EASYMOUNT_KHAOS_MBREMOUNTOPEN_HELP, true, cb6));

	local optionGatherRemountTimeout = {
		id = "SliderGatherRemountTimeout";
		key = "gatheringRemountTimeout";
		value = "15";
		text = EASYMOUNT_KHAOS_GATHER_TIMEOUT_TEXT;
		helptext = EASYMOUNT_KHAOS_GATHER_TIMEOUT_HELP;
		callback = function(state) EasyMount_UpdateValue("gatheringRemountTimeout", state.value); end;
		type = K_SLIDER;
		feedback = function(state) if ( state.value == 0 ) then return EASYMOUNT_KHAOS_GATHER_TIMEOUT_NONE; end return string.format(EASYMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0;
			sliderMax = 60;
			sliderStep = 1;
		};
		default = {
			checked = true;
			value = "30";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionGatherRemountTimeout);
	local optionTimeAfterLoot = {
		id = "SliderTimeAfterLoot";
		key = "timeAfterLoot";
		value = "1";
		text = EASYMOUNT_KHAOS_TIME_AFTER_LOOT_TEXT;
		helptext = EASYMOUNT_KHAOS_TIME_AFTER_LOOT_HELP;
		callback = function(state) EasyMount_UpdateValue("timeAfterLoot", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(EASYMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0.5;
			sliderMax = 10;
			sliderStep = 0.5;
		};
		default = {
			checked = true;
			value = "1";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionTimeAfterLoot);
	local optionTimeAfterLootMult = {
		id = "SliderTimeAfterLootMult";
		key = "timeAfterLootMultiple";
		value = "3";
		text = EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_TEXT;
		helptext = EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_HELP;
		callback = function(state) EasyMount_UpdateValue("timeAfterLootMultiple", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0.5;
			sliderMax = 15;
			sliderStep = 0.5;
		};
		default = {
			checked = true;
			value = "3";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionTimeAfterLootMult);
	local optionMailBoxTooltipTimeout = {
		id = "SliderMailBoxTooltipTimeout";
		key = "mailboxTooltipTimeout";
		value = "0.5";
		text = EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_TEXT;
		helptext = EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_HELP;
		callback = function(state) EasyMount_UpdateValue("mailboxTooltipTimeout", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0.1;
			sliderMax = 2;
			sliderStep = 0.1;
		};
		default = {
			checked = true;
			value = "0.5";
		};
		disabled = {
			checked = false;
		};
	};

	table.insert(optionSetAdvanced.options, optionMailBoxTooltipTimeout);
	local optionCombatTimeToWaitBeforeRemount = {
		id = "SliderTimeToMountAfterCombat";
		key = "timeToMountAfterCombat";
		value = "5";
		text = EASYMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT;
		helptext = EASYMOUNT_KHAOS_COMBAT_TIMEOUT_HELP;
		callback = function(state) EasyMount_UpdateValue("timeToMountAfterCombat", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(EASYMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT, state.value); end;
		setup = {
			sliderMin = 1;
			sliderMax = 30;
			sliderStep = 1;
		};
		default = {
			checked = true;
			value = "5";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionCombatTimeToWaitBeforeRemount);
	Khaos.registerOptionSet( EasyMount_Folder.id, optionSetEasy );
	Khaos.registerOptionSet( EasyMount_Folder.id, optionSetAdvanced );
	return true;
end

-- /script Old_EasyMount_DoToggle_Checkbox = EasyMount_DoToggle_Checkbox; EasyMount_DoToggle_Checkbox = function(a, b, c, d, ...) PrintTable({a, b, d}); return Old_EasyMount_DoToggle_Checkbox(a, b, c, d, unpack(arg)); end;
-- /script EasyMount_DoToggle_Checkbox = Old_EasyMount_DoToggle_Checkbox

function EasyMount_DoToggle_Checkbox(cosName, varName, chatFormat, toggle, nochat)
	local newValue = nil;
	if ( toggle == 1 ) then
		newValue = true;
	else
		newValue = false;
	end
	EasyMount_Options[varName] = newValue;
	AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, toggle);
	if ( Khaos ) and ( varName ) then
		local v = Khaos.getSetKey(EASYMOUNT_KHAOS_SET_EASY_ID, varName);
		if ( v ) then
			Khaos.setSetKeyParameter(EASYMOUNT_KHAOS_SET_EASY_ID, varName, "checked", newValue);
			Khaos.updateFolder(EasyMount_Folder);
		end
	end
	if ( not nochat ) then
		if ( EasyMount_Options[varName] ) then
			AddOnHandler_Print(string.format(chatFormat), EASYMOUNT_STATE_ENABLED);
		else
			AddOnHandler_Print(string.format(chatFormat), EASYMOUNT_STATE_DISABLED);
		end
	end
	return newValue;
end

function EasyMount_DoToggle_Enabled(toggle, nochat)
	return EasyMount_DoToggle_Checkbox("COS_EASYMOUNT_ENABLED", "enabled", EASYMOUNT_CHAT_STATE, toggle, nochat);
end

function EasyMount_Toggle_Enabled(toggle)
	return EasyMount_DoToggle_Enabled(toggle);
end

function EasyMount_Toggle_Enabled_NoChat(toggle)
	return EasyMount_DoToggle_Enabled(toggle, true);
end

function EasyMount_DoToggle_Gathering(toggle, nochat)
	return EasyMount_DoToggle_Checkbox("COS_EASYMOUNT_GATHERING", "handleGathering", EASYMOUNT_CHAT_GATHERING, toggle, nochat);
end

function EasyMount_Toggle_Gathering(toggle)
	return EasyMount_DoToggle_Gathering(toggle);
end

function EasyMount_Toggle_Gathering_NoChat(toggle)
	return EasyMount_DoToggle_Gathering(toggle, true);
end

function EasyMount_DoToggle_Mailbox(toggle, nochat)
	return EasyMount_DoToggle_Checkbox("COS_EASYMOUNT_MAILBOX", "handleMailbox", EASYMOUNT_CHAT_MAILBOX, toggle, nochat);
end

function EasyMount_Toggle_Mailbox(toggle)
	return EasyMount_DoToggle_Mailbox(toggle);
end

function EasyMount_Toggle_Mailbox_NoChat(toggle)
	return EasyMount_DoToggle_Mailbox(toggle, true);
end

function EasyMount_DoToggle_Combat(toggle, nochat)
	return EasyMount_DoToggle_Checkbox("COS_EASYMOUNT_COMBAT", "mountAfterCombat", EASYMOUNT_CHAT_COMBAT, toggle, nochat);
end

function EasyMount_Toggle_Combat(toggle)
	return EasyMount_DoToggle_Combat(toggle);
end

function EasyMount_Toggle_Combat_NoChat(toggle)
	return EasyMount_DoToggle_Combat(toggle, true);
end



function EasyMount_GetCosmosCheckboxState(var)
	if ( EasyMount_Options[var] ) then
		return 1;
	else
		return 0;
	end
end

function EasyMount_Register_Cosmos()
	if ( Cosmos_RegisterConfiguration ) and ( Cosmos_UpdateValue ) then
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT",
			"SECTION",
			TEXT(EASYMOUNT_CONFIG_HEADER),
			TEXT(EASYMOUNT_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT_HEADER",
			"SEPARATOR",
			TEXT(EASYMOUNT_CONFIG_HEADER),
			TEXT(EASYMOUNT_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT_ENABLED",
			"CHECKBOX",
			TEXT(EASYMOUNT_KHAOS_ENABLE_TEXT),
			TEXT(EASYMOUNT_KHAOS_ENABLE_HELP),
			EasyMount_Toggle_Enabled_NoChat,
			EasyMount_GetCosmosCheckboxState("enabled")
		);
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT_GATHERING",
			"CHECKBOX",
			TEXT(EASYMOUNT_KHAOS_GATHERING_TEXT),
			TEXT(EASYMOUNT_KHAOS_GATHERING_HELP),
			EasyMount_Toggle_Gathering_NoChat,
			EasyMount_GetCosmosCheckboxState("handleGathering")
		);
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT_MAILBOX",
			"CHECKBOX",
			TEXT(EASYMOUNT_KHAOS_MAILBOX_TEXT),
			TEXT(EASYMOUNT_KHAOS_MAILBOX_HELP),
			EasyMount_Toggle_Mailbox_NoChat,
			EasyMount_GetCosmosCheckboxState("handleMailbox")
		);
	-- EASYMOUNT_COMBAT START
		--[[
		Cosmos_RegisterConfiguration(
			"COS_EASYMOUNT_COMBAT",
			"CHECKBOX",
			TEXT(EASYMOUNT_KHAOS_COMBAT_TEXT),
			TEXT(EASYMOUNT_KHAOS_COMBAT_HELP),
			EasyMount_Toggle_Combat_NoChat,
			EasyMount_GetCosmosCheckboxState("mountAfterCombat")
		);
		]]--
	-- EASYMOUNT_COMBAT END
	end
end


function EasyMount_Usage()
	for k, v in EASYMOUNT_OPTIONS_CMD_USAGE do
		AddOnHelper_Print(v);
	end
end

function EasyMount_SlashCommand_Set(msg)
	local featString, params = AddOnHelper_Extract_NextParameter(msg);
	local feat = nil;
	for k, v in EASYMOUNT_OPTIONS_SLASH_FEAT do
		if ( AddOnHelper_IsValueInList(featString, v) ) then
			feat = k;
			break;
		end
	end
	if ( not feat ) then
		AddOnHelper_Print(EASYMOUNT_ERROR_ILLEGAL_FEAT, 1, 0.2, 0.2);
		EasyMount_Usage()
		return false;
	end
	local valueString;
	valueString, params = AddOnHelper_Extract_NextParameter(params);
	local value = tonumber(valueString);
	if ( not value ) then
		AddOnHelper_Print(EASYMOUNT_ERROR_NO_VALUE_TO_SET);
		return false;
	end
	
	if ( not AddOnHelper_IsValueInList(feat, EASYMOUNT_CMD_FEAT_VALID[cmd]) ) then
		for k, v in EASYMOUNT_SET_FEAT_VALID_VALUE do
			if ( value == v ) then
				local featFunc = EasyMount_SlashCommandArray[k];
				if ( featFunc ) then
					return featFunc(msg);
				end
			end
		end
		AddOnHelper_Print(string.format(EASYMOUNT_ERROR_WRONG_CMD_FEAT, EASYMOUNT_WRONG_CMD_FEAT[cmd]));
		return false;
	end
	EasyMount_Options[optionsPtr] = newState;
	if ( Cosmos_UpdateValue ) then
		local cosName = EASYMOUNT_FEAT_COSMOS_MAP[feat];
		if ( cosName ) then
			AddOnHelper_Generic_CosmosUpdateValue(cosName, value);
		end
	end
	if ( Khaos ) then
		local v = Khaos.getSetKey(EASYMOUNT_KHAOS_SET_EASY_ID, optionsPtr);
		if ( v ) then
			Khaos.setSetKeyParameter(EASYMOUNT_KHAOS_SET_EASY_ID, optionsPtr, "value", value);
			Khaos.updateFolder(EasyMount_Folder);
		end
	end

	AddOnHelper_Print(string.format(EASYMOUNT_CMD_SET_CHAT_STATE[feat], value));
	return true;
end

function EasyMount_SlashCommand_CheckBox(msg, cmd, newValue)
	local featString, params = AddOnHelper_Extract_NextParameter(msg);
	local feat = nil;
	for k, v in EASYMOUNT_OPTIONS_SLASH_FEAT do
		if ( AddOnHelper_IsValueInList(featString, v) ) then
			feat = k;
			break;
		end
	end
	if ( not feat ) and ( strlen(featString) <= 0 ) then
		feat = "main";
	end
	if ( not feat ) then
		AddOnHelper_Print(EASYMOUNT_ERROR_ILLEGAL_FEAT, 1, 0.2, 0.2);
		EasyMount_Usage()
		return false;
	end
	if ( not AddOnHelper_IsValueInList(feat, EASYMOUNT_CMD_FEAT_VALID[cmd]) ) then
		AddOnHelper_Print(string.format(EASYMOUNT_ERROR_WRONG_CMD_FEAT, EASYMOUNT_WRONG_CMD_FEAT[cmd]));
		return false;
	end
	
	local optionsPtr = EASYMOUNT_FEAT_OPTIONS_MAP[feat];
	local oldState = EasyMount_Options[optionsPtr];
	local newState = true;
	if ( newValue == -1 ) then
		if ( oldState ) then
			newState = false;
		end
	elseif( newValue == 0 ) then
		newState = false;
	end
	EasyMount_Options[optionsPtr] = newState;
	if ( Cosmos_UpdateValue ) then
		local cosName = EASYMOUNT_FEAT_COSMOS_MAP[feat];
		if ( cosName ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, EasyMount_GetCosmosCheckboxState(optionsPtr));
		end
	end
	if ( Khaos ) then
		local v = Khaos.getSetKey(EASYMOUNT_KHAOS_SET_EASY_ID, optionsPtr);
		if ( v ) then
			Khaos.setSetKeyParameter(EASYMOUNT_KHAOS_SET_EASY_ID, optionsPtr, "checked", newValue);
			Khaos.updateFolder(EasyMount_Folder);
		end
	end
	local stateStr = EASYMOUNT_STATE_ENABLED;
	if ( not newState ) then
		stateStr = EASYMOUNT_STATE_DISABLED;
	end
	AddOnHelper_Print(string.format(EASYMOUNT_CMD_CHECKBOX_CHAT_STATE[feat], stateStr));
	return true;
end

function EasyMount_SlashCommand_Toggle(msg)
	return EasyMount_SlashCommand_CheckBox(msg, "toggle", -1);
end

function EasyMount_SlashCommand_Enable(msg)
	return EasyMount_SlashCommand_CheckBox(msg, "enable", 1);
end

function EasyMount_SlashCommand_Disable(msg)
	return EasyMount_SlashCommand_CheckBox(msg, "disable", 0);
end

EasyMount_SlashCommandArray = {};
EasyMount_SlashCommandArray["help"] = EasyMount_Usage;
EasyMount_SlashCommandArray["toggle"] = EasyMount_SlashCommand_Toggle;
EasyMount_SlashCommandArray["enable"] = EasyMount_SlashCommand_Enable;
EasyMount_SlashCommandArray["disable"] = EasyMount_SlashCommand_Disable;
EasyMount_SlashCommandArray["set"] = EasyMount_SlashCommand_Set;

function EasyMount_SlashCommand(msg)
	if ( not msg ) or ( strlen(msg) <= 0 ) then
		EasyMount_Usage();
		return false;
	end
	local cmd, params = AddOnHelper_Extract_NextParameter(msg);
	if ( not cmd ) or ( strlen(cmd) <= 0 ) then
		EasyMount_Usage();
		return false;
	else
		local lcmd = string.lower(cmd);
		for k, v in EasyMount_SlashCommandArray do
			if ( AddOnHelper_IsValueInList(lcmd, EASYMOUNT_OPTIONS_SLASH_CMDS[k] ) ) then
				return v(params);
			end
		end
		EasyMount_Usage();
		return false;
	end
end

function EasyMount_Register_SlashCommands()
	local arr = {
		identifier = "EASYMOUNTSLASHCMD",
		slashcommands = EASYMOUNT_OPTIONS_CMD,
		func = EasyMount_SlashCommand,
		description = EASYMOUNT_OPTIONS_CMD_DESC,
	};
	AddOnHelper_AddSlashCommandTable(arr);
end


function EasyMount_Options_OnLoad()
	EasyMount_Register_SlashCommands();
	EasyMount_Register_Khaos();
	EasyMount_Register_Cosmos();
end
