EasyMount_Skill_Herbalism = "Find Herbs";
EasyMount_Skill_Mining = "Find Minerals";
EasyMount_Skill_Skinning = "Skinning";

EasyMount_Chat_PerformPatterns = {
	{ 
		["pattern"] = "You perform (.+) on (.+).",
		["actionIndex"] = 1
	},
}

EasyMount_SkillNames_Multiple = {
	"Mining",
};

EasyMount_Chat_SkillNames = {
	"Opening",
	"Herb Gathering",
	"Mining",
	"Skinning",
};


EasyMount_DismountableStringsSkinning = {
	"Skinnable",
};

EasyMount_DismountableStringsMining = {
	"Copper",
	"Tin",
	"Iron",
	"Silver",
	"Truesilver",
	"Gold",
	"Mithril",
	"Thorium",
};

EasyMount_DismountableStringsHerbalism = {
	-- herb types 
	"Arthas' Tears",
	"Black Lotus",
	"Blindweed",
	"Briarthorn",
	"Bruiseweed",
	"Dreamfoil",
	"Earthroot",
	"Fadeleaf",
	"Firebloom",
	"Ghost Mushroom",
	"Golden Sansam",
	"Goldthorn",
	"Grave Moss",
	"Gromsblood",
	"Icecap",
	"Khadgar's Whisker",
	"Kingsblood",
	"Liferoot",
	"Mageroyal",
	"Mountain Silversage",
	"Peacebloom",
	"Plaguebloom",
	"Purple Lotus",
	"Silverleaf",
	"Stranglekelp",
	"Sungrass",
	"Swiftthistle",
	"Wild Steelbloom",
	"Wintersbite",
	"Wildvine",
};

EasyMount_DismountableStringsOther = {
	"Box",
	"Chest",
	"Giant Clam",
	"Crate",
	"Barrel",
	"Cask",
	"Power Crystal",
};

EasyMount_DismountableStringsMailbox = "Mailbox";

EasyMount_DismountableStrings = {
	
};



-- EasyMount options

--- Commandline

EASYMOUNT_OPTIONS_CMD							= {"/easymount", "/easym", "/emount"};
EASYMOUNT_OPTIONS_CMD_DESC						= "controls EasyMount AddOn";

EASYMOUNT_OPTIONS_SLASH_CMDS					= {};
EASYMOUNT_OPTIONS_SLASH_CMDS["help"]			= {"help"};
EASYMOUNT_OPTIONS_SLASH_CMDS["toggle"]			= {"toggle", "tg", "t"};
EASYMOUNT_OPTIONS_SLASH_CMDS["enable"]			= {"enable", "en", "e"};
EASYMOUNT_OPTIONS_SLASH_CMDS["disable"]			= {"disable", "di", "d"};
EASYMOUNT_OPTIONS_SLASH_CMDS["set"]				= {"set"};

EASYMOUNT_OPTIONS_SLASH_FEAT					= {};
EASYMOUNT_OPTIONS_SLASH_FEAT["main"]			= {"", "main"};
EASYMOUNT_OPTIONS_SLASH_FEAT["gathering"]		= {"gather", "gathering"};
EASYMOUNT_OPTIONS_SLASH_FEAT["mailbox"]			= {"mailbox", "mb"};
EASYMOUNT_OPTIONS_SLASH_FEAT["mailboxopen"]		= {"mailboxopen", "mbo"};
EASYMOUNT_OPTIONS_SLASH_FEAT["mailboxclose"]	= {"mailboxclose", "mbc"};
EASYMOUNT_OPTIONS_SLASH_FEAT["combat"]			= {"combat", "cb"};
EASYMOUNT_OPTIONS_SLASH_FEAT["combattimeout"]	= {"combattimeout", "cbt"};
EASYMOUNT_OPTIONS_SLASH_FEAT["loottimeout"]		= {"loottimeout", "lto"};
EASYMOUNT_OPTIONS_SLASH_FEAT["lootmulttimeout"]	= {"lootmulttimeout", "lmto"};
EASYMOUNT_OPTIONS_SLASH_FEAT["mailboxtimeout"]	= {"mailboxtimeout", "mbto"};
EASYMOUNT_OPTIONS_SLASH_FEAT["gatheringtimeout"]= {"gatheringtimeout", "gto"};

-- provides a mapping between feature and EasyMount_Options index (as well as Khaos index)
EASYMOUNT_FEAT_OPTIONS_MAP						= {};
EASYMOUNT_FEAT_OPTIONS_MAP["main"]				= "enabled";
EASYMOUNT_FEAT_OPTIONS_MAP["gathering"]			= "handleGathering";
EASYMOUNT_FEAT_OPTIONS_MAP["mailbox"]			= "handleMailbox";
EASYMOUNT_FEAT_OPTIONS_MAP["mailboxopen"]		= "remountWithMailboxOpen";
EASYMOUNT_FEAT_OPTIONS_MAP["mailboxclose"]		= "remountWhenClosingMailbox";
EASYMOUNT_FEAT_OPTIONS_MAP["combat"]			= "mountAfterCombat";
EASYMOUNT_FEAT_OPTIONS_MAP["combattimeout"]		= "timeToMountAfterCombat";
EASYMOUNT_FEAT_OPTIONS_MAP["loottimeout"]		= "timeAfterLoot";
EASYMOUNT_FEAT_OPTIONS_MAP["lootmulttimeout"]	= "timeAfterLootMultiple";
EASYMOUNT_FEAT_OPTIONS_MAP["mailboxtimeout"]	= "mailboxTooltipTimeout";
EASYMOUNT_FEAT_OPTIONS_MAP["gatheringtimeout"]	= "gatheringRemountTimeout";

-- provides a mapping between feature and Cosmos name
EASYMOUNT_FEAT_COSMOS_MAP						= {};
EASYMOUNT_FEAT_COSMOS_MAP["main"]				= "COS_EASYMOUNT_ENABLED";
EASYMOUNT_FEAT_COSMOS_MAP["gathering"]			= "COS_EASYMOUNT_GATHERING";
EASYMOUNT_FEAT_COSMOS_MAP["mailbox"]			= "COS_EASYMOUNT_MAILBOX";
EASYMOUNT_FEAT_COSMOS_MAP["combat"]				= "COS_EASYMOUNT_COMBAT";


EASYMOUNT_SET_FEAT_VALID_VALUE					= {};
EASYMOUNT_SET_FEAT_VALID_VALUE["toggle"]		= -1;
EASYMOUNT_SET_FEAT_VALID_VALUE["enable"]		= 1;
EASYMOUNT_SET_FEAT_VALID_VALUE["disable"]		= 0;

EASYMOUNT_CMD_FEAT_VALID						= {};
EASYMOUNT_CMD_FEAT_VALID["toggle"]				= {"main", "gathering", "mailbox", "mailboxopen", "mailboxclose", "combat"};
EASYMOUNT_CMD_FEAT_VALID["enable"]				= EASYMOUNT_CMD_FEAT_VALID["toggle"];
EASYMOUNT_CMD_FEAT_VALID["disable"]				= EASYMOUNT_CMD_FEAT_VALID["toggle"];
EASYMOUNT_CMD_FEAT_VALID["set"]					= {"combattimeout"};

EASYMOUNT_ERROR_ILLEGAL_FEAT					= "EasyMount: the feature you specified does not exist.";
EASYMOUNT_ERROR_WRONG_CMD_FEAT					= "EasyMount: the feature you specified can not be %s.";
EASYMOUNT_ERROR_NO_VALUE_TO_SET					= "EasyMount: no value given to set.";

EASYMOUNT_WRONG_CMD_FEAT_LIST					= {};
EASYMOUNT_WRONG_CMD_FEAT_LIST["toggle"]			= "toggled";
EASYMOUNT_WRONG_CMD_FEAT_LIST["enable"]			= "enabled";
EASYMOUNT_WRONG_CMD_FEAT_LIST["disable"]		= "disabled";
EASYMOUNT_WRONG_CMD_FEAT_LIST["set"]			= "set";


EASYMOUNT_OPTIONS_CMD_USAGE						= {
	" Usage: /easymount <command> [parameters]";
	"",
	"Commands:",
	" toggle [feature] - toggle EasyMount or specified feature on/off",
	" enable [feature] - enable EasyMount or specified feature",
	" disable [feature] - disable EasyMount (or specified feature)",
	" set <feature> <value> - sets the feature to value",
	" help - displays this information",
	"",
	"Features:",
	" main - main code, will restore behaviour of system to as close to pre-EasyMount as is possible",
	" gathering - part that influence the dismount/mount when attemping to gather stuff",
	" mailbox - part that influence the dismount/mount when accessing the mailbox",
	" mailboxopen - whether to mount after opening the mailbox or not",
	" mailboxclose - whether to mount after closing the mailbox or not",
	-- EASYMOUNT_COMBAT START
	--[[
	" aftercombat - whether to remount after you leave combat or not",
	" aftercombattimeout - how long time after combat to wait (resets to 1 second if you loot)",
	]]--
	-- EASYMOUNT_COMBAT END

};

--- Khaos

EASYMOUNT_KHAOS_FOLDER_TEXT						= "EasyMount";
EASYMOUNT_KHAOS_FOLDER_HELP						= "Contains settings for EasyMount, the AddOn that makes using a mount much easier.";

EASYMOUNT_KHAOS_EASYSET_TEXT					= "Basic";
EASYMOUNT_KHAOS_EASYSET_HELP					= "Contains the basic options, controlling broad behaviour of the AddOn.";

EASYMOUNT_KHAOS_ADVANCEDSET_TEXT				= "Advanced";
EASYMOUNT_KHAOS_ADVANCEDSET_HELP				= "Contains the advanced options, allowing for fine-grained control of the AddOn.";

EASYMOUNT_KHAOS_ENABLE_TEXT						= "Enable EasyMount";
EASYMOUNT_KHAOS_ENABLE_HELP						= "Determines if EasyMount is allowed to do anything at all. If disabled, nothing will happen, though some code will still run.";

EASYMOUNT_KHAOS_GATHERING_TEXT					= "Handle gathering";
EASYMOUNT_KHAOS_GATHERING_HELP					= "Whether EasyMount should handle gathering.";

EASYMOUNT_KHAOS_MAILBOX_TEXT					= "Handle mailbox";
EASYMOUNT_KHAOS_MAILBOX_HELP					= "Whether EasyMount should handle interacting with the mailbox.";

EASYMOUNT_KHAOS_COMBAT_TEXT						= "Remount after combat";
EASYMOUNT_KHAOS_COMBAT_HELP						= "Whether EasyMount should remount after combat is done (will wait for looting).";

EASYMOUNT_KHAOS_MBREMOUNTCLOSE_TEXT				= "Handle mailbox close";
EASYMOUNT_KHAOS_MBREMOUNTCLOSE_HELP				= "Whether EasyMount should remount after closing the mailbox.";

EASYMOUNT_KHAOS_MBREMOUNTOPEN_TEXT				= "Handle mailbox open";
EASYMOUNT_KHAOS_MBREMOUNTOPEN_HELP				= "Whether EasyMount should remount after the mailbox has been opened. Note that while the mailbox is usable as long as it is kept open, it can be annoying to close the mailbox and open it again often with this option enabled.";

EASYMOUNT_KHAOS_GATHER_TIMEOUT_TEXT				= "Remount gather timeout";
EASYMOUNT_KHAOS_GATHER_TIMEOUT_HELP				= "Determines the timespan within automatic remounting from gathering can occur. This is the time from when automatic dismounting is triggered. Setting it to zero means that time is not considered.";
EASYMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT			= "Gather timeout set to %d seconds.";
EASYMOUNT_KHAOS_GATHER_TIMEOUT_NONE				= "No gather timeout.";

EASYMOUNT_KHAOS_TIME_AFTER_LOOT_TEXT			= "Delay after looting";
EASYMOUNT_KHAOS_TIME_AFTER_LOOT_HELP			= "The amount of time to wait after looting gathered stuff to trigger remounting.";
EASYMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT			= "Remounting delay after looting: %2f seconds";

EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_TEXT		= "Delay after looting iterative";
EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_HELP		= "The amount of time to wait after looting iterative stuff (mining, getting more than one round of stuff from the same node) to remount.";
EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT		= "Remounting delay after looting iterative: %2f seconds";

EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_TEXT			= "Mailbox tooltip timeout";
EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_HELP			= "The lower the value this, the less time is allowed between the mailbox tooltip disappearing and reappearing. Rather, the lower the value, the more sensitive the check.";
EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_FORMAT		= EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_TEXT..": %2f seconds";

EASYMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT				= "Combat remount timeout";
EASYMOUNT_KHAOS_COMBAT_TIMEOUT_HELP				= "The maximum time to wait after combat ends before remounting.";
EASYMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT			= EASYMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT..": %2f seconds";

--- Cosmos
--reuses Khaos

EASYMOUNT_CONFIG_HEADER							= EASYMOUNT_KHAOS_FOLDER_TEXT;
EASYMOUNT_CONFIG_HEADER_INFO					= EASYMOUNT_KHAOS_FOLDER_HELP;

EASYMOUNT_STATE_ENABLED							= "enabled";
EASYMOUNT_STATE_DISABLED						= "disabled";

EASYMOUNT_CHAT_ENABLED							= "EasyMount %s.";

EASYMOUNT_CHAT_GATHERING						= "EasyMount handle gathering %s.";
EASYMOUNT_CHAT_MAILBOX							= "EasyMount handle mailbox %s.";
EASYMOUNT_CHAT_COMBAT							= "EasyMount remount after combat %s.";

-- these should be possible to just copy/paste into any localization... should actually not be here, buuut...

EASYMOUNT_CMD_CHECKBOX_CHAT_STATE				= {};
EASYMOUNT_CMD_CHECKBOX_CHAT_STATE["main"]		= EASYMOUNT_CHAT_ENABLED;
EASYMOUNT_CMD_CHECKBOX_CHAT_STATE["gathering"]	= EASYMOUNT_CHAT_GATHERING;
EASYMOUNT_CMD_CHECKBOX_CHAT_STATE["mailbox"]	= EASYMOUNT_CHAT_MAILBOX;
EASYMOUNT_CMD_CHECKBOX_CHAT_STATE["combat"]		= EASYMOUNT_CHAT_COMBAT;

EASYMOUNT_CMD_SET_CHAT_STATE					= {};
EASYMOUNT_CMD_SET_CHAT_STATE["gathering"]		= EASYMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT;
EASYMOUNT_CMD_SET_CHAT_STATE["loottimeout"]		= EASYMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT;
EASYMOUNT_CMD_SET_CHAT_STATE["lootmulttimeout"]	= EASYMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT;
EASYMOUNT_CMD_SET_CHAT_STATE["mailboxtimeout"]	= EASYMOUNT_KHAOS_MB_TOOLTIP_TIMEOUT_FORMAT;
EASYMOUNT_CMD_SET_CHAT_STATE["combattimeout"]	= EASYMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT;
