ITEMHELPER_INVENTORY_BAG	= -5;

ItemHelper_CachedItems = {};

function ItemHelper_GetItemNameFromLink(link)
	local name;
	if( not link ) then
		return nil;
	end
	for name in string.gfind(link, "|c%x+|Hitem:%d+:%d+:%d+:%d+|h%[(.-)%]|h|r") do
		return name;
	end
	return nil;
end

--
-- Retrieves the name of the item in bag#, slot#
-- If only bag is specified, it will assume that you want to access the inventory.
--
function ItemHelper_GetItemName(bag, slot)
	if ( not bag ) then
		return nil;
	end
	if ( not slot ) then
		slot = bag;
		bag = ITEMHELPER_INVENTORY_BAG;
	end
	local name = nil;
	local arr = ItemHelper_CachedItems[bag];
	if ( arr ) then
		local arrSlot = arr[slot];
		if ( arrSlot ) and ( arrSlot.n ) then
			return arrSlot.n;
		end
	end
	local link = nil;
	if ( bag == ITEMHELPER_INVENTORY_BAG ) then
		link = GetInventoryItemLink("player", slot);
	else
		link = GetContainerItemLink(bag, slot);
	end
	if ( not link ) then
		return nil;
	end
	name = ItemHelper_GetItemNameFromLink(link);
	if ( name ) then
		if ( not ItemHelper_CachedItems[bag] ) then
			ItemHelper_CachedItems[bag] = {};
		end
		arr = ItemHelper_CachedItems[bag][slot];
		if ( not arr ) then 
			arr = {}; 
			arr.n = name;
			ItemHelper_CachedItems[bag][slot] = arr;
		else
			ItemHelper_CachedItems[bag][slot].n = name;-- is this really needed unless nil?? TODO: check if it is not and optimize it to arr.n = name;
		end
	end
	return name;
end

function ItemHelper_BagChanged(bag)
	if ( not bag ) then
		ItemHelper_CachedItems = {};
		return;
	end
	if ( ItemHelper_CachedItems[bag] ) then
		ItemHelper_CachedItems[bag] = {};
	end
end

function ItemHelper_OnLoad()
	local f = ItemHelperFrame;
	f:RegisterEvent("UNIT_INVENTORY_CHANGED");
	f:RegisterEvent("BAG_UPDATE");
	f:RegisterEvent("PLAYERBANKSLOTS_CHANGED");
	f:RegisterEvent("BANKFRAME_OPENED");
end

function ItemHelper_BankChanged()
	for bag = 5, 10 do 
		if ( ItemHelper_CachedItems[bag] ) then
			ItemHelper_CachedItems[bag] = {};
		end
	end
end

function ItemHelper_OnEvent(event)
	if ( event == "UNIT_INVENTORY_CHANGED" ) then
		if ( arg1 == "player" ) then	
			ItemHelper_BagChanged(ITEMHELPER_INVENTORY_BAG);
		end
	end
	if ( event == "PLAYERBANKSLOTS_CHANGED" ) or ( event == "BANKFRAME_OPENED" ) then
		ItemHelper_BankChanged();
	end
	if ( event == "BAG_UPDATE" ) then
		ItemHelper_BagChanged(arg1);
	end
end
