local tooltip_showing = false;

local SKILL_HERBALISM = "Herbalism";
local SKILL_MINING = "Mining";

local MMA_ShowHerbalism = false;
local MMA_ShowMining = false;

-- whether the tooltip should be anchored at the cursor or not
local MinimapAssistant_TooltipAnchorCursor = 1;

-- whether to use a multi line tooltip or a single line one
local MinimapAssistant_UseMultiLineTooltip = 1;


local MMA_TooltipName = "CosmosTooltip";

-- the following will try to use the tooltip:SetText function
local MMA_UseSetText = true;


-- data tables, at least currently!
local skillTable = { }
skillTable["Peacebloom Flower"] =  { skill=SKILL_HERBALISM, red=1,   orange=25,  yellow=50,  green=100 };
skillTable["Silverleaf Bush"] =    { skill=SKILL_HERBALISM, red=1,   orange=25,  yellow=50,  green=100 };
skillTable["Snakeroot"] =          { skill=SKILL_HERBALISM, red=15,  orange=40,  yellow=80,  green=115 };
skillTable["Mageroyal"] =          { skill=SKILL_HERBALISM, red=50,  orange=75,  yellow=100, green=150 };
skillTable["Briarthorn"] =         { skill=SKILL_HERBALISM, red=70,  orange=0,   yellow=120, green=170 };
skillTable["Stranglekelp"] =       { skill=SKILL_HERBALISM, red=85,  orange=125, yellow=150, green=190 };
skillTable["Bruiseweed"] =         { skill=SKILL_HERBALISM, red=100, orange=0,   yellow=0,   green=0 };
skillTable["Wild Steelbloom"] =    { skill=SKILL_HERBALISM, red=115, orange=0,   yellow=0,   green=0 };
skillTable["Grave Moss"] =         { skill=SKILL_HERBALISM, red=120, orange=0,   yellow=0,   green=0 };
skillTable["King's Blood"] =       { skill=SKILL_HERBALISM, red=125, orange=0,   yellow=0,   green=0 };
skillTable["Liferoot"] =           { skill=SKILL_HERBALISM, red=150, orange=0,   yellow=0,   green=0 };
skillTable["Fadeleaf"] =           { skill=SKILL_HERBALISM, red=160, orange=0,   yellow=0,   green=0 };
skillTable["Khadgar's Whiskers"] = { skill=SKILL_HERBALISM, red=185, orange=0,   yellow=0,   green=0 };
skillTable["Wintersbite"] =        { skill=SKILL_HERBALISM, red=195, orange=0,   yellow=0,   green=0 };
skillTable["Firebloom"] =          { skill=SKILL_HERBALISM, red=205, orange=0,   yellow=0,   green=0 };
skillTable["Purple Lotus"] =       { skill=SKILL_HERBALISM, red=210, orange=0,   yellow=0,   green=0 };
skillTable["Goldthorn"] =          { skill=SKILL_HERBALISM, red=215, orange=0,   yellow=0,   green=0 };
skillTable["Sungrass"] =           { skill=SKILL_HERBALISM, red=230, orange=0,   yellow=0,   green=0 };
skillTable["Blindweed"] =          { skill=SKILL_HERBALISM, red=235, orange=0,   yellow=0,   green=0 };
skillTable["Ghost Mushroom"] =     { skill=SKILL_HERBALISM, red=245, orange=0,   yellow=0,   green=0 };
skillTable["Gromsblood"] =         { skill=SKILL_HERBALISM, red=250, orange=0,   yellow=0,   green=0 };

skillTable["Copper Vein"] = { skill=SKILL_MINING, red=1, orange=25, yellow=60, green=100 };
skillTable["Bronze Vein"] = { skill=SKILL_MINING, red=65, orange=90, yellow=125, green=165 };
skillTable["Tin Vein"] = { skill=SKILL_MINING, red=65, orange=90, yellow=125, green=165 };
skillTable["Silver Vein"] = { skill=SKILL_MINING, red=75, orange=100, yellow=145, green=175 };
skillTable["Iron Vein"] = { skill=SKILL_MINING, red=125, orange=150, yellow=185, green=225 };
skillTable["Gold Vein"] = { skill=SKILL_MINING, red=155, orange=180, yellow=215, green=255 };
skillTable["Steel Vein"] = { skill=SKILL_MINING, red=165, orange=190, yellow=225, green=265 };
skillTable["Lesser Bloodstone"] = { skill=SKILL_MINING, red=165, orange=190, yellow=225, green=265 };
skillTable["Mithril Vein"] = { skill=SKILL_MINING, red=175, orange=2000, yellow=235, green=275 };
skillTable["Truesilver Vein"] = { skill=SKILL_MINING, red=230, orange=255, yellow=290, green=330 };

local difficulty_colours = { }
difficulty_colours["red"] = { r = 1.00, g = 0, b = 0 };
difficulty_colours["orange"] = { r = 1.00, g = 0.50, b = 0.25 };
difficulty_colours["yellow"] = { r = 1.00, g = 1.00, b = 0.00 };
difficulty_colours["green"] = { r = 0.25, g = 0.75, b = 0.25 };
difficulty_colours["grey"]	= { r = 0.50, g = 0.50, b = 0.50 };


local skillIndices = { }
skillIndices[SKILL_HERBALISM] = -1;
skillIndices[SKILL_MINING] = -1;

function FindSkill(skillToSearchFor)

	local index = 1;
	
	while true do
		local skillName, header, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType = GetSkillLineInfo(index);
		
		if (nil == skillName) then
			break;
		end
		
		if (skillName == skillToSearchFor) then
			return index;
		end
		
		index = index + 1;		
	end
	
	return -1;
end

function FindSkills()	
	skillIndices[SKILL_MINING] = FindSkill(SKILL_MINING);
	skillIndices[SKILL_HERBALISM] = FindSkill(SKILL_HERBALISM);
end

function GetSkillIndex(skillName)
	return skillIndices[skillName];
end

function GetSkillRank(searchSkillName)
	local skillIndex = GetSkillIndex(searchSkillName);
	
	if (skillIndex > 0) then
		local skillName, header, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType = GetSkillLineInfo(skillIndex);	
		return skillRank;
	else 
		return 0;
	end
end

function GetTooltipColour(skillRank, item)
	local thresholds = skillTable[item];

	if (thresholds.red > skillRank) then
		return difficulty_colours["red"];
	end

	if (thresholds.orange > skillRank) then
		return difficulty_colours["orange"];
	end

	if (thresholds.yellow > skillRank) then
		return difficulty_colours["yellow"];
	end

	if (thresholds.green > skillRank) then
		return difficulty_colours["green"];
	end

	return difficulty_colours["grey"];
end

local flip = false;

function MinimapAssistant_OnHide()
	local tooltip = getglobal(MMA_TooltipName);
	local minimap = getglobal("Minimap");
	if ( ( tooltip:IsOwned(minimap) ) or ( MinimapAssistant_TooltipAnchorCursor == 1 ) )then
		tooltip:Hide();
	end
end

function MinimapAssistant_GetTooltipTextFormat()
	if ( MinimapAssistant_UseMultiLineTooltip == 1 ) then
		return MMA_TOOLTIP_TEXT_MULTI_LINE;
	else
		return MMA_TOOLTIP_TEXT_ONE_LINE;
	end
end

function MinimapAssistant_OnShow()
	FindSkills();
	local minimap = getglobal("Minimap");
	local minimapTooltipText = getglobal("MinimapTooltipText");
	local minimapTooltipTextString = minimapTooltipText:GetText();
	local displayText = "";
	
	local tooltip = getglobal(MMA_TooltipName);
	
	if (not (skillTable[minimapTooltipTextString] == nil)) then
		local skillValues = skillTable[minimapTooltipTextString];

		if (((skillValues.skill == SKILL_HERBALISM) and (MMA_ShowHerbalism)) or
		    ((skillValues.skill == SKILL_MINING) and (MMA_ShowMining))) then
		
			local skillRank = GetSkillRank(skillValues.skill);
			local colourSet = GetTooltipColour(	skillRank, 
												minimapTooltipTextString);
			--displayText = minimapTooltipTextString.."\nRequires "..skillValues.skill.." "..skillValues.red.."; you have "..skillRank..".";
			displayText = format(MinimapAssistant_GetTooltipTextFormat(), minimapTooltipTextString, skillValues.skill, skillValues.red, skillRank);
			
			local tipHeight = 0;
						
			-- this must be present, in this order or it doesn't work for some reason!
			--tooltip:ClearAllPoints();
			if ( MinimapAssistant_TooltipAnchorCursor == 1 ) then
				tooltip:SetOwner(UIParent, "ANCHOR_CURSOR");
			else
				tooltip:SetOwner(minimap, "ANCHOR_LEFT");
			end
			--tooltip:SetPoint("RIGHT", "Minimap", "ANCHOR_LEFT");
			
			-- Perhaps using the SetText method works better... we'll see, though!
			if ( MMA_UseSetText == true ) then
				tooltip:SetText(displayText);
			else
				tooltip:SetText("\n");
				
				tipHeight = tipHeight + tooltip:GetHeight();
	
				local tipText1 = getglobal(MMA_TooltipName.."TextLeft1");
				
				if (not (tipText1 == nil)) then
					tipText1:SetText(displayText);
					tipText1:Show();
					tipText1:SetTextColor(colourSet.r, colourSet.g, colourSet.b);
					tipHeight = tipHeight + tipText1:GetHeight();
				end	
				
				--[[
			
				If I uncomment this block, I get the text appearing, but it appears
				outside of the tooltip box!!
				
				local tipText2 = getglobal("CosmosTooltipTextLeft2");
							
				if (not (tipText2 == nil)) then
					tipText2:SetText(displayText);
					tipText2:Show();
					tipText2:SetTextColor(0.7, 0.7, 0.7);
					tipHeight = tipHeight + tipText2:GetHeight();
				end
				]]--
			
			end
			
			-- this doens't seem to work :(
			--tooltip:SetHeight(tipHeight);
			tooltip:Show();
			MinimapTooltip:SetHeight(0);
		end
	end		
end

function MinimapAssistant_OnShowHerbalismChanged(toggle)
	if (toggle == 1) then
		MMA_ShowHerbalism = true;
	else
		MMA_ShowHerbalism = false;
	end
end

function MinimapAssistant_OnShowMiningChanged(toggle)
	if (toggle == 1) then
		MMA_ShowMining = true;
	else
		MMA_ShowMining = false;
	end
end

function MinimapAssistant_OnLoad()

	Cosmos_RegisterConfiguration("COS_MMA_DEFAULTSEPARATOR", "SEPARATOR", 
	                             TEXT(MMA_SEPERATOR), TEXT(MMA_SEP_INFO));
	Cosmos_RegisterConfiguration("COS_MMA_SHOW_HERBALISM", "CHECKBOX", 
	                             TEXT(MMA_DISPLAY_HERBALISM_TITLE),
							     TEXT(MMA_DISPLAY_HERBALISM_INFO), 
							     MinimapAssistant_OnShowHerbalismChanged, 1);
	Cosmos_RegisterConfiguration("COS_MMA_SHOW_MINING", "CHECKBOX", 
	                             TEXT(MMA_DISPLAY_MINING_TITLE), 
	                             TEXT(MMA_DISPLAY_MINING_INFO),
	                             MinimapAssistant_OnShowMiningChanged, 1);
end