FADE_IN_TIME = 2;

function AccountLogin_OnLoad()
	this:SetSequence(0);
	this:SetCamera(0);

	local versionType, buildType, version, internalVersion, date = GetBuildInfo();
	AccountLoginVersion:SetText(format(TEXT(VERSION_TEMPLATE), versionType, version, internalVersion, buildType, date));
	WorldOfWarcraftRating:SetTexture(GOVERNMENT_RATING_IMAGE);
	if ( BUILD_LANGUAGE == "enUS" ) then
		WorldOfWarcraftRating:ClearAllPoints();
		WorldOfWarcraftRating:SetPoint("BOTTOMLEFT", "GlueParent", "BOTTOMLEFT", 10, 45);
	end

	AccountLoginChangeRealmButton:Hide();
end

function AccountLogin_OnShow()
	CurrentGlueMusic = "Sound\\Music\\GlueScreenMusic\\wow_main_theme.mp3";

	if ( TOSAccepted() ) then
		AccountLoginUI:Show();
		TOSFrame:Hide();
	else
		if ( ShowTOSNotice() ) then
			TOSNotice:Show();
		end
		AccountLoginUI:Hide();
		TOSFrame:Show();
	end
	
	local accountName = GetLastAccountName();
	local serverName = GetServerName();
	if(serverName) then
		AccountLoginRealmName:SetText(serverName);
	else
		AccountLoginRealmName:Hide()
	end
	
--	if ( accountName and strlen(accountName) > 0 ) then
--		AccountLoginAccountEdit:SetText(accountName);
--		AccountLoginPasswordEdit:SetFocus();
--	else
		AccountLoginAccountEdit:SetText("");
		AccountLoginAccountEdit:SetFocus();
--	end
	AccountLoginPasswordEdit:SetText("");
	
end

function AccountLogin_FocusPassword()
	AccountLoginPasswordEdit:SetFocus("");
end

function AccountLogin_FocusAccountName()
	AccountLoginAccountEdit:SetFocus("");
end

function AccountLogin_OnChar()
end

function AccountLogin_OnKeyDown()
	if ( arg1 == "ESCAPE" ) then
		AccountLogin_Exit();
	elseif ( arg1 == "ENTER" ) then
		if ( not TOSAccepted() ) then
			return;
		end
		AccountLogin_Login();
	elseif ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
	end
end

function AccountLogin_Login()
	PlaySound("gsLogin");
--	DefaultServerLogin("", "") --AccountLoginAccountEdit:GetText(), AccountLoginPasswordEdit:GetText());
	DefaultServerLogin(AccountLoginAccountEdit:GetText(), AccountLoginPasswordEdit:GetText());
	AccountLoginPasswordEdit:SetText("");
end

--[[
function AccountLogin_CreateAccount()
	PlaySound("gsLoginNewAccount");
	LaunchAccountCreate();
end
]]

function AccountLogin_Credits()
	PlaySound("gsTitleCredits");
end

function AccountLogin_Cinematics()
	PlaySound("gsTitleIntroMovie");
end

function AccountLogin_Options()
	PlaySound("gsTitleOptions");
end

function AccountLogin_Exit()
	PlaySound("gsTitleQuit");
	QuitGame();
end

function AccountLogin_ChangeRealm()
	PlaySound("gsLoginChangeRealm");
	RealmList.SelectFunc = AccountLogin_SelectNewRealm;
	GetRealmList(1);
end

function AccountLogin_SelectNewRealm(index)
	ChangeRealm(index);

	local serverName = GetServerName();
	if(serverName) then
		AccountLoginRealmName:SetText(serverName);
	else
		AccountLoginRealmName:Hide()
	end

end
