
GlueDialogTypes = { };
GlueDialogTypes["DISCONNECTED"] = {
	text = TEXT(DISCONNECTED),
	button1 = TEXT(OKAY),
	button2 = nil,
	OnAccept = function()
	end,
	OnCancel = function()
	end,
}

GlueDialogTypes["DELETE_CHARACTER"] = {
	text = "",
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		DeleteCharacter(GlueDialog.data);
	end,
	OnCancel = function()
	end,
	ignoreKeys = 1,
}

GlueDialogTypes["INVALID_NAME"] = {
	text = TEXT(CHAR_CREATE_INVALID_NAME),
	button1 = TEXT(OKAY),
	button2 = nil,
	OnAccept = function()
	end,
	OnCancel = function()
	end,
}

GlueDialogTypes["CANCEL"] = {
	text = "",
	button1 = TEXT(CANCEL),
	button2 = nil,
	OnAccept = function()
		StatusDialogClick();
	end,
	OnCancel = function()
	end,
}

GlueDialogTypes["OKAY"] = {
	text = "",
	button1 = TEXT(OKAY),
	button2 = nil,
	OnAccept = function()
		StatusDialogClick();
	end,
	OnCancel = function()
	end,
}

function GlueDialog_Show(which, text, data)
	-- Pick a free dialog to use
	if ( GlueDialog:IsVisible() ) then
		GlueDialogTypes[GlueDialog.which].OnCancel();
	end

	-- Set the text of the dialog
	if ( text ) then
		GlueDialogText:SetText(text);
	else
		GlueDialogText:SetText(GlueDialogTypes[which].text);
	end

	-- Set the buttons of the dialog
	if ( GlueDialogTypes[which].button2 ) then
		GlueDialogButton1:ClearAllPoints();
		GlueDialogButton1:SetPoint("BOTTOMRIGHT", "GlueDialogBackground", "BOTTOM", -6, 16);
		GlueDialogButton2:ClearAllPoints();
		GlueDialogButton2:SetPoint("LEFT", "GlueDialogButton1", "RIGHT", 13, 0);
		GlueDialogButton2:SetText(GlueDialogTypes[which].button2);
		GlueDialogButton2:Show();
	else
		GlueDialogButton1:ClearAllPoints();
		GlueDialogButton1:SetPoint("BOTTOM", "GlueDialogBackground", "BOTTOM", 0, 16);
		GlueDialogButton2:Hide();
	end
	GlueDialogButton1:SetText(GlueDialogTypes[which].button1);

	-- Set the miscellaneous variables for the dialog
	GlueDialog.which = which;
	GlueDialog.data = data;

	-- Finally size and show the dialog
	GlueDialogBackground:SetHeight(32 + GlueDialogText:GetHeight() + 8 + GlueDialogButton1:GetHeight() + 16);
	GlueDialog:Show();
end

function GlueDialog_OnLoad()
	this:RegisterEvent("OPEN_STATUS_DIALOG");
	this:RegisterEvent("UPDATE_STATUS_DIALOG");
	this:RegisterEvent("CLOSE_STATUS_DIALOG");
end

function GlueDialog_OnEvent()
	if ( event == "OPEN_STATUS_DIALOG" ) then
		GlueDialog_Show(arg1, arg2);
	elseif ( event == "UPDATE_STATUS_DIALOG" and arg1 and (strlen(arg1) > 0) ) then
		GlueDialogText:SetText(arg1);
		GlueDialogBackground:SetHeight(32 + GlueDialogText:GetHeight() + 8 + GlueDialogButton1:GetHeight() + 16);
	elseif ( event == "CLOSE_STATUS_DIALOG" ) then
		GlueDialog:Hide();
	end
end

function GlueDialog_OnHide()
	local OnCancel = GlueDialogTypes[this.which].OnCancel;
	if ( OnCancel ) then
		OnCancel();
	end
end

function GlueDialog_OnClick(index)
	if ( index == 1 ) then
		local OnAccept = GlueDialogTypes[GlueDialog.which].OnAccept;
		if ( OnAccept ) then
			OnAccept();
		end
	else
		local OnCancel = GlueDialogTypes[GlueDialog.which].OnCancel;
		if ( OnCancel ) then
			OnCancel();
		end
	end
	GlueDialog:Hide();
end

function GlueDialog_OnKeyDown()
	if ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
		return;
	end

	local info = GlueDialogTypes[GlueDialog.which];
	if ( not info or info.ignoreKeys ) then
		return;
	end

	if ( arg1 == "ESCAPE" ) then
		if ( GlueDialogButton2:IsVisible() ) then
			GlueDialogButton2:Click();
		else
			GlueDialogButton1:Click();
		end
	elseif (arg1 == "ENTER" ) then
		GlueDialogButton1:Click();
	end
end
