
MAX_CHARACTERS_DISPLAYED = 10;
MAX_CHARACTERS_PER_REALM = 10;

NUM_CHARSELECT_TABS = 3;

function CharacterSelect_OnLoad()
	this:SetSequence(0);
	this:SetCamera(0);

	this.createIndex = 0;
	this.selectedIndex = 0;
	this.selectLast = 0;
	this.currentModel = "";
	this:RegisterEvent("CHARACTER_LIST_UPDATE");
	this:RegisterEvent("UPDATE_SELECTED_CHARACTER");
	this:RegisterEvent("SELECT_LAST_CHARACTER");

	-- Hack to preload models...
	CharacterSelect:SetModel("Interface\\Glues\\Models\\UI_Dwarf\\UI_Dwarf.mdx");
	CharacterSelect:SetModel("Interface\\Glues\\Models\\UI_NightElf\\UI_NightElf.mdx");
	CharacterSelect:SetModel("Interface\\Glues\\Models\\UI_Tauren\\UI_Tauren.mdx");
	CharacterSelect:SetModel("Interface\\Glues\\Models\\UI_Human\\UI_Human.mdx");
	CharacterSelect:SetModel("Interface\\Glues\\Models\\UI_Orc\\UI_Orc.mdx");

--	CharacterSelect:ClearModel();
	local fogInfo = CharModelFogInfo["ORC"];
	CharacterSelect:SetFogColor(fogInfo.r, fogInfo.g, fogInfo.b);
	CharacterSelect:SetFogNear(0);
	CharacterSelect:SetFogFar(fogInfo.far);

	SetCharSelectModelFrame("CharacterSelect");
	--CharSelectModel:SetLight(1, 0, 0, -0.707, -0.707, 0.7, 1.0, 1.0, 1.0, 0.8, 1.0, 1.0, 0.8);
end

function CharacterSelect_OnShow()
	CurrentGlueMusic = "Sound\\Music\\GlueScreenMusic\\wow_main_theme.mp3";

	local serverName = GetServerName();
	local connected = IsConnectedToServer();
	if ( serverName ) then
		if( not connected ) then
			serverName = serverName.."\n("..TEXT(SERVER_DOWN)..")";
		end
		CharSelectRealmName:SetText(serverName);
		CharSelectRealmName:Show();
	else
		CharSelectRealmName:Hide();
	end

	if ( connected ) then
		GetCharacterListUpdate();
	else
		UpdateCharacterList();
	end
	-- default to the news tab
	CharacterSelectUI.selectedTab = 1;
	CharacterSelect_UpdateTabs();

	-- fadein the character select ui
	GlueFrameFadeIn(CharacterSelectUI, CHARACTER_SELECT_FADE_IN)
end

function CharacterSelect_Tab_OnClick()
	CharacterSelectUI.selectedTab = this:GetID();
	CharacterSelect_UpdateTabs();
end

function CharacterSelect_UpdateTabs()
	if ( CharacterSelectUI.selectedTab ) then
		local tab;
		for i=1, NUM_CHARSELECT_TABS, 1 do
			tab = getglobal("CharacterSelectTab"..i);
			if ( i == CharacterSelectUI.selectedTab ) then
				CharacterSelect_SelectTab(tab);
			else
				CharacterSelect_DeSelectTab(tab);
			end
		end
	end
end

function CharacterSelect_DeSelectTab(tab)
	local name = tab:GetName();
	getglobal(name.."Left"):Show();
	getglobal(name.."Middle"):Show();
	getglobal(name.."Right"):Show();
	tab:UnlockHighlight();
	getglobal(name.."LeftDisabled"):Hide();
	getglobal(name.."MiddleDisabled"):Hide();
	getglobal(name.."RightDisabled"):Hide();
end

function CharacterSelect_SelectTab(tab)
	local name = tab:GetName();
	getglobal(name.."Left"):Hide();
	getglobal(name.."Middle"):Hide();
	getglobal(name.."Right"):Hide();
	tab:LockHighlight();
	getglobal(name.."LeftDisabled"):Show();
	getglobal(name.."MiddleDisabled"):Show();
	getglobal(name.."RightDisabled"):Show();
end

function CharacterSelect_OnKeyDown()
	if ( arg1 == "ESCAPE" ) then
		CharacterSelect_Exit();
	elseif ( arg1 == "ENTER" ) then
		CharacterSelect_EnterWorld();
	elseif ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
	elseif ( arg1 == "UP" or arg1 == "LEFT" ) then
		local numChars = GetNumCharacters();
		if ( numChars > 1 ) then
			if ( this.selectedIndex > 1 ) then
				CharacterSelect_SelectCharacter(this.selectedIndex - 1);
			else
				CharacterSelect_SelectCharacter(numChars);
			end
		end
	elseif ( arg1 == "DOWN" or arg1 == "RIGHT" ) then
		local numChars = GetNumCharacters();
		if ( numChars > 1 ) then
			if ( this.selectedIndex < GetNumCharacters() ) then
				CharacterSelect_SelectCharacter(this.selectedIndex + 1);
			else
				CharacterSelect_SelectCharacter(1);
			end
		end
	end
end

function CharacterSelect_OnEvent()
	if ( event == "CHARACTER_LIST_UPDATE" ) then
		UpdateCharacterList();
	elseif ( event == "UPDATE_SELECTED_CHARACTER" ) then
		if ( arg1 == 0 ) then
			CharSelectCharacterName:SetText("");
		else
			CharSelectCharacterName:SetText(GetCharacterInfo(arg1));
			this.selectedIndex = arg1;
		end
		UpdateCharacterSelection();
	elseif ( event == "SELECT_LAST_CHARACTER" ) then
		this.selectLast = 1;
	end
end

function CharacterSelect_UpdateModel()
	UpdateSelectionCustomizationScene();
	this:AdvanceTime();
end

function UpdateCharacterSelection()
	for i=1, MAX_CHARACTERS_DISPLAYED, 1 do
		getglobal("CharSelectCharacterButton"..i):UnlockHighlight();
	end

	local index = this.selectedIndex;
	if ( (index > 0) and (index <= MAX_CHARACTERS_DISPLAYED) )then
		getglobal("CharSelectCharacterButton"..index):LockHighlight();
	end
end

function UpdateCharacterList()
	local numChars = GetNumCharacters();
	local index = 1;
	for i=1, numChars, 1 do
		local name, race, class, level, zone, fileString = GetCharacterInfo(i);
		local button = getglobal("CharSelectCharacterButton"..index);

		if ( not name ) then
			button:SetText("ERROR - Tell Jeremy");
		else
			if ( not zone ) then
				zone = "";
			end
			getglobal("CharSelectCharacterButton"..index.."ButtonTextName"):SetText(name);
			--getglobal("CharSelectCharacterButton"..index.."ButtonTextRestState"):SetText("("..restState..")");
			getglobal("CharSelectCharacterButton"..index.."ButtonTextInfo"):SetText(format(TEXT(CHARACTER_SELECT_INFO), level, class, zone));
		end
		button:Show();

		index = index + 1;
		if ( index > MAX_CHARACTERS_DISPLAYED ) then
			break;
		end
	end

	CharacterSelect.createIndex = 0;
	CharSelectCreateCharacterButton:Hide();	
	
	local connected = IsConnectedToServer();
	for i=index, MAX_CHARACTERS_DISPLAYED, 1 do
		local button = getglobal("CharSelectCharacterButton"..index);
		if ( (CharacterSelect.createIndex == 0) and (numChars < MAX_CHARACTERS_PER_REALM) ) then
			CharacterSelect.createIndex = index;
			if ( connected ) then
				--If can create characters position and show the create button
				CharSelectCreateCharacterButton:SetID(index);
				CharSelectCreateCharacterButton:SetPoint("TOP", button:GetName(), "TOP", 0, -5);
				CharSelectCreateCharacterButton:Show();	
			end
		end
		button:Hide();
		index = index + 1;
	end

	if ( numChars == 0 ) then
		CharacterSelect.selectedIndex = 0;
		return;
	end

	if ( CharacterSelect.selectLast == 1 ) then
		CharacterSelect.selectLast = 0;
		CharacterSelect_SelectCharacter(numChars);
		return;
	end

	CharacterSelect_SelectCharacter(CharacterSelect.selectedIndex);
end

function CharacterSelect_OnChar()
end

function CharacterSelectButton_OnClick()
	local id = this:GetID();
	if ( id ~= CharacterSelect.selectedIndex ) then
		CharacterSelect_SelectCharacter(id);
-- Allen's decree: No fake double-clicking here!
--	else
--		CharacterSelect_EnterWorld();
	end
end

function CharacterSelect_TabResize()
	local buttonMiddle = getglobal(this:GetName().."Middle");
	local buttonMiddleDisabled = getglobal(this:GetName().."MiddleDisabled");
	local width = this:GetTextWidth() - 8;
	local leftWidth = getglobal(this:GetName().."Left"):GetWidth();
	buttonMiddle:SetWidth(width);
	buttonMiddleDisabled:SetWidth(width);
	this:SetWidth(width + (2 * leftWidth));
end

function CharacterSelect_SelectCharacter(id)
	if ( id == CharacterSelect.createIndex ) then
		PlaySound("gsCharacterSelectionCreateNew");
		--ResetRaceSelect();
		--UpdateSelectedRace(nil);
		SetGlueScreen("charcreate");
	else
		local name, race, class, level, zone, fileString = GetCharacterInfo(id);

		if ( fileString ~= CharacterSelect.currentModel ) then
			CharacterSelect.currentModel = fileString;
			SetBackgroundModel(CharacterSelect, fileString);
		end
		SelectCharacter(id);
	end
end

function CharacterSelect_EnterWorld()
	PlaySound("gsCharacterSelectionEnterWorld");
	EnterWorld();
end

function CharacterSelect_Exit()
	PlaySound("gsCharacterSelectionExit");
	DisconnectFromServer();
	SetGlueScreen("login");
end

function CharacterSelect_AccountOptions()
	PlaySound("gsCharacterSelectionAcctOptions");
end

function CharacterSelect_TechSupport()
	PlaySound("gsCharacterSelectionAcctOptions");
end

function CharacterSelect_WebSite()
	PlaySound("gsCharacterSelectionAcctOptions");
	LaunchURL(TEXT(WOW_WEBSITE_URL));
end

function CharacterSelect_Delete()
	PlaySound("gsCharacterSelectionDelCharacter");
	if ( CharacterSelect.selectedIndex > 0 ) then
		GlueDialog_Show("DELETE_CHARACTER", format(TEXT(CONFIRM_CHAR_DELETE), GetCharacterInfo(CharacterSelect.selectedIndex)), CharacterSelect.selectedIndex);
	end
end

function CharacterSelect_ChangeRealm()
	PlaySound("gsLoginChangeRealmSelect");
	RealmList.SelectFunc = CharacterSelect_SelectNewRealm;
	GetRealmList(1);
end

function CharacterSelect_SelectNewRealm(index)
	ChangeRealm(index);
end