REALM_BUTTON_HEIGHT = 16;
MAX_REALMS_DISPLAYED = 18;
REALM_LIST_REFRESH_TIME = 5;

function RealmList_OnLoad()
	this:RegisterEvent("OPEN_REALM_LIST");
	this.currentRealm = 0;
	this.offset = 0;
end

function RealmList_OnEvent()
	if ( event == "OPEN_REALM_LIST" ) then
		this:Show();
		RealmListUpdate();
	end
end

function RealmListUpdate()
	RealmList.refreshTime = REALM_LIST_REFRESH_TIME;

	local numRealms = GetNumRealms();
	local type;
	local name;
	local numPlayers;
	local invalidRealm;
	local currentRealm;
	local realmIndex;

	RealmListOkButton:Disable();

	for i=1, MAX_REALMS_DISPLAYED, 1 do
		realmIndex = RealmList.offset + i;
		local button = getglobal("RealmListRealmButton"..i);
		if ( realmIndex > numRealms ) then
			button:Hide();
		else
			type, name, numPlayers, invalidRealm, currentRealm = GetRealmInfo(realmIndex);
			local icon = getglobal("RealmListRealmButton"..i.."Icon");
			if ( type > 0 ) then
				icon:Show();
			else
				icon:Hide();
			end
			button:SetText(name);
			if ( invalidRealm ) then
				button:SetTextColor(1.0, 0.1, 0.1);
				button:SetHighlightTextColor(1.0, 0.5, 0.5);
			else
				button:SetTextColor(1.0, 0.78, 0.0);
				button:SetHighlightTextColor(1.0, 1.0, 1.0);
			end	
			local players = getglobal("RealmListRealmButton"..i.."Players");
			players:SetText(numPlayers);
			button:Show();
			button:SetID(realmIndex);
			button.name = name;
			if ( RealmList.selectedName ) then
				if ( name == RealmList.selectedName ) then
					this.currentRealm = i;
					button:LockHighlight();
					RealmListOkButton:Enable();
				else
					button:UnlockHighlight();
				end
			else
				if ( currentRealm == 1 ) then
					this.currentRealm = i;
					button:LockHighlight();
					RealmListOkButton:Enable();
				end
			end
		end
	end

	this.selectedName = nil;

	-- ScrollFrame stuff
	GlueScrollFrame_Update(RealmListScrollFrame, numRealms, MAX_REALMS_DISPLAYED, REALM_BUTTON_HEIGHT )
end

function RealmList_OnKeyDown()
	if ( arg1 == "ESCAPE" ) then
		RealmList_OnCancel();
	elseif ( arg1 == "ENTER" ) then
		RealmList_OnOk();
	elseif ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
	end
end

function RealmList_OnOk()
	PlaySound("gsLoginChangeRealmOK");
	RealmList:Hide();
	if ( RealmList.currentRealm > 0 ) then
		RealmList.SelectFunc(RealmList.currentRealm);
	end
end

function RealmList_OnCancel()
	PlaySound("gsLoginChangeRealmCancel");
	RealmList:Hide();
end

function RealmSelectButton_OnClick(id)
	RealmList.refreshTime = REALM_LIST_REFRESH_TIME;
	if ( RealmList.selectedName == this.name ) then
		RealmList_OnOk();
		return;
	end
	RealmList.currentRealm = id;
	RealmList.selectedName = this.name;
	RealmListUpdate();
end

function RealmListScrollFrame_OnVerticalScroll()
	RealmList.refreshTime = REALM_LIST_REFRESH_TIME;
	local scrollbar = getglobal(this:GetName().."ScrollBar");
	scrollbar:SetValue(arg1);
	RealmList.offset = floor((arg1 / REALM_BUTTON_HEIGHT) + 0.5);
	RealmListUpdate();
end

function RealmList_OnShow()
	this.refreshTime = REALM_LIST_REFRESH_TIME;
end

function RealmList_OnHide()
	CancelRealmListQuery();
end

function RealmList_OnUpdate(elapsed)
	if ( this.refreshTime ) then
		this.refreshTime = this.refreshTime - elapsed;
		if ( this.refreshTime <= 0 ) then
			this.refreshTime = nil;
			GetRealmList();
		end
	end
end
