CLASS_TRAINER_SKILLS_DISPLAYED = 11;
CLASS_TRAINER_SKILL_HEIGHT = 16;

function ClassTrainerFrame_OnLoad()
	this:RegisterEvent("TRAINER_UPDATE");
	this:RegisterEvent("TRAINER_CLOSED");
	this:RegisterEvent("TRAINER_SHOW");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
end

function ClassTrainerFrame_OnEvent()
	if ( not IsTalentTrainer() ) then
		if ( event == "TRAINER_UPDATE" ) then
			ClassTrainerTrainButton:Disable();
			if ( this:IsVisible() ) then
				if ( GetTrainerSelectionIndex() > 1 ) then
					--debuginfo("has selection index > 1");
					if ( GetTrainerSelectionIndex() > GetNumTrainerServices() ) then
						FauxScrollFrame_SetOffset(ClassTrainerListScrollFrame, 0);
						ClassTrainerListScrollFrameScrollBar:SetValue(0);
					end
					ClassTrainer_SetSelection(GetTrainerSelectionIndex());
				else
					--debuginfo("has no selection index");
					ClassTrainer_SelectFirstLearnableSkill();
				end
				--debuginfo("updating");
				ClassTrainerFrame_Update();
			end
		elseif ( event == "TRAINER_SHOW" ) then
			--Hack for talent trainer
			if ( IsTalentTrainerTabSelected() and CharacterFrame:IsVisible() ) then
				HideUIPanel(CharacterFrame);
			end
			ShowUIPanel(this);
			ClassTrainerTrainButton:Disable();
			ClassTrainerListScrollFrameScrollBar:SetMinMaxValues(0, 0); 
			ClassTrainerListScrollFrameScrollBar:SetValue(0);
			ClassTrainer_SelectFirstLearnableSkill();
			ClassTrainerSortButton_OnShow(ClassTrainerAvailableButton, "available");
			ClassTrainerSortButton_OnShow(ClassTrainerUnavailableButton, "unavailable");
			ClassTrainerSortButton_OnShow(ClassTrainerUsedButton, "used");
			ClassTrainerFrame_Update();
			UpdateMicroButtons();
		elseif ( event == "CHARACTER_POINTS_CHANGED" ) then
			local cp1, cp2 = UnitCharacterPoints("player");
			ClassTrainerFrameSkillPointLabel:SetText(CHARACTER_POINTS2_COLON.." "..HIGHLIGHT_FONT_COLOR_CODE..cp2..FONT_COLOR_CODE_CLOSE);
		end
	end
	if ( event == "TRAINER_CLOSED" ) then
		HideUIPanel(this);
	end
end

function ClassTrainerFrame_Update()
	SetPortraitTexture(ClassTrainerFramePortrait, "npc");
	ClassTrainerNameText:SetText(UnitName("npc"));
	ClassTrainerGreetingText:SetText(GetTrainerGreetingText());
	local numTrainerServices = GetNumTrainerServices();
	local skillOffset = FauxScrollFrame_GetOffset(ClassTrainerListScrollFrame);
	
	-- If no spells then clear everything out
	if ( numTrainerServices == 0 ) then
		ClassTrainerCollapseAllButton:Disable();
	else
		ClassTrainerCollapseAllButton:Enable();
	end

	-- If selectedService is nil hide everything
	if ( not ClassTrainerFrame.selectedService ) then
		ClassTrainer_HideSkillDetails();
	end

	-- Change the setup depending on if its a class trainer or tradeskill trainer
	if ( IsTradeskillTrainer() ) then
		ClassTrainer_SetToTradeSkillTrainer();
	else
		ClassTrainer_SetToClassTrainer();
	end

	-- ScrollFrame update
	FauxScrollFrame_Update(ClassTrainerListScrollFrame, numTrainerServices, CLASS_TRAINER_SKILLS_DISPLAYED, CLASS_TRAINER_SKILL_HEIGHT, ClassTrainerSkillHighlightFrame, 293, 316 )
	
	ClassTrainerUsedButton:Show();
	ClassTrainerMoneyFrame:Show();
	ClassTrainerSkillHighlightFrame:Hide();
	-- Fill in the skill buttons
	for i=1, CLASS_TRAINER_SKILLS_DISPLAYED, 1 do
		local skillIndex = i + skillOffset;
		local skillButton = getglobal("ClassTrainerSkill"..i);
		local serviceName, serviceSubText, serviceType, isExpanded;
		if ( skillIndex <= numTrainerServices ) then	
			serviceName, serviceSubText, serviceType, isExpanded = GetTrainerServiceInfo(skillIndex);
			if ( not serviceName ) then
				serviceName = TEXT(UNKNOWN);
			end
			-- Set button widths if scrollbar is shown or hidden
			if ( ClassTrainerListScrollFrame:IsVisible() ) then
				skillButton:SetWidth(293);
			else
				skillButton:SetWidth(323);
			end
			local skillCost = getglobal("ClassTrainerSkill"..i.."Cost");
			local skillSubText = getglobal("ClassTrainerSkill"..i.."SubText");
			-- Type stuff
			if ( serviceType == "header" ) then
				skillCost:Hide();
				skillButton:SetText(serviceName);
				skillButton:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
				skillSubText:Hide();
				if ( isExpanded ) then
					skillButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
				else
					skillButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
				end
				getglobal("ClassTrainerSkill"..i.."Highlight"):SetTexture("Interface\\Buttons\\UI-PlusButton-Hilight");
			else
				skillButton:SetNormalTexture("");
				getglobal("ClassTrainerSkill"..i.."Highlight"):SetTexture("");
				skillButton:SetText("  "..serviceName);
				if ( serviceSubText and serviceSubText ~= "" ) then
					skillSubText:SetText(format(TEXT(PARENS_TEMPLATE), serviceSubText));
					skillSubText:SetPoint("LEFT", "ClassTrainerSkill"..i.."Text", "RIGHT", 10, 0);
					skillSubText:Show();
				else
					skillSubText:Hide();
				end
				
				-- Cost Stuff
				local moneyCost, cpCost1, cpCost2 = GetTrainerServiceCost(skillIndex);
				if ( cpCost2 > 0 ) then
					skillCost:SetText(format(TEXT(TRAINER_LIST_SP),cpCost2));
					skillCost:Show();
				elseif ( cpCost1 > 0 ) then
					if ( serviceType ) then
					
					end
					skillCost:SetText(format(TEXT(TRAINER_LIST_TP), cpCost1));
					skillCost:Show();
				else
					skillCost:Hide();
				end
				if ( serviceType == "available" ) then
					skillButton:SetTextColor(0, 1.0, 0);
					skillCost:SetTextColor(0, 1.0, 0);
					ClassTrainer_SetSubTextColor(skillButton, 0, 0.6, 0);
					skillButton.r = 0;
				elseif ( serviceType == "used" ) then
					skillButton:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
					ClassTrainer_SetSubTextColor(skillButton, 0.5, 0.5, 0.5);
					skillCost:Hide();
				else
					skillButton:SetTextColor(0.9, 0, 0);
					skillCost:SetTextColor(0.9, 0, 0);
					ClassTrainer_SetSubTextColor(skillButton, 0.6, 0, 0);
				end
			end
			skillButton:SetID(skillIndex);
			skillButton:Show();
			-- Place the highlight and lock the highlight state
			if ( ClassTrainerFrame.selectedService and GetTrainerSelectionIndex() == skillIndex ) then
				ClassTrainerSkillHighlightFrame:SetPoint("TOPLEFT", "ClassTrainerSkill"..i, "TOPLEFT", 0, 0);
				ClassTrainerSkillHighlightFrame:Show();
				skillButton:LockHighlight();
				ClassTrainer_SetSubTextColor(skillButton, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
				skillCost:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			else
				skillButton:UnlockHighlight();
			end
		else
			skillButton:Hide();
		end
	end
		
	-- Set the expand/collapse all button texture
	local numHeaders = 0;
	local notExpanded = 0;
	-- Somewhat redundant loop, but cleaner than the alternatives
	for i=1, numTrainerServices, 1 do
		local skillIndex = i;
		local serviceName, serviceSubText, serviceType, isExpanded = GetTrainerServiceInfo(skillIndex);
		if ( serviceName and serviceType == "header" ) then
			numHeaders = numHeaders + 1;
			if ( not isExpanded ) then
				notExpanded = notExpanded + 1;
			end
		end
	end
	-- If all headers are not expanded then show collapse button, otherwise show the expand button
	if ( notExpanded ~= numHeaders ) then
		ClassTrainerCollapseAllButton.collapsed = nil;
		ClassTrainerCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
	else
		ClassTrainerCollapseAllButton.collapsed = 1;
		ClassTrainerCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
	end
end

function ClassTrainer_SelectFirstLearnableSkill()
	if ( GetNumTrainerServices() > 0 ) then
		ClassTrainerFrame.showSkillDetails = 1;
		ClassTrainer_SetSelection(2);
		FauxScrollFrame_SetOffset(ClassTrainerListScrollFrame, 0)		
	else
		ClassTrainerFrame.showSkillDetails = nil;
		ClassTrainer_SetSelection();
	end
	ClassTrainerListScrollFrameScrollBar:SetValue(0);
end

function ClassTrainer_SetSelection(id)
	--debuginfo("id is "..id);
	if ( ClassTrainerFrame.showSkillDetails ) then
		ClassTrainer_ShowSkillDetails();
	else
		ClassTrainer_HideSkillDetails();
		return;
	end
	-- General Info
	local serviceName, serviceSubText, serviceType, isExpanded = GetTrainerServiceInfo(id);
	ClassTrainerSkillHighlightFrame:Show();
	if ( serviceType == "available" ) then
		ClassTrainerSkillHighlight:SetVertexColor(0, 1.0, 0);
		--debuginfo("its green");
	elseif ( serviceType == "used" ) then
		ClassTrainerSkillHighlight:SetVertexColor(0.5, 0.5, 0.5);
		--debuginfo("its gray");
	elseif ( serviceType == "unavailable" ) then
		ClassTrainerSkillHighlight:SetVertexColor(0.9, 0, 0);
		--debuginfo("its red");
	else
		-- Is header, so collapse or expand header
		ClassTrainerSkillHighlightFrame:Hide();
		if ( isExpanded ) then
			CollapseTrainerSkillLine(id);
		else
			ExpandTrainerSkillLine(id);
		end
		return;
	end
	if ( not serviceName ) then
		serviceName = TEXT(UNKNOWN);
	end
	ClassTrainerSkillName:SetText(serviceName);
	if ( not serviceSubText ) then
		serviceSubText = "";
	end
	ClassTrainerSubSkillName:SetText(format(TEXT(PARENS_TEMPLATE), serviceSubText));
	ClassTrainerFrame.selectedService = id;
	SelectTrainerService(id);
	ClassTrainerSkillIcon:SetNormalTexture(GetTrainerServiceIcon(id));
	-- Build up the requirements string
	local requirements = "";
	ClassTrainerSkillRequirements:Hide();
	-- Level Requirements
	local reqLevel = GetTrainerServiceLevelReq(id);
	local separator = "";
	if ( reqLevel > 1 ) then
		separator = ", ";
		if ( isPetLearnSpell ) then
			if ( UnitLevel("pet") >= reqLevel ) then
				requirements = requirements..format(TEXT(TRAINER_PET_LEVEL), reqLevel);
			else
				requirements = requirements..format(TEXT(TRAINER_PET_LEVEL_RED), reqLevel);
			end
		else
			if ( UnitLevel("player") >= reqLevel ) then
				requirements = requirements..format(TEXT(TRAINER_REQ_LEVEL), reqLevel);
			else
				requirements = requirements..format(TEXT(TRAINER_REQ_LEVEL_RED), reqLevel);
			end
		end
	end
	-- Skill Requirements
	local skill, rank, hasReq = GetTrainerServiceSkillReq(id);
	if ( skill ) then
		if ( hasReq ) then
			requirements = requirements..separator..format(TEXT(TRAINER_REQ_SKILL_RANK), skill, rank );
		else
			requirements = requirements..separator..format(TEXT(TRAINER_REQ_SKILL_RANK_RED), skill, rank );
		end
		separator = ", ";
	end
	-- Ability Requirements
	local numRequirements = GetTrainerServiceNumAbilityReq(id);
	local ability, abilityName, abilitySubText, abilityType;
	if ( numRequirements > 0 ) then
		for i=1, numRequirements, 1 do
			ability, hasReq = GetTrainerServiceAbilityReq(id, i);
			abilityName, abilitySubText, abilityType = GetTrainerServiceInfo(id);
			if ( hasReq or (abilityType == "used") ) then
				requirements = requirements..separator..format(TEXT(TRAINER_REQ_ABILITY), ability );
			else
				requirements = requirements..separator..format(TEXT(TRAINER_REQ_ABILITY_RED), ability );
			end
			separator = ", ";
		end
	end
	-- Step Requirements
	local step, met = GetTrainerServiceStepReq(id);
	if ( step ) then
		if ( met ) then
			requirements = requirements..separator..format(TEXT(TRAINER_REQ_ABILITY), step );
		else 
			requirements = requirements..separator..format(TEXT(TRAINER_REQ_ABILITY_RED), step );
		end
	end
	if ( requirements ~= "" ) then
		ClassTrainerSkillRequirements:SetText(REQUIRES_LABEL.." "..requirements);
		ClassTrainerSkillRequirements:Show();
	else
		
	end
	-- Money Frame and cost
	local moneyCost, cpCost1, cpCost2 = GetTrainerServiceCost(id);
	local cp1, cp2 = UnitCharacterPoints("player");
	local unavailable, skillPointCost;
	if ( moneyCost == 0 ) then
		ClassTrainerDetailMoneyFrame:Hide();
	else
		ClassTrainerDetailMoneyFrame:Show();
		if ( GetMoney() >= moneyCost ) then
			SetMoneyFrameColor("ClassTrainerDetailMoneyFrame", 1.0, 1.0, 1.0);
		else
			SetMoneyFrameColor("ClassTrainerDetailMoneyFrame", 1.0, 0.1, 0.1);
			unavailable = 1;
		end
	end
	
	RefreshMoneyFrame("ClassTrainerDetailMoneyFrame", moneyCost, 1, 1);
	if ( cpCost2 > 0 ) then
		if ( cp2 >= cpCost2 or serviceType == "used" ) then
			skillPointCost = format(TEXT(TRAINER_COST_SP),cpCost2);
		else
			skillPointCost = format(TEXT(TRAINER_COST_SP_RED),cpCost2);
			unavailable = 1;
		end
		if ( moneyCost > 0 ) then
			skillPointCost = skillPointCost..", ";
		end
		ClassTrainerSkillPointCost:SetText(skillPointCost);
		ClassTrainerDetailMoneyFrame:SetPoint("LEFT", "ClassTrainerSkillPointCost", "RIGHT", 3, 0);
		ClassTrainerSkillPointCost:Show();
	elseif ( cpCost1 > 0 ) then
		if ( cp1 >= cpCost1 or serviceType == "used" ) then
			skillPointCost = format(TEXT(TRAINER_COST_TP),cpCost1);
		else
			skillPointCost = format(TEXT(TRAINER_COST_TP_RED),cpCost1);
			unavailable = 1;
		end
		if ( moneyCost > 0 ) then
			skillPointCost = skillPointCost..", ";
		end
		ClassTrainerSkillPointCost:SetText(skillPointCost);
		ClassTrainerDetailMoneyFrame:SetPoint("LEFT", "ClassTrainerSkillPointCost", "RIGHT", 3, 0);
		ClassTrainerSkillPointCost:Show();
	else
		ClassTrainerDetailMoneyFrame:SetPoint("LEFT", "ClassTrainerCostLabel", "RIGHT", 12, 0);
		ClassTrainerSkillPointCost:Hide();
	end
	ClassTrainerSkillDescription:SetText( GetTrainerServiceDescription(id) );
	if ( serviceType == "available" and not unavailable ) then
		ClassTrainerTrainButton:Enable();
	else
		ClassTrainerTrainButton:Disable();
	end

	-- Determine what type of spell to display
	local isLearnSpell;
	local isPetLearnSpell;
	isLearnSpell, isPetLearnSpell = IsTrainerServiceLearnSpell(id);
	if ( isLearnSpell ) then
		if ( isPetLearnSpell ) then
			ClassTrainerSkillName:SetText(ClassTrainerSkillName:GetText() ..TEXT(TRAINER_PET_SPELL_LABEL));
		end
	end
	ClassTrainerDetailScrollFrame:UpdateScrollChildRect();
	-- Show or hide scrollbar
	if ((ClassTrainerDetailScrollFrameScrollBarScrollUpButton:IsEnabled() == 0) and (ClassTrainerDetailScrollFrameScrollBarScrollDownButton:IsEnabled() == 0) ) then
		ClassTrainerDetailScrollFrameScrollBar:Hide();
		ClassTrainerDetailScrollFrameTop:Hide();
		ClassTrainerDetailScrollFrameBottom:Hide();
	else
		ClassTrainerDetailScrollFrameScrollBar:Show();
		ClassTrainerDetailScrollFrameTop:Show();
		ClassTrainerDetailScrollFrameBottom:Show();
	end
end

function ClassTrainerSkillButton_OnClick(button)
	if ( button == "LeftButton" ) then
		ClassTrainerFrame.selectedService = this:GetID();
		ClassTrainerFrame.showSkillDetails = 1;
		ClassTrainer_SetSelection(this:GetID());
		ClassTrainerFrame_Update();
	end
end

function ClassTrainerTrainButton_OnClick()
	BuyTrainerService(ClassTrainerFrame.selectedService);
	ClassTrainerFrame.showSkillDetails = nil;
	ClassTrainer_SetSelection(ClassTrainerFrame.selectedService);
	ClassTrainerFrame_Update();
end

function ClassTrainer_SetSubTextColor(button, r, g, b)
	button.r = r;
	button.g = g;
	button.b = b;
	getglobal(button:GetName().."SubText"):SetTextColor(r, g, b);
end

function ClassTrainerSkillButton_OnEnter()
	getglobal(this:GetName().."SubText"):SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
end

function ClassTrainerSkillButton_OnLeave()
	getglobal(this:GetName().."SubText"):SetTextColor(this.r, this.g, this.b);
end

function ClassTrainerSortButton_OnClick(type)
	if ( this:GetChecked() ) then
		SetTrainerServiceTypeFilter(type, 1);
	else
		SetTrainerServiceTypeFilter(type, 0);
	end
	ClassTrainerListScrollFrameScrollBar:SetValue(0);
end

function ClassTrainerSortButton_OnShow(button, type)
	if ( GetTrainerServiceTypeFilter(type) ) then
		button:SetChecked(1);
	else
		button:SetChecked(0);
	end
end

function ClassTrainerCollapseAllButton_OnClick()
	if (this.collapsed) then
		this.collapsed = nil;
		ExpandTrainerSkillLine(0);
	else
		this.collapsed = 1;
		ClassTrainerListScrollFrameScrollBar:SetValue(0);
		CollapseTrainerSkillLine(0);
	end
end

function ClassTrainer_HideSkillDetails()
	ClassTrainerSkillName:Hide();
	ClassTrainerSkillIcon:Hide();
	ClassTrainerSkillRequirements:Hide();
	ClassTrainerSkillDescription:Hide();
	ClassTrainerDetailMoneyFrame:Hide();
	ClassTrainerSkillPointCost:Hide();
	ClassTrainerCostLabel:Hide();
end

function ClassTrainer_ShowSkillDetails()
	ClassTrainerSkillName:Show();
	ClassTrainerSkillIcon:Show();
	ClassTrainerSkillRequirements:Show();
	ClassTrainerSkillDescription:Show();
	ClassTrainerDetailMoneyFrame:Show();
	ClassTrainerSkillPointCost:Show();
	ClassTrainerCostLabel:Show();
end

function ClassTrainer_SetToTradeSkillTrainer()
	CLASS_TRAINER_SKILLS_DISPLAYED = 10;
	ClassTrainerSkill11:Hide();
	ClassTrainerListScrollFrame:SetHeight(168);
	local cp1, cp2 = UnitCharacterPoints("player");
	ClassTrainerFrameSkillPointLabel:SetText(CHARACTER_POINTS2_COLON.." "..HIGHLIGHT_FONT_COLOR_CODE..cp2..FONT_COLOR_CODE_CLOSE);
	ClassTrainerFrameSkillPointLabel:Show();
	ClassTrainerFrameBottomLeft:SetTexture("Interface\\TradeSkillFrame\\UI-TradeSkillTrainer-BotLeft");
	ClassTrainerFrameBottomRight:SetTexture("Interface\\TradeSkillFrame\\UI-TradeSkillTrainer-BotRight");
	ClassTrainerHorizontalBarLeft:SetPoint("TOPLEFT", "ClassTrainerFrame", "TOPLEFT", 15, -259);
end

function ClassTrainer_SetToClassTrainer()
	CLASS_TRAINER_SKILLS_DISPLAYED = 11;
	ClassTrainerListScrollFrame:SetHeight(184);
	ClassTrainerFrameSkillPointLabel:Hide();
	ClassTrainerFrameBottomLeft:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-BotLeft");
	ClassTrainerFrameBottomRight:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-BotRight");
	ClassTrainerHorizontalBarLeft:SetPoint("TOPLEFT", "ClassTrainerFrame", "TOPLEFT", 15, -275);
end