
COMBATFEEDBACK_FADEINTIME = 0.2;
COMBATFEEDBACK_HOLDTIME = 0.7;
COMBATFEEDBACK_FADEOUTTIME = 0.3;

CombatFeedbackText = { };
CombatFeedbackText["MISS"]		= TEXT(MISS_CAPS);
CombatFeedbackText["EVADE"]		= TEXT(EVADE_CAPS);
CombatFeedbackText["DODGE"]		= TEXT(DODGE_CAPS);
CombatFeedbackText["PARRY"]		= TEXT(PARRY_CAPS);
CombatFeedbackText["BLOCK"]		= TEXT(BLOCK_CAPS);
CombatFeedbackText["STUN"]		= TEXT(STUN_CAPS);
CombatFeedbackText["INTERRUPT"]	= TEXT(INTERRUPT_CAPS);
CombatFeedbackText["IMMUNE"]	= TEXT(IMMUNE_CAPS);
CombatFeedbackText["RESIST"]	= TEXT(RESIST_CAPS);


SpellMissFeedbackText = { };
SpellMissFeedbackText["NONE"]			= nil;
SpellMissFeedbackText["PHYSICAL"]		= TEXT(SPELLMISSED_MISS_CAPS);
SpellMissFeedbackText["RESIST"]			= TEXT(SPELLMISSED_RESIST_CAPS);
SpellMissFeedbackText["IMMUNE"]			= TEXT(SPELLMISSED_IMMUNE_CAPS);
SpellMissFeedbackText["EVADED"]			= TEXT(SPELLMISSED_EVADE_CAPS);
SpellMissFeedbackText["DODGED"]			= TEXT(SPELLMISSED_DODGE_CAPS);
SpellMissFeedbackText["BLOCKED"]		= TEXT(SPELLMISSED_BLOCK_CAPS);
SpellMissFeedbackText["TEMPIMMUNE"]		= nil;

function CombatFeedback_Initialize(feedbackText, fontHeight)
	this.feedbackText = feedbackText;
	this.feedbackFontHeight = fontHeight;
end

function CombatFeedback_OnSpellMissEvent(event) 
	local feedbackText = this.feedbackText;
	local fontHeight = this.feedbackFontHeight;
	local r = 1.0;
	local g = 1.0;
	local b = 1.0;

	local text = SpellMissFeedbackText[event];
	if ( text == nil ) then
		return;
	end

	if ( event == "IMMUNE" ) then
		fontHeight = fontHeight * 0.5;
	end

	this.feedbackStartTime = GetTime();
	feedbackText:SetTextHeight(fontHeight);
	feedbackText:SetText(text);
	feedbackText:SetTextColor(r, g, b);
	feedbackText:SetAlpha(0.0);
	feedbackText:Show();
end

function CombatFeedback_OnCombatEvent(event, flags, amount, type)
	local feedbackText = this.feedbackText;
	local fontHeight = this.feedbackFontHeight;
	local text = "";
	local r = 1.0;
	local g = 1.0;
	local b = 1.0;

	if( event == "IMMUNE" ) then
		text = CombatFeedbackText["IMMUNE"];
		fontHeight = fontHeight * 0.5;
	elseif ( event == "WOUND" ) then
		if ( flags == "ABSORB" )then
			fontHeight = fontHeight * 0.75;
			text = TEXT(ABSORB_CAPS);
		elseif ( flags == "BLOCK" ) then
			fontHeight = fontHeight * 0.75;
			text = TEXT(BLOCK_CAPS);
		elseif ( amount > 0 ) then
			if ( flags == "CRITICAL" or flags == "GLANCING" or flags == "CRUSHING" ) then
				fontHeight = fontHeight * 1.5;
			end
			if ( type > 0 ) then
				r = 1.0;
				g = 1.0;
				b = 0.0;
			end
			text = amount;
		else
			text = CombatFeedbackText["MISS"];
		end
	elseif ( event == "HEAL" ) then
		text = amount;
		r = 0.0;
		g = 1.0;
		b = 0.0;
	else
		text = CombatFeedbackText[event];
	end

	this.feedbackStartTime = GetTime();

	feedbackText:SetTextHeight(fontHeight);
	feedbackText:SetText(text);
	feedbackText:SetTextColor(r, g, b);
	feedbackText:SetAlpha(0.0);
	feedbackText:Show();
end

function CombatFeedback_OnUpdate(elapsed)
	local feedbackText = this.feedbackText;
	if ( feedbackText:IsVisible() ) then
		local elapsedTime = GetTime() - this.feedbackStartTime;
		local fadeInTime = COMBATFEEDBACK_FADEINTIME;
		if ( elapsedTime < fadeInTime ) then
			local alpha = (elapsedTime / fadeInTime);
			feedbackText:SetAlpha(alpha);
			return;
		end
		local holdTime = COMBATFEEDBACK_HOLDTIME;
		if ( elapsedTime < (fadeInTime + holdTime) ) then
			feedbackText:SetAlpha(1.0);
			return;
		end
		local fadeOutTime = COMBATFEEDBACK_FADEOUTTIME;
		if ( elapsedTime < (fadeInTime + holdTime + fadeOutTime) ) then
			local alpha = 1.0 - ((elapsedTime - holdTime - fadeInTime) / fadeOutTime);
			feedbackText:SetAlpha(alpha);
			return;
		end
		feedbackText:Hide();
	end
end
