-- CHAT PROTOTYPE STUFF
SELECTED_DOCK_FRAME = nil;

DOCKED_CHAT_FRAMES = {};

MOVING_CHATFRAME = nil;

CHATFRAME_MENU_HEIGHT = 20;

DEFAULT_CHATFRAME_ALPHA = 0.25;
DEFAULT_CHATFRAME_COLOR = {r = 0, g = 0, b = 0};

CHAT_FRAME_TEXTURES = {
	"Background",
	"BorderTopLeft",
	"BorderTopRight",
	"BorderBotLeft",
	"BorderBotRight",
	"BorderTop",
	"BorderBot",
	"BorderLeft",
	"BorderRight",
	"InnerBorderTopLeft",
	"InnerBorderTopRight",
	"InnerBorderBotRight",
	"InnerBorderRight",
	"InnerBorderTop",
--[[	"TabLeft",
	"TabMiddle",
	"TabRight"
]]
}

CHAT_FRAME_HIDEABLE_ELEMENTS = {
	"InnerBorderTopRight",
	"InnerBorderBotRight",
	"InnerBorderRight",
	"InnerBorderTop",
	"InnerBorderTopLeft",
	"ResizeButton",
	"ScrollFrame"
}

function FloatingChatFrame_OnLoad()
	FCF_SetTabPosition(this, 0);
	FloatingChatFrame_Update(this:GetID());
	FCF_ScrollBarUpdate(getglobal(this:GetName().."ScrollFrame"));
	if ( ChatFrameEditBox ) then
		this.editBox = ChatFrameEditBox;
	end
end

function FloatingChatFrame_OnEvent(event)
	if ( event == "UPDATE_CHAT_WINDOWS" ) then
		FloatingChatFrame_Update(this:GetID(), 1);
		this.isInitialized = 1;
	end
end

function FloatingChatFrame_Update(id, onUpdateEvent)	
	local name, fontSize, r, g, b, a, shown, locked, docked = GetChatWindowInfo(id);
	local chatFrame = getglobal("ChatFrame"..id);
	local chatTab = getglobal("ChatFrame"..id.."Tab");

	-- Set Tab Name
	FCF_SetWindowName(chatFrame, name, 1)

	-- Set Frame Color and Alpha
	FCF_SetWindowColor(chatFrame, r, g, b, 1);
	FCF_SetWindowAlpha(chatFrame, a, 1);
	
	-- Locked display stuff
	local init = nil;
	if ( onUpdateEvent and not chatFrame.isInitialized) then
		init = 1;
	end
	FCF_SetLocked(chatFrame, locked, init);
	getglobal(chatFrame:GetName().."TabLockButton"):SetChecked(locked);

	if ( shown ) then
		chatFrame:Show();
	else
		chatFrame:Hide();
	end
	
	if ( not FCF_IsAdvancedChatEnabled() ) then
		return;
	end
	
	if ( docked and shown ) then
		FCF_DockFrame(chatFrame, docked);
	else
		FCF_UnDockFrame(chatFrame);
	end
end

-- Channel Dropdown
function FCFChannelDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, FCFChannelDropDown_Initialize, "MENU");
	UIDropDownMenu_SetText(CHANNELS, this);
	UIDropDownMenu_JustifyText("LEFT");
end

function FCFChannelDropDown_Initialize()
	FCFDropDown_LoadChannels(GetChannelList());
end

function FCFDropDown_LoadChannels(...)
	local checked;
	local channelList = FCF_GetCurrentChatFrame().channelList;
	local zoneChannelList = FCF_GetCurrentChatFrame().zoneChannelList;
	local info;
	local channelIndex = 1;
	for i=1, arg.n, 2 do
		checked = nil;
		if ( channelList ) then
			for index, value in channelList do
				if ( value == arg[i+1] ) then
					checked = 1;
				end
			end
		end
		if ( zoneChannelList ) then
			for index, value in zoneChannelList do
				if ( value == arg[i+1] ) then
					checked = 1;
				end
			end
		end
		info = {};
		info.text = arg[i+1];
		info.value = "CHANNEL"..channelIndex;
		info.func = FCFChannelDropDown_OnClick;
		info.checked = checked;
		info.keepShownOnClick = 1;
		-- Color the chat channel
		local color = ChatTypeInfo["CHANNEL"..channelIndex];
		info.hasColorSwatch = 1;
		info.r = color.r;
		info.g = color.g;
		info.b = color.b;
		-- Set the function the color picker calls
		info.swatchFunc = FCF_SetChatTypeColor;
		info.cancelFunc = FCF_CancelFontColorSettings;
		UIDropDownMenu_AddButton(info);

		channelIndex = channelIndex + 1;
	end
end

function FCFChannelDropDown_OnClick()
	if ( UIDropDownMenuButton_GetChecked() ) then
		ChatFrame_RemoveChannel(FCF_GetCurrentChatFrame(), UIDropDownMenuButton_GetName());
	else
		ChatFrame_AddChannel(FCF_GetCurrentChatFrame(), UIDropDownMenuButton_GetName());
	end
end

-- Message Type Dropdown
function FCFMessageTypeDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, FCFMessageTypeDropDown_Initialize, "MENU");
	UIDropDownMenu_SetText(MESSAGE_TYPES, this);
	UIDropDownMenu_JustifyText("LEFT");
end

function FCFMessageTypeDropDown_Initialize()
	FCFDropDown_LoadMessageTypes(GetChatWindowMessages(FCF_GetCurrentChatFrameID()));
end

function FCFDropDown_LoadMessageTypes(...)
	local checked, chatTypeInfo;
	local messageTypeList = FCF_GetCurrentChatFrame().messageTypeList;
	local info;

	-- If the menu level is 2 then generate the submenu list and return
	if ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
		local chatGroup = ChatTypeGroup[UIDROPDOWNMENU_MENU_VALUE];
		if ( chatGroup ) then
			for index, value in chatGroup do
				info = {};
				info.text = TEXT(FCF_StripChatMsg(value));
				info.value = FCF_StripChatMsg(value);
				chatTypeInfo = ChatTypeInfo[FCF_StripChatMsg(value)];
				-- If no color assigned then make it white
				if ( chatTypeInfo ) then
					-- Disable the button and color the text white
					info.notClickable = 1;
					-- Set to be notcheckable
					info.notCheckable = 1;
					-- Set the function to be called when a color is set
					info.swatchFunc = FCF_SetChatTypeColor;
					-- Set the swatch color info
					info.hasColorSwatch = 1;
					info.r = chatTypeInfo.r;
					info.g = chatTypeInfo.g;
					info.b = chatTypeInfo.b;
					-- Set function called when cancel is clicked in the colorpicker
					info.cancelFunc = FCF_CancelFontColorSettings;
					UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
				end
				
			end
		end
		return;
	end
	
	-- If the menu level is 1 then generate the normal list
	for index, value in ChatTypeGroup do
		-- Hard coded case to not display channel options
		if ( index ~= "CHANNEL" ) then
			checked = nil;
			if ( messageTypeList ) then
				for joinedIndex, joinedValue in messageTypeList do
					if ( index == joinedValue ) then
						checked = 1;
					end
				end
			end
			info = {};
			info.text = TEXT(index);
			info.value = index;
			info.func = FCFMessageTypeDropDown_OnClick;
			info.checked = checked;
			-- Set to keep shown on button click
			info.keepShownOnClick = 1;
			
			-- If more than one message type in a Chat Type Group need to show an expand arrow
			if ( getn(value) > 1 ) then
				info.hasArrow = 1;
				UIDropDownMenu_AddButton(info);
			else
				chatTypeInfo = ChatTypeInfo[FCF_StripChatMsg(value[1])];
				-- If no chatTypeInfo then don't display
				if ( chatTypeInfo ) then
					-- Set the function to be called when a color is set
					info.swatchFunc = FCF_SetChatTypeColor;
					-- Set the swatch color info
					info.hasColorSwatch = 1;
					info.r = chatTypeInfo.r;
					info.g = chatTypeInfo.g;
					info.b = chatTypeInfo.b;	
					UIDropDownMenu_AddButton(info);
				end
			end
		end
	end
end

function FCFMessageTypeDropDown_OnClick()
	if ( UIDropDownMenuButton_GetChecked() ) then
		ChatFrame_RemoveMessageGroup(FCF_GetCurrentChatFrame(), this.value);
	else
		ChatFrame_AddMessageGroup(FCF_GetCurrentChatFrame(), this.value);
	end
end

-- Preferences Dropdown
function FCFPreferencesDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, FCFPreferencesDropDown_Initialize, "MENU");
	UIDropDownMenu_SetText(PREFERENCES, this);
	UIDropDownMenu_JustifyText("LEFT");
end

function FCFPreferencesDropDown_Initialize()
	local name, fontSize, r, g, b, a = GetChatWindowInfo(FCF_GetCurrentChatFrameID());
	local info = {};

	-- If level 2 then do other stuff
	if ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
		-- If this is the font size menu then create dropdown
		if ( UIDROPDOWNMENU_MENU_VALUE == FONT_SIZE ) then
			-- Add the font heights from the font height table
			for index, value in CHAT_FONT_HEIGHTS do
				info = {};
				info.text = format(FONT_SIZE_TEMPLATE, value);
				info.value = value;
				info.func = FCF_SetChatWindowFontSize;
				info.keepShownOnClick = 1;

				if ( value == floor(FCF_GetCurrentChatFrame():GetFontHeight()+0.5) ) then
					info.checked = 1;
				end

				UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			end
		end
		return;
	end
  
	-- Font size title
	info.text = FONT_SIZE;
	info.notClickable = 1;
	info.hasArrow = 1;
	info.func = nil;
	UIDropDownMenu_AddButton(info);

	-- Set Background color
	info = {};
	info.text = BACKGROUND;
	info.hasColorSwatch = 1;
	info.r = r;
	info.g = g;
	info.b = b;
	-- Done because the slider is reversed
	if ( a ) then
		a = 1- a;
	end
	info.opacity = a;
	info.swatchFunc = FCF_SetChatWindowBackGroundColor;
	info.func = UIDropDownMenuButton_OpenColorPicker;
	info.hasOpacity = 1;
	info.opacityFunc = FCF_SetChatWindowOpacity;
	info.cancelFunc = FCF_CancelWindowColorSettings;
	UIDropDownMenu_AddButton(info);

	-- Add name button
	info = {};
	info.text = RENAME_CHAT_WINDOW;
	info.func = FCF_RenameChatWindow_Popup;
	UIDropDownMenu_AddButton(info);
end


function FCF_OpenNewWindow(name)
	local temp, shown;
	local count = 1;
	local chatFrame;
	
	for i=1, NUM_CHAT_WINDOWS do
		temp, temp, temp, temp, temp, temp, shown, temp = GetChatWindowInfo(i);
		chatFrame = getglobal("ChatFrame"..i);
		chatTab = getglobal("ChatFrame"..i.."Tab");
		if ( not shown or (count == NUM_CHAT_WINDOWS) ) then
			if ( not name ) then
				name = format(CHAT_NAME_TEMPLATE, i);			
			end
			
			-- initialize the frame
			FCF_SetWindowName(chatFrame, name);
			FCF_SetWindowColor(chatFrame, DEFAULT_CHATFRAME_COLOR.r, DEFAULT_CHATFRAME_COLOR.g, DEFAULT_CHATFRAME_COLOR.b);
			FCF_SetWindowAlpha(chatFrame, DEFAULT_CHATFRAME_ALPHA);
			SetChatWindowLocked(i, nil);

			-- Show the frame and tab
			chatFrame:Show();
			chatTab:Show();
			SetChatWindowShown(i, 1);
			
			-- Dock the frame by default
			FCF_DockFrame(chatFrame);
			break;
		end
		count = count + 1;
	end
end

function FCF_RenameChatWindow_Popup()
	local dialog = StaticPopup_Show("NAME_CHAT");
	dialog.data = FCF_GetCurrentChatFrameID();
end

function FCF_SetWindowName(frame, name, doNotSave)
	if ( not name or name == "") then
		-- Hack to initialize the chat window names, since globalstrings are not available on init
		if ( frame:GetID() == 1 ) then
			name = GENERAL;
		elseif ( frame:GetID() == 2 ) then
			name = COMBAT_LOG;
		else
			name = format(CHAT_NAME_TEMPLATE, frame:GetID());
		end
	end
	local tab = getglobal(frame:GetName().."Tab");
	tab:SetText(name);
	PanelTemplates_TabResize(60, tab);
	if ( not doNotSave ) then
		SetChatWindowName(frame:GetID(), name);
	end
end

function FCF_SetWindowColor(frame, r, g, b, doNotSave)
	local name = frame:GetName();
	for index, value in CHAT_FRAME_TEXTURES do
		getglobal(name..value):SetVertexColor(r,g,b);
	end
	if ( not doNotSave ) then
		SetChatWindowColor(frame:GetID(), r, g, b);
	end
end

function FCF_SetWindowAlpha(frame, alpha, doNotSave)
	local name = frame:GetName();
	for index, value in CHAT_FRAME_TEXTURES do
		getglobal(name..value):SetAlpha(alpha);
	end
	if ( not doNotSave ) then
		SetChatWindowAlpha(frame:GetID(), alpha);
	end
	
end

function FCF_GetCurrentChatFrameID()
	return UIDropDownMenu_GetCurrentDropDown():GetParent():GetParent():GetID();
end

function FCF_GetCurrentChatFrame()
	return UIDropDownMenu_GetCurrentDropDown():GetParent():GetParent();
end

function FCF_SetChatTypeColor()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	ChangeChatColor(UIDROPDOWNMENU_MENU_VALUE, r, g, b);
end

function FCF_SetChatWindowBackGroundColor()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	FCF_SetWindowColor(FCF_GetCurrentChatFrame(), r, g, b)
	SetChatWindowColor(FCF_GetCurrentChatFrameID(), r, g, b);
end

function FCF_SetChatWindowOpacity()
	local alpha = 1.0 - OpacitySliderFrame:GetValue();
	FCF_SetWindowAlpha(FCF_GetCurrentChatFrame(), alpha);
end

function FCF_SetChatWindowFontSize(chatFrame, fontSize)
	if ( not chatFrame ) then
		chatFrame = FCF_GetCurrentChatFrame();
	end
	if ( not fontSize ) then
		fontSize = this.value;
	end
	chatFrame:SetFontHeight(fontSize);
	SetChatWindowSize(chatFrame:GetID(), fontSize);
end

function FCF_CancelFontColorSettings(previousValues)
	if ( previousValues.r ) then
		ChangeChatColor(UIDROPDOWNMENU_MENU_VALUE, previousValues.r, previousValues.g, previousValues.b);
	end
end

function FCF_CancelWindowColorSettings(previousValues)
	if ( previousValues.r ) then
		FCF_SetWindowColor(FCF_GetCurrentChatFrame(), previousValues.r, previousValues.g, previousValues.b)
		SetChatWindowColor(FCF_GetCurrentChatFrameID(), previousValues.r, previousValues.g, previousValues.b);
	end
	if ( previousValues.opacity ) then
		FCF_SetWindowAlpha(FCF_GetCurrentChatFrame(), 1 - previousValues.opacity);
	end
end

function FCF_StripChatMsg(string)
	if ( strsub(string,1,8) == "CHAT_MSG" ) then
		return strsub(string,10);
	else
		return string;
	end
end

function FCF_LockButton_OnClick()
	local frameName = "ChatFrame"..this:GetParent():GetID();

	-- Locked display stuff
	if ( this:GetChecked() ) then
		PlaySound("igMainMenuOptionCheckBoxOn");	
	else
		PlaySound("igMainMenuOptionCheckBoxOff");
	end
	FCF_SetLocked(getglobal(frameName), this:GetChecked())
	SetChatWindowLocked(this:GetParent():GetID(), this:GetChecked());
	FCF_DockUpdate();
end

function FCF_SetLocked(chatFrame, isLocked, init)
	if ( not chatFrame.isInitialized and not init) then
		return;
	end

	local frameName = chatFrame:GetName();
	local background = getglobal(frameName.."Background");
	local innerBorderTopLeft = getglobal(frameName.."InnerBorderTopLeft");
	local innerBorderTopRight = getglobal(frameName.."InnerBorderTopRight");
	local chatFrameMenu = getglobal(frameName.."Menu");
	local closeButton = getglobal(frameName.."CloseButton");
	local resizeButton = getglobal(frameName.."ResizeButton");
	
	if ( not chatFrame.isDocked ) then
		-- Anchor chatFrame to UIParent so when you resize it it doesn't move
		local x = chatFrame:GetLeft();
		local y = chatFrame:GetTop();
		if ( not x or not y ) then
			chatFrame:ClearAllPoints();
			if ( chatFrame == ChatFrame2 ) then
				chatFrame:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -32, 65);
				chatFrame:SetWidth(320);
				chatFrame:SetHeight(128);
			else
				chatFrame:SetPoint("TOPLEFT", "UIParent", "TOPLEFT", 300, -300);
			end
		else
			if ( not init ) then
				if ( isLocked ) then
					y = y + CHATFRAME_MENU_HEIGHT;
				else
					y = y - (CHATFRAME_MENU_HEIGHT);
				end
			end
			if ( FCF_IsAdvancedChatEnabled() ) then
				chatFrame:ClearAllPoints();
				chatFrame:SetPoint("TOPLEFT", "UIParent", "TOPLEFT", x, y - UIParent:GetTop());
			end
		end
	end
	-- Locked display stuff
	if ( isLocked ) then
		-- Enlarge chatFrame and shrink background
		background:SetPoint("TOPLEFT", chatFrame:GetName(), "TOPLEFT", -2, 3);
		if ( not init ) then
			chatFrame:SetHeight(chatFrame:GetHeight() + CHATFRAME_MENU_HEIGHT);
		end
		
		innerBorderTopLeft:SetPoint("TOPLEFT", frameName.."BorderTopLeft", "TOPLEFT", 4, -4);
		innerBorderTopRight:SetPoint("TOPRIGHT", frameName.."BorderTopRight", "TOPRIGHT", -4, -4);
		chatFrameMenu:Hide();
		closeButton:Hide();
		resizeButton:Hide();
	else
		-- Enlarge background and shrink the chatFrame
		background:SetPoint("TOPLEFT", chatFrame:GetName(), "TOPLEFT", -2, 23);
		if ( not init ) then
			chatFrame:SetHeight(chatFrame:GetHeight() - CHATFRAME_MENU_HEIGHT);
		end
		
		innerBorderTopLeft:SetPoint("TOPLEFT", frameName.."BorderTopLeft", "TOPLEFT", 4, -24);
		innerBorderTopRight:SetPoint("TOPRIGHT", frameName.."BorderTopRight", "TOPRIGHT", -4, -24);
		chatFrameMenu:Show();
		if ( chatFrame:GetID() ~= 1 ) then
			closeButton:Show();
			resizeButton:Show();
		else
			closeButton:Hide();
		end
	end
	chatFrame.isLocked = isLocked;
	SetChatWindowLocked(chatFrame:GetID(), isLocked);
end

-- Docking handling functions

function FCF_OnUpdate()
	-- If advanced chat is disabled then don't do anything
	if ( not FCF_IsAdvancedChatEnabled() ) then
		return;
	end

	-- Need to draw the dock regions for a frame to define their rects
	if ( not ChatFrame1.init ) then
		for i=1, NUM_CHAT_WINDOWS do
			getglobal("ChatFrame"..i.."TabDockRegion"):Show();
		end
		ChatFrame1.init = 1;
		return;
	elseif ( ChatFrame1.init == 1  ) then
		for i=1, NUM_CHAT_WINDOWS do
			getglobal("ChatFrame"..i.."TabDockRegion"):Hide();
		end
		ChatFrame1.init = 2;
	end

	-- Detect if mouse is over any chat frames and if so show their tabs, if not hide them
	local chatFrame;

	if ( MOVING_CHATFRAME ) then
		local dockRegion;
		for index, value in DOCKED_CHAT_FRAMES do
			dockRegion = getglobal(value:GetName().."TabDockRegion");
			if ( MouseIsOver(dockRegion) ) then
				dockRegion:Show();
			else
				dockRegion:Hide();
			end
		end
	else
		for j=1, NUM_CHAT_WINDOWS do
			chatFrame = getglobal("ChatFrame"..j);
			chatTab = getglobal("ChatFrame"..j.."Tab");
			if ( chatFrame:IsVisible() and not chatFrame.isDocked ) then
				if ( MouseIsOver(chatFrame, 45, 0, 0, 0) ) then
					chatTab:Show();
				else
					chatTab:Hide();
				end	
			end
		end
	end
end

function FCF_DockUpdate()
	local numDockedFrames = getn(DOCKED_CHAT_FRAMES);
	local dockRegion, chatTab, previousDockedFrame;
	local dockWidth = 0;
	local previousDockRegion;
	local name;
	for index, value in DOCKED_CHAT_FRAMES do
		-- If not the initial chatframe then anchor the frame to the base chatframe
		name = value:GetName();
		if ( index ~= 1 ) then
			value:ClearAllPoints();
			-- Determine where to anchor the docked frames
			local yAnchor;
			if ( value.isLocked  ) then
				if ( DEFAULT_CHAT_FRAME.isLocked ) then
					yAnchor = 0;
				else
					yAnchor = CHATFRAME_MENU_HEIGHT;
				end
			else
				if ( DEFAULT_CHAT_FRAME.isLocked ) then
					yAnchor = -CHATFRAME_MENU_HEIGHT;
				else
					yAnchor = 0;
				end
			end
			value:SetPoint("TOPLEFT", DEFAULT_CHAT_FRAME:GetName(), "TOPLEFT", 0, yAnchor);
			value:SetPoint("BOTTOMLEFT", DEFAULT_CHAT_FRAME:GetName(), "BOTTOMLEFT", 0, 0);
			value:SetPoint("BOTTOMRIGHT", DEFAULT_CHAT_FRAME:GetName(), "BOTTOMRIGHT", 0, 0);
		end
		
		-- Hide the scrollbars
		
		for hideIndex, hideValue in CHAT_FRAME_HIDEABLE_ELEMENTS do
			getglobal(name..hideValue):Hide();
		end

		-- Select or deselect the frame
		chatTab = getglobal(value:GetName().."Tab");
		if ( FCF_IsAdvancedChatEnabled() ) then
			chatTab:Show();
		else
			chatTab:Hide();
		end
		

		if ( value == SELECTED_DOCK_FRAME ) then
			value:Show();
			getglobal(value:GetName().."TabLockButton"):Show();
			PanelTemplates_TabResize(60, chatTab);

			chatTab:SetAlpha(1.0);
		else
			value:Hide();
			getglobal(value:GetName().."TabLockButton"):Hide();
			PanelTemplates_TabResize(10, chatTab);

			chatTab:SetAlpha(1.0);
		end
		
		-- If there was a frame before this frame then anchor the tab
		
		if ( previousDockedFrame ) then
			chatTab:ClearAllPoints();
			FCF_SetTabPosition(value, dockWidth);
			getglobal(previousDockedFrame:GetName().."TabDockRegion"):SetPoint("RIGHT", value:GetName().."Tab", "CENTER", 0, 0);
		end

		-- If this is the last frame in the dock then extend the dockRegion, otherwise shrink it to the default width
		dockRegion = getglobal(chatTab:GetName().."DockRegion");
		dockRegion:SetPoint("LEFT", chatTab:GetName(), "CENTER", 0 , 0);
		if ( numDockedFrames == index ) then
			dockRegion:SetPoint("RIGHT", "ChatFrame"..chatTab:GetID(), "RIGHT", 0, 0);
		end
		dockRegion:Hide();
		
		-- Keep track of the width of the dock for anchoring purposes
		dockWidth = dockWidth + chatTab:GetWidth();
		previousDockedFrame = value;
	end
end

function FCF_DockFrame(frame, index)
	-- Return if already docked
	if ( frame.isDocked ) then
		return;
	end

	frame.isDocked = 1;

	-- Set index to n+1 if no index explicitly sent
	if ( not index ) then
		index = (getn(DOCKED_CHAT_FRAMES) + 1);
	end
	tinsert(DOCKED_CHAT_FRAMES, index, frame);
	
	-- Save docked state
	SetChatWindowDocked(frame:GetID(), index);
	FCF_SelectDockFrame(frame);
end

function FCF_UnDockFrame(frame)
	-- Undock frame regardless of whether its docked or not
	SetChatWindowDocked(frame:GetID(), nil);
	for index, value in DOCKED_CHAT_FRAMES do
		if ( value == frame ) then
			tremove(DOCKED_CHAT_FRAMES, index);
		end
	end
	
	frame.isDocked = nil;

	-- Show the scrollbars
	local name = frame:GetName();
	for index, value in CHAT_FRAME_HIDEABLE_ELEMENTS do
		getglobal(name..value):Show();
	end

	-- Set tab to full alpha
	local chatTab = getglobal(frame:GetName().."Tab");
	chatTab:SetAlpha(1.0);
	
	-- Show the lockbutton
	getglobal(frame:GetName().."TabLockButton"):Show();
	PanelTemplates_TabResize(60, chatTab);

	-- Reset dockregion anchors
	dockRegion = getglobal(frame:GetName().."TabDockRegion");
	dockRegion:SetPoint("RIGHT", frame:GetName(), "RIGHT", 0, 0);
	dockRegion:Hide();
	
	-- Select first docked frame
	FCF_SelectDockFrame(DOCKED_CHAT_FRAMES[1]);
end

function FCF_SelectDockFrame(frame)
	SELECTED_DOCK_FRAME = frame;
	-- Stop tab flashing
	local tabFlash = getglobal("ChatFrame"..this:GetID().."TabFlash");
	if ( tabFlash ) then
		UIFrameFlashRemoveFrame(tabFlash);
		tabFlash:Hide();
	end
	FCF_DockUpdate();
end

function FCF_Tab_OnClick()
	-- If frame is docked assume that a click is to select a chat window, not drag it
	local chatFrame = getglobal("ChatFrame"..this:GetID());
	if ( chatFrame.isDocked ) then
		FCF_SelectDockFrame(chatFrame);
		return;
	end
	-- If frame is not docked then allow the frame to be dragged or dropped
	if ( this:GetButtonState() == "PUSHED" ) then
		chatFrame:StopMovingOrSizing();
		local activeDockRegion = FCF_GetActiveDockRegion();
		if ( activeDockRegion ) then
			FCF_DockFrame(chatFrame, activeDockRegion);
		else
			-- Move chat frame if out of bounds
			FCF_ValidateChatFramePosition(chatFrame);
		end
		
		MOVING_CHATFRAME = nil;
	else
		-- If locked don't allow any movement
		if ( getglobal(this:GetName().."LockButton"):GetChecked() ) then
			return;
		end
		chatFrame:StartMoving();
		MOVING_CHATFRAME = chatFrame;
	end
end

function FCF_SetTabPosition(chatFrame, x)
	local chatTab = getglobal(chatFrame:GetName().."Tab");
	chatTab:SetPoint("BOTTOMLEFT", chatFrame:GetName().."Background", "TOPLEFT", x+2, 0);
end

function FCF_GetActiveDockRegion()
	for index, value in DOCKED_CHAT_FRAMES do
		dockRegion = getglobal(value:GetName().."TabDockRegion");
		if ( dockRegion:IsVisible() ) then
			return index + 1;
		end
	end
	return nil;
end

function FCF_ResetDock()
	local count = 1;
	local tempDock = DOCKED_CHAT_FRAMES;
	DOCKED_CHAT_FRAMES = {};
	for index, value in tempDock do
		DOCKED_CHAT_FRAMES[count] = value;
		SetChatWindowDocked(value:GetID(), count);
		count = count + 1;
	end
	FCF_DockUpdate();
end

function ChatFrame1_OnEvent(event)
	if ( event == "CVAR_UPDATE" ) then
		if ( arg1 == "ADVANCED_CHAT" ) then
			FCF_SetAdvancedChat(arg2);
		end
	elseif ( event == "UPDATE_CHAT_WINDOWS" ) then
		--FCF_SetAdvancedChat(FCF_IsAdvancedChatEnabled());
	end
end

function FCF_SetAdvancedChat(isAdvanced)
	if ( not isAdvanced or isAdvanced == "0" ) then
		-- Else hide new window button and set chatframe2 to be the combatlog
		ChatFrameNewWindowButton:Hide();
		FCF_SetLocked(ChatFrame1, 1);

		-- Set alpha and color
		ChatFrame1Tab:Hide();
		

		-- Setup combat log
		ChatFrame2:Show();
		SetChatWindowShown(2, 1);

		ChatFrame2:ClearAllPoints();	
		ChatFrame2:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -32, 65);

		ChatFrame2:SetWidth(320);
		ChatFrame2:SetHeight(128);

		if ( ChatFrame2.isDocked ) then
			FCF_UnDockFrame(ChatFrame2);
			FCF_SetTabPosition(ChatFrame2, 0);
		end
		
		ChatFrame2TabDockRegion:Hide();
		FCF_SetLocked(ChatFrame2, 1);
		
		ChatFrame2Tab:Hide();

		-- Unregister from all channels and chatgroups
		ChatFrame_RemoveAllChannels(ChatFrame2);
		ChatFrame_RemoveAllMessageGroups(ChatFrame2);

		-- Listen to the combat log messages
		ChatFrame_AddMessageGroup(ChatFrame2, "COMBAT_PARTY");
		ChatFrame_AddMessageGroup(ChatFrame2, "COMBAT_SELF");
		ChatFrame_AddMessageGroup(ChatFrame2, "COMBAT_ENEMY");
		ChatFrame_AddMessageGroup(ChatFrame2, "COMBAT_MISC");

		-- Hide all excess elements
		for hideIndex, hideValue in CHAT_FRAME_HIDEABLE_ELEMENTS do
			getglobal("ChatFrame2"..hideValue):Hide();
		end

		-- Show combat log scroll buttons
		CombatLogButtons:Show();

		-- Close the rest of the frames
		for i=3, NUM_CHAT_WINDOWS do
			FCF_Close(getglobal("ChatFrame"..i));
		end
	else
		-- If advanced chat is enabled show the create chat button and the chat frame tabs
		ChatFrameNewWindowButton:Show();
		ChatFrame1Tab:Show();

		-- Show all excess elements
		for hideIndex, hideValue in CHAT_FRAME_HIDEABLE_ELEMENTS do
			getglobal("ChatFrame2"..hideValue):Show();
		end

		CombatLogButtons:Hide();
	end
end

function FCF_Close(frame)
	if ( not frame ) then
		frame = this;
	end
	HideUIPanel(frame);
	getglobal(frame:GetName().."Tab"):Hide();
	FCF_UnDockFrame(frame);
	SetChatWindowShown(frame:GetID(), nil);
end

function FCF_IsAdvancedChatEnabled()
	if ( GetCVar("AdvancedChat") == "1" ) then
		return 1;
	else
		return nil;
	end
end

-- Scrollframe functions
function FCF_ScrollBarUpdate(frame)
	frame:SetHeight(frame:GetParent():GetHeight() - 30);
	
	local frameName = frame:GetName();
	local scrollBar = getglobal( frameName.."ScrollBar" );
	local scrollChildFrame = getglobal( frameName.."ScrollChildFrame" );
	local scrollUpButton = getglobal( frameName.."ScrollBarScrollUpButton" );
	local scrollDownButton = getglobal( frameName.."ScrollBarScrollDownButton" );
	local thumbTexture = getglobal( frameName.."ScrollBarThumbTexture" );
	local scrollFrameHeight = 0;
	local scrollChildHeight = 0;
	-- ScrollingMessageFrame info
	local numMessages = frame:GetParent():GetNumMessages();
	local numToDisplay = frame:GetParent():GetNumLinesDisplayed();
	local scroll = frame:GetParent():GetCurrentScroll();
	if ( numMessages <= numToDisplay ) then
		thumbTexture:Hide();
		return;
	end

	scrollBar:Show();
	scrollFrameHeight = (numMessages - numToDisplay);
	scrollChildHeight = numMessages;
	thumbTexture:Show();

	scrollBar:SetMinMaxValues(0, scrollFrameHeight); 
	scrollBar:SetValueStep(1);
	scrollChildFrame:SetHeight(scrollChildHeight);
	scrollBar:SetValue(scrollFrameHeight - scroll);

	-- Arrow button handling
	if ( (scrollBar:GetValue() == 0) or numMessages == 0) then
		scrollUpButton:Disable();
	else
		scrollUpButton:Enable();
	end
	if ( ((scrollBar:GetValue() - scrollFrameHeight) == 0) or numMessages == 0) then
		scrollDownButton:Disable();
	else
		scrollDownButton:Enable();
	end
end

function FCF_OnVerticalScroll()
	local scrollBar = getglobal(this:GetName().."ScrollBar");
	local min, max = scrollBar:GetMinMaxValues();
	this:GetParent():SetScrollFromBottom(max - scrollBar:GetValue());
end

-- Moves a ChatFrame to a valid position if the user moves it off the screen
function FCF_ValidateChatFramePosition(chatFrame)
	-- Determine if the dragging tab is offscreen.  If so move the frame
	local chatTab = getglobal(chatFrame:GetName().."Tab");
	local left = chatTab:GetLeft();
	local right = chatTab:GetRight();
	local top = chatTab:GetTop();
	local bottom = chatTab:GetBottom();
	local newAnchorX, newAnchorY;
	local offscreenPadding = 15;
	if ( top < (0 + MainMenuBar:GetHeight() + offscreenPadding)) then
		-- Off the bottom of the screen
		newAnchorY = MainMenuBar:GetHeight() + chatTab:GetHeight() - GetScreenHeight(); 
	elseif ( bottom > GetScreenHeight() ) then
		-- Off the top of the screen
		newAnchorY =  -chatTab:GetHeight();
	end
	if ( right < 0 ) then
		-- Off the left of the screen
		newAnchorX = chatTab:GetWidth();
	elseif ( left > GetScreenWidth() ) then
		-- Off the right of the screen
		newAnchorX = GetScreenWidth() - chatTab:GetWidth();
	end
	if ( newAnchorX or newAnchorY ) then
		if ( not newAnchorX ) then
			newAnchorX = left;
		elseif ( not newAnchorY ) then
			newAnchorY = top - GetScreenHeight();
		end
		chatFrame:SetPoint("TOPLEFT", "UIParent", "TOPLEFT", newAnchorX, newAnchorY);
	end
end

-- Tab flashing functions
function FCF_FlashTab()
	local tabFlash = getglobal(this:GetName().."TabFlash");
	if ( not this.isDocked or (this == SELECTED_DOCK_FRAME) or UIFrameIsFlashing(tabFlash) ) then
		return;
	end
	tabFlash:Show();
	UIFrameFlash(tabFlash, 0.25, 0.25, 60, nil, 0.5, 0.5);
end