function MoneyInputFrame_ResetMoney(moneyFrame)
	getglobal(moneyFrame:GetName().."Gold"):SetText(nil);
	getglobal(moneyFrame:GetName().."Silver"):SetText(nil);
	getglobal(moneyFrame:GetName().."Copper"):SetText(nil);
end

function MoneyInputFrame_GetCopper(moneyFrame)
	local totalCopper = 0;
	local copper = getglobal(moneyFrame:GetName().."Copper"):GetText();
	local silver = getglobal(moneyFrame:GetName().."Silver"):GetText();
	local gold = getglobal(moneyFrame:GetName().."Gold"):GetText();
	
	if ( copper ~= "" ) then
		totalCopper = totalCopper + copper;
	end
	if ( silver ~= "" ) then
		totalCopper = totalCopper + (silver * COPPER_PER_SILVER);
	end
	if ( gold ~= "" ) then
		totalCopper = totalCopper + (gold * COPPER_PER_GOLD);
	end
	return totalCopper;
end

function MoneyInputFrame_SetCopper(moneyFrame, money)
	local gold = floor(money / (COPPER_PER_GOLD));
	local silver = floor((money - (gold * COPPER_PER_GOLD)) / COPPER_PER_SILVER);
	local copper = mod(money, COPPER_PER_SILVER);
	
	getglobal(moneyFrame:GetName().."Copper"):SetText(copper);
	getglobal(moneyFrame:GetName().."Silver"):SetText(silver);
	getglobal(moneyFrame:GetName().."Gold"):SetText(gold);
end

-- Used to set the frames before the moneyframe when tabbing through
function MoneyInputFrame_SetPreviousFocus(moneyFrame, focus)
	moneyFrame.previousFocus = focus;
end

function MoneyInputFrame_SetNextFocus(moneyFrame, focus)
	moneyFrame.nextFocus = focus;
end

function MoneyInputFrame_SetOnvalueChangedFunc(moneyFrame, func)
	moneyFrame.onvalueChangedFunc = func;
end