
OPTIONS_FARCLIP_MIN = 177;
OPTIONS_FARCLIP_MAX = 777;

OptionsFrameCheckButtons = { };
OptionsFrameCheckButtons["WORLD_LOD"] = { index = 1, cvar = "lod" };
OptionsFrameCheckButtons["OBJECT_ALPHA"] = { index = 2, cvar = "fullalpha" };
OptionsFrameCheckButtons["TRILINEAR_FILTERING"] = { index = 3, cvar = "trilinear" };
OptionsFrameCheckButtons["INVERT_MOUSE"] = { index = 4, cvar = "mouseInvertPitch" };
OptionsFrameCheckButtons["STATUS_BAR_TEXT"] = { index = 5, cvar = "statusBarText" };
OptionsFrameCheckButtons["ASSIST_ATTACK"] = { index = 6, cvar = "assistAttack" };
OptionsFrameCheckButtons["SHOW_UNIT_NAMES"] = { index = 7, cvar = "UnitNameRenderMode" };
OptionsFrameCheckButtons["DESKTOP_GAMMA"] = { index = 8, cvar = "desktopGamma" };
OptionsFrameCheckButtons["PROFANITY_FILTER"] = { index = 9, cvar = "profanityFilter" };
OptionsFrameCheckButtons["CLICK_TO_MOVE"] = { index = 10, cvar = "autointeract" };
OptionsFrameCheckButtons["ADVANCED_CHAT"] = { index = 11, cvar = "AdvancedChat" };

OptionsFrameSliders = {
	{ text = WORLD_DETAIL, func = "WorldDetail", minValue = 0, maxValue = 2, valueStep = 1 },
	{ text = WATER_DETAIL, func = "WaterDetail", minValue = 0, maxValue = 3, valueStep = 1 },
	{ text = FARCLIP, func = "Farclip", minValue = OPTIONS_FARCLIP_MIN, maxValue = OPTIONS_FARCLIP_MAX, valueStep = (OPTIONS_FARCLIP_MAX - OPTIONS_FARCLIP_MIN)/10 },
	{ text = TERRAIN_MIP, func = "TerrainMip", minValue = 0, maxValue = 1, valueStep = 1 },
	{ text = ANIMATION, func = "DoodadAnim", minValue = 0, maxValue = 1, valueStep = 1 },
	{ text = SHARPNESS, func = "TexLodBias", minValue = -1, maxValue = 1, valueStep = 0.1 },
	{ text = GAMMA, func = "Gamma", minValue = -0.5, maxValue = 0.5, valueStep = 0.1 },
};

function OptionsFrame_Init()
	RegisterCVar("AdvancedChat", "0");
	for index, value in OptionsFrameCheckButtons do
		local string = GetCVar(value.cvar);
		value.value = string;
	end
	this:RegisterEvent("CVAR_UPDATE");
end

function OptionsFrame_OnEvent()
	if ( event == "CVAR_UPDATE" ) then
		local info = OptionsFrameCheckButtons[arg1];
		if ( info ) then
			info.value = arg2;
		end
	end
end

function OptionsFrame_Load()
	for index, value in OptionsFrameCheckButtons do
		local button = getglobal("OptionsFrameCheckButton"..value.index);
		local string = getglobal("OptionsFrameCheckButton"..value.index.."Text");
		local checked;
		
		if ( index == "SHOW_UNIT_NAMES" ) then
			if ( GetCVar(value.cvar) == "3" ) then
				checked = 1;
			else
				checked = 0;
			end
		else
			checked = GetCVar(value.cvar);
		end
		
		button:SetChecked(checked);
		string:SetText(TEXT(getglobal(index)));
	end
	for index, value in OptionsFrameSliders do
		local slider = getglobal("OptionsFrameSlider"..index);
		local string = getglobal("OptionsFrameSlider"..index.."Text");
		local getvalue = getglobal("Get"..value.func);
		slider:SetMinMaxValues(value.minValue, value.maxValue);
		slider:SetValueStep(value.valueStep);
		slider:SetValue(getvalue());
		string:SetText(TEXT(value.text));
	end
	OptionsFrame.gamma = GetGamma();
	OptionsFrame.desktopGamma = GetCVar("desktopGamma");
end

function OptionsFrame_Save()
	for index, value in OptionsFrameCheckButtons do
		local button = getglobal("OptionsFrameCheckButton"..value.index);
		if ( index == "SHOW_UNIT_NAMES" ) then
			if ( button:GetChecked() ) then
				value.value = "3";
			else
				value.value = "2";
			end
		else
			if ( button:GetChecked() ) then
				value.value = "1";
			else
				value.value = "0";
			end
		end
		
		SetCVar(value.cvar, value.value, index);
	end
	for index, value in OptionsFrameSliders do
		local slider = getglobal("OptionsFrameSlider"..index);
		local setvalue = getglobal("Set"..value.func);
		setvalue(slider:GetValue());
	end
	OptionsFrame.gamma = GetGamma();
	OptionsFrame.desktopGamma = GetCVar("desktopGamma");
	SetScreenResolution(OptionsFrame.selectedRes);
end

function OptionsFrame_Cancel()
	SetGamma(OptionsFrame.gamma);
	SetCVar("desktopGamma", OptionsFrame.desktopGamma);
end

function OptionsFrameResolutionDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, OptionsFrameResolutionDropDown_Initialize);
	UIDropDownMenu_SetSelectedID(this, GetCurrentResolution());
	OptionsFrame.selectedRes = GetCurrentResolution();
	UIDropDownMenu_SetWidth(90, OptionsFrameResolutionDropDown);
end

function OptionsFrameResolutionDropDown_Initialize()
	OptionsFrameResolutionDropDown_LoadResolutions(GetScreenResolutions());	
end

function OptionsFrameResolutionDropDown_LoadResolutions(...)
	local currentRes = OptionsFrame.selectedRes;
	local info;
	for i=1, arg.n, 1 do
		checked = nil;
		if ( currentRes == i ) then
			checked = 1;
			UIDropDownMenu_SetText(arg[i], OptionsFrameResolutionDropDown);
		end
		info = {};
		info.text = arg[i];
		info.func = OptionsFrameResolutionButton_OnClick;
		info.checked = checked;
		UIDropDownMenu_AddButton(info);
	end
end

function OptionsFrameResolutionButton_OnClick()
	UIDropDownMenu_SetSelectedID(OptionsFrameResolutionDropDown, this:GetID());
	OptionsFrame.selectedRes = this:GetID();
end
