NUM_RESISTANCE_TYPES = 5;
NUM_STATS = 5;
ROTATIONS_PER_SECOND = .5;
NUM_SHOPPING_TOOLTIPS = 2;

function PaperDollFrame_OnLoad()
	CharacterAttackFrameLabel:SetText(TEXT(ATTACK_COLON));
	CharacterDamageFrameLabel:SetText(TEXT(DAMAGE_COLON));
	CharacterAttackPowerFrameLabel:SetText(TEXT(ATTACK_POWER_COLON));
	CharacterDefenseFrameLabel:SetText(TEXT(DEFENSE_COLON));
	CharacterArmorFrameLabel:SetText(TEXT(ARMOR_COLON));
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
	this:RegisterEvent("UNIT_MODEL_CHANGED");
	this:RegisterEvent("UNIT_LEVEL");
	this:RegisterEvent("PLAYER_RESISTANCE");
	this:RegisterEvent("PLAYER_STATS");
	this:RegisterEvent("UNIT_DAMAGE");
	this:RegisterEvent("PLAYER_DAMAGE_DONE_MODS");
	this:RegisterEvent("PLAYER_ATTACK_POWER");
	this:RegisterEvent("UNIT_DEFENSE");
	this:RegisterEvent("UNIT_ATTACK");
	this:RegisterEvent("PLAYER_GUILD_UPDATE");
end

function CharacterModelFrame_OnUpdate(elapsedTime)
	if ( CharacterModelRotateLeftButton:GetButtonState() == "PUSHED" ) then
		this.rotation = this.rotation + (elapsedTime * 2 * PI * ROTATIONS_PER_SECOND);
		if ( this.rotation < 0 ) then
			this.rotation = this.rotation + (2 * PI);
		end
		CharacterModelFrame:SetRotation(this.rotation);
	end
	if ( CharacterModelRotateRightButton:GetButtonState() == "PUSHED" ) then
		this.rotation = this.rotation - (elapsedTime * 2 * PI * ROTATIONS_PER_SECOND);
		if ( this.rotation > (2 * PI) ) then
			this.rotation = this.rotation - (2 * PI);
		end
		CharacterModelFrame:SetRotation(this.rotation);
	end
end

function CharacterModelFrame_OnMouseUp(button)
	if ( button == "LeftButton" ) then
		AutoEquipCursorItem();
	end
end

function CharacterModelFrame_OnLoad()
	this.rotation = 0.61;
	CharacterModelFrame:SetRotation(this.rotation);
end

function CharacterModelRotateLeftButton_OnClick()
	CharacterModelFrame.rotation = CharacterModelFrame.rotation - .03;
	CharacterModelFrame:SetRotation(CharacterModelFrame.rotation);
	PlaySound("igInventoryRotateCharacter");
end

function CharacterModelRotateRightButton_OnClick()
	CharacterModelFrame.rotation = CharacterModelFrame.rotation + .03;
	CharacterModelFrame:SetRotation(CharacterModelFrame.rotation);
	PlaySound("igInventoryRotateCharacter");
end

function PaperDollFrame_OnEvent(event, unit)
	if ( unit and unit == "player" ) then
		if ( event == "UNIT_MODEL_CHANGED" ) then
			CharacterModelFrame:SetUnit("player");
		elseif ( event == "UNIT_LEVEL" ) then
			PaperDollFrame_SetLevel();
		elseif ( event == "UNIT_DAMAGE" or event == "PLAYER_DAMAGE_DONE_MODS") then
			PaperDollFrame_SetDamage();
		elseif ( event == "UNIT_DEFENSE" ) then
			PaperDollFrame_SetDefense();
		elseif ( event == "UNIT_ATTACK" ) then
			PaperDollFrame_SetAttackBothHands();
		end
	end
	if ( event == "PLAYER_GUILD_UPDATE" ) then
		PaperDollFrame_SetGuild();
	end
	if ( event == "PLAYER_RESISTANCE" ) then
		PaperDollFrame_SetResistances();
		PaperDollFrame_SetArmor();
		return;
	end
	if ( event == "PLAYER_STATS" ) then
		PaperDollFrame_SetStats();
		return;
	end
	if ( event == "PLAYER_ATTACK_POWER" ) then
		PaperDollFrame_SetAttackPower();
		return;
	end
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		CharacterModelFrame:SetUnit("player");
		return;
	end
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		PaperDollFrame_SetCharacterPoints();
		return;
	end
end

function PaperDollItemSlotButton_OnLoad()
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	this:RegisterEvent("ITEM_LOCK_CHANGED");
	this:RegisterEvent("CURSOR_UPDATE");
	this:RegisterEvent("BAG_UPDATE_COOLDOWN");
	this:RegisterEvent("SHOW_COMPARE_TOOLTIP");
	this:RegisterForDrag("LeftButton");
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	local slotName = this:GetName();
	local id;
	local textureName;
	id, textureName = GetInventorySlotInfo(strsub(slotName,10));
	this:SetID(id);
	local texture = getglobal(slotName.."IconTexture");
	texture:SetTexture(textureName);
	this.backgroundTextureName = textureName;
	PaperDollItemSlotButton_Update();
end

function PaperDollFrame_SetLevel()
	CharacterLevelText:SetText(format(TEXT(PLAYER_LEVEL),UnitLevel("player"), UnitRace("player"), UnitClass("player")));
end

function PaperDollFrame_SetCharacterPoints()
	local cp1, cp2 = UnitCharacterPoints("player");
	CharacterPointsText1:SetText(cp1);
	CharacterPointsText2:SetText(cp2);
end

function PaperDollFrame_SetGuild()
	local guildName;
	local rank;
	guildName, title, rank = GetGuildInfo("player");
	if ( guildName ) then
		CharacterGuildText:Show();
		--CharacterGuildText:SetText(format(TEXT(GUILD_TITLE_TEMPLATE), getglobal("GUILD_RANK"..rank.."_DESC"), guildName));
		CharacterGuildText:SetText(format(TEXT(GUILD_TITLE_TEMPLATE), title, guildName));
	else
		CharacterGuildText:Hide();
	end
	
end

function PaperDollFrame_SetResistances()
	for i=1, NUM_RESISTANCE_TYPES, 1 do
		local resistance;
		local effectiveResistance;
		local positive;
		local negative;
		local base;
		local text = getglobal("MagicResText"..i);
		local frame = getglobal("MagicResFrame"..i);
		
		base, effectiveResistance, resistance, positive, negative = GetResistance(i);

		frame.tooltip = TEXT(getglobal("RESISTANCE"..i.."_NAME"));
		if ( positive == 0 and negative == 0 ) then
			-- No modifiers
			text:SetText(effectiveResistance..FONT_COLOR_CODE_CLOSE);
		else
			-- Otherwise build up the formula
			frame.tooltip = frame.tooltip.. " ( "..HIGHLIGHT_FONT_COLOR_CODE..base;
			if( positive > 0 ) then
				frame.tooltip = frame.tooltip..GREEN_FONT_COLOR_CODE.." +"..positive;
			end
			if( negative < 0 ) then
				frame.tooltip = frame.tooltip.." "..RED_FONT_COLOR_CODE..negative;
			end
			frame.tooltip = frame.tooltip..FONT_COLOR_CODE_CLOSE.." )";
			if( negative < 0 ) then
				text:SetText(RED_FONT_COLOR_CODE..effectiveResistance..FONT_COLOR_CODE_CLOSE);
			elseif( positive > 0 ) then
				text:SetText(GREEN_FONT_COLOR_CODE..effectiveResistance..FONT_COLOR_CODE_CLOSE);
			end
		end
	end
end

function PaperDollFrame_SetStats()
	for i=1, NUM_STATS, 1 do
		local label = getglobal("CharacterStatFrame"..i.."Label");
		local text = getglobal("CharacterStatFrame"..i.."StatText");
		local frame = getglobal("CharacterStatFrame"..i);
		local stat;
		local effectiveStat;
		local posBuff;
		local negBuff;
		label:SetText(TEXT(getglobal("SPELL_STAT"..(i-1).."_NAME"))..":");
		stat, effectiveStat, posBuff, negBuff = GetStat(i);
		if ( ( posBuff == 0 ) and ( negBuff == 0 ) ) then
			text:SetText(effectiveStat);
			frame.tooltip = nil;
		else 
			local tooltipText = stat - posBuff - negBuff;
			if ( posBuff > 0 ) then
				tooltipText = tooltipText..GREEN_FONT_COLOR_CODE.." +"..posBuff..FONT_COLOR_CODE_CLOSE;
			end
			if ( negBuff < 0 ) then
				tooltipText = tooltipText..RED_FONT_COLOR_CODE.." "..negBuff..FONT_COLOR_CODE_CLOSE;
			end
			frame.tooltip = tooltipText;

			-- If there are any negative buffs then show the main number in red even if there are
			-- positive buffs. Otherwise show in green.
			if ( negBuff < 0 ) then
				text:SetText(RED_FONT_COLOR_CODE..effectiveStat..FONT_COLOR_CODE_CLOSE);
			else
				text:SetText(GREEN_FONT_COLOR_CODE..effectiveStat..FONT_COLOR_CODE_CLOSE);
			end
		end
	end
end

function PaperDollFrame_SetAttackBothHands()
	-- FIXME: The offhand stats aren't displayed yet.
	local mainHandAttackBase, mainHandAttackMod,
	      offHandAttackBase, offHandAttackMod = UnitAttackBothHands("player");

	local frame = CharacterAttackFrame; 
	local text = CharacterAttackFrameStatText;

	if( mainHandAttackMod == 0 ) then
		text:SetText(mainHandAttackBase);
		frame.tooltip = nil;
	else
		local color = RED_FONT_COLOR_CODE;
		if( mainHandAttackMod > 0 ) then
			color = GREEN_FONT_COLOR_CODE;
			frame.tooltip = mainHandAttackBase..color.." +"..mainHandAttackMod..FONT_COLOR_CODE_CLOSE;
		else
			frame.tooltip = mainHandAttackBase..color.." "..mainHandAttackMod..FONT_COLOR_CODE_CLOSE;
		end
		text:SetText(color..(mainHandAttackBase + mainHandAttackMod)..FONT_COLOR_CODE_CLOSE);
	end
end

function PaperDollFrame_SetDamage()
	local minDamage;
	local maxDamage;
	local physicalBonusPos;
	local physicalBonusNeg;
	local percent;
	minDamage, maxDamage, physicalBonusPos, physicalBonusNeg, percent = GetDamage();
	local rightSpeed, leftSpeed;
	rightSpeed, leftSpeed = UnitAttackSpeed("player");

	
	-- main text
	local damage = ( ( minDamage + maxDamage ) * 0.5 ) + physicalBonusPos + physicalBonusNeg;
	local dps = format("%.2f",( damage * percent ) / rightSpeed);
	if( ( physicalBonusNeg < 0 ) or ( percent < 1 ) ) then
		CharacterDamageFrameStatText:SetText(RED_FONT_COLOR_CODE..dps..FONT_COLOR_CODE_CLOSE);
	elseif( ( physicalBonusPos > 0 ) ) then
		CharacterDamageFrameStatText:SetText(GREEN_FONT_COLOR_CODE..dps..FONT_COLOR_CODE_CLOSE);
	else
		CharacterDamageFrameStatText:SetText(dps);
	end

	-- figure out tooltip text
	if( ( physicalBonusPos == 0 ) and ( physicalBonusNeg == 0 ) and (percent == 1 ) ) then
		CharacterDamageFrame.tooltip = nil;
	else
		local grossDamage = damage * percent;
		if( grossDamage > damage ) then
			physicalBonusPos = physicalBonusPos + ( grossDamage - damage );
		elseif ( damage > grossDamage ) then
			physicalBonusNeg = physicalBonusNeg + ( grossDamage - damage );
		end

		local tooltipText = format("%.2f",( ( minDamage + maxDamage ) * 0.5 ) / rightSpeed);
		if( physicalBonusPos > 0 ) then
			physicalBonusPos = physicalBonusPos / rightSpeed;
			tooltipText = tooltipText..GREEN_FONT_COLOR_CODE.." +"..format("%.2f",physicalBonusPos)..FONT_COLOR_CODE_CLOSE;
		end
		if( physicalBonusNeg < 0 ) then
			physicalBonusNeg = physicalBonusNeg / rightSpeed;
			tooltipText = tooltipText..RED_FONT_COLOR_CODE.." "..format("%.2f",physicalBonusNeg)..FONT_COLOR_CODE_CLOSE;
		end
		CharacterDamageFrame.tooltip = tooltipText;
	end

end

function PaperDollFrame_SetAttackPower()
	local base, posBuff, negBuff = GetAttackPower();

	local frame = CharacterAttackPowerFrame; 
	local text = CharacterAttackPowerFrameStatText;

	if( ( posBuff == 0 ) and ( negBuff == 0 ) ) then
		text:SetText(base);
		frame.tooltip = nil;
	else
		local tooltipText = base;
		if ( posBuff > 0 ) then
			tooltipText = tooltipText..GREEN_FONT_COLOR_CODE.." +"..posBuff..FONT_COLOR_CODE_CLOSE;
		end
		if ( negBuff < 0 ) then
			tooltipText = tooltipText..RED_FONT_COLOR_CODE.." "..negBuff..FONT_COLOR_CODE_CLOSE;
		end
		frame.tooltip = tooltipText;
	
		-- if there is a negative buff then show the main number in red, even if there are
		-- positive buffs. Otherwise show the number in green
		local effective = max(0,base+posBuff+negBuff);
		if ( negBuff < 0 ) then
			text:SetText(RED_FONT_COLOR_CODE..effective..FONT_COLOR_CODE_CLOSE);
		else
			text:SetText(GREEN_FONT_COLOR_CODE..effective..FONT_COLOR_CODE_CLOSE);
		end
	end
end

function PaperDollFrame_SetAttackSpeed()
	local leftSpeed;
	local rightSpeed;
	rightSpeed, leftSpeed = UnitAttackSpeed("player");
	CharacterAttackSpeedFrameStatText:SetText(format("%.1f", rightSpeed));
	--if ( leftSpeed ) then
	--	CharacterAttackSpeedFrameStatText:SetText(format("%.2f, %.2f", rightSpeed, leftSpeed));
	--else
	--	CharacterAttackSpeedFrameStatText:SetText(format("%.2f", rightSpeed));
	--end
end

function PaperDollFrame_SetDefense()
	local base;
	local modifier;
	base, modifier = UnitDefense("player");

	local frame = CharacterDefenseFrame; 
	local text = CharacterDefenseFrameStatText;

	if( modifier == 0 ) then
		text:SetText(base);
		frame.tooltip = nil;
	else
		local color = RED_FONT_COLOR_CODE;
		if( modifier > 0 ) then
			color = GREEN_FONT_COLOR_CODE;
			frame.tooltip = base..color.." +"..modifier..FONT_COLOR_CODE_CLOSE;
		else
			frame.tooltip = base..color.." "..modifier..FONT_COLOR_CODE_CLOSE;
		end
		text:SetText(color..(base + modifier)..FONT_COLOR_CODE_CLOSE);
	end
end

function PaperDollFrame_SetArmor()
	local armor;
	local effectiveArmor;
	local positive;
	local negative;
	local base;
	base, effectiveArmor, armor, positive, negative = GetArmor();
	local totalBufs = positive + negative;
	if ( totalBufs == 0 ) then
		if( negative < 0 ) then
			CharacterArmorFrameStatText:SetText(RED_FONT_COLOR_CODE..effectiveArmor..FONT_COLOR_CODE_CLOSE);
		else
			CharacterArmorFrameStatText:SetText(effectiveArmor);
		end
		CharacterArmorFrame.tooltip = nil;
	else
		local tooltip = HIGHLIGHT_FONT_COLOR_CODE..base;
		if( positive > 0 ) then
			tooltip = tooltip..GREEN_FONT_COLOR_CODE.." +"..positive;
		end
		if( negative < 0 ) then
			tooltip = tooltip.." "..RED_FONT_COLOR_CODE..negative;
		end
		tooltip = tooltip..FONT_COLOR_CODE_CLOSE;
		CharacterArmorFrame.tooltip = tooltip;
		if( negative < 0 ) then
			CharacterArmorFrameStatText:SetText(RED_FONT_COLOR_CODE..effectiveArmor..FONT_COLOR_CODE_CLOSE);
		elseif( positive > 0 ) then
			CharacterArmorFrameStatText:SetText(GREEN_FONT_COLOR_CODE..effectiveArmor..FONT_COLOR_CODE_CLOSE);
		else
			CharacterArmorFrameStatText:SetText(effectiveArmor..FONT_COLOR_CODE_CLOSE);
		end
	end
end

function PaperDollFrame_OnShow()
	PaperDollFrame_SetGuild();
	PaperDollFrame_SetLevel();
	PaperDollFrame_SetCharacterPoints();
	PaperDollFrame_SetResistances();
	PaperDollFrame_SetStats();
	PaperDollFrame_SetDamage();
	PaperDollFrame_SetAttackPower();
	PaperDollFrame_SetDefense();
	PaperDollFrame_SetArmor();
	PaperDollFrame_SetAttackBothHands();
	--if ( SkillFrame ) then
	--	SkillFrame:Hide();
	--end
	--CharacterFrameCharacterTabButton:Disable();
end
 
function PaperDollFrame_OnHide()
	--CharacterFrameCharacterTabButton:Enable();
	for i=1, NUM_SHOPPING_TOOLTIPS, 1 do
		getglobal("ShoppingTooltip"..i):Hide();
	end
end

function PaperDollItemSlotButton_OnEvent(event)
	if ( event == "UNIT_INVENTORY_CHANGED" ) then
		if ( arg1 == "player" ) then
			PaperDollItemSlotButton_Update();
		end
		return;
	end
	if ( event == "ITEM_LOCK_CHANGED" ) then
		PaperDollItemSlotButton_UpdateLock();
		return;
	end
	if ( event == "BAG_UPDATE_COOLDOWN" ) then
		PaperDollItemSlotButton_Update(1);
		return;
	end
	if ( event == "CURSOR_UPDATE" ) then
		if ( CursorCanGoInSlot(this:GetID()) ) then
			this:LockHighlight();
		else
			this:UnlockHighlight();
		end
		return;
	end
	if ( event == "BAG_UPDATE" ) then
		PaperDollItemSlotButton_Update();
		return;
	end
	if ( event == "SHOW_COMPARE_TOOLTIP" ) then
		if ( (arg1 ~= this:GetID()) or not this:IsVisible() or (arg2 > NUM_SHOPPING_TOOLTIPS) ) then
			return;
		end

		local tooltip = getglobal("ShoppingTooltip"..arg2);
		local anchor = "ANCHOR_RIGHT";
		if ( arg2 > 1 ) then
			anchor = "ANCHOR_BOTTOMRIGHT";
		end
		tooltip:SetOwner(this, anchor);
		local hasItem, hasCooldown = tooltip:SetInventoryItem("player", this:GetID());
		if ( not hasItem ) then
			tooltip:Hide();
		elseif ( hasCooldown ) then
			this.updateTooltip = TOOLTIP_UPDATE_TIME;
		else
			this.updateTooltip = nil;
		end
		return;
	end
end

function PaperDollItemSlotButton_OnClick(button, ignoreShift)
	if ( button == "LeftButton" ) then
		if ( IsShiftKeyDown() and not ignoreShift ) then
			if ( ChatFrameEditBox:IsVisible() ) then
				ChatFrameEditBox:Insert(GetInventoryItemLink("player", this:GetID()));
			end
		else
			PickupInventoryItem(this:GetID());
		end
	elseif ( button == "RightButton" ) then
		UseInventoryItem(this:GetID());
	end
end

function PaperDollItemSlotButton_Update(cooldownOnly)
	local textureName = GetInventoryItemTexture("player", this:GetID());
	local cooldown = getglobal(this:GetName().."Cooldown");
	if ( textureName ) then
		SetItemButtonTexture(this, textureName);
		SetItemButtonCount(this, GetInventoryItemCount("player", this:GetID()));
	else
		SetItemButtonTexture(this, this.backgroundTextureName);
		SetItemButtonCount(this, 0);
		cooldown:Hide();
	end

	local start, duration, enable = GetInventoryItemCooldown("player", this:GetID());
	CooldownFrame_SetTimer(cooldown, start, duration, enable);

	--local quality = GetInventoryItemQuality("player", this:GetID());
	--if ( quality and quality ~= -1 ) then
	--	local color = getglobal("ITEM_QUALITY".. quality .."_COLOR");
	--	SetItemButtonNormalTextureVertexColor(this, color.r, color.g, color.b);
	--else
	--	SetItemButtonNormalTextureVertexColor(this, 1.0, 1.0, 1.0);
	--end
	if ( GameTooltip:IsOwned(this) ) then
		if ( textureName or cooldownOnly ) then
			if ( this.isBag ) then
				BagSlotButton_OnEnter();
			else
				PaperDollItemSlotButton_OnEnter();
			end
		else
			this.updateTooltip = nil;
			GameTooltip:Hide();
			ResetCursor();
		end
	end
	PaperDollItemSlotButton_UpdateLock();
end

function PaperDollItemSlotButton_UpdateLock()
	if ( IsInventoryItemLocked(this:GetID()) ) then
		this:SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
	else 
		this:SetNormalTexture("Interface\\Buttons\\UI-Quickslot2");
	end
end

function PaperDollItemSlotButton_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	local hasItem, hasCooldown = GameTooltip:SetInventoryItem("player", this:GetID());
    if ( not hasItem ) then
		GameTooltip:SetText(TEXT(getglobal(strupper(strsub(this:GetName(), 10)))));
	end
	if ( hasCooldown ) then
		this.updateTooltip = TOOLTIP_UPDATE_TIME;
	else
		this.updateTooltip = nil;
	end
	if ( MerchantFrame:IsVisible() ) then
		ShowInventorySellCursor(this:GetID());
	end
end

function PaperDollItemSlotButton_OnUpdate(elapsed)
	if ( not this.updateTooltip ) then
		return;
	end

	this.updateTooltip = this.updateTooltip - elapsed;
	if ( this.updateTooltip > 0 ) then
		return;
	end

	if ( GameTooltip:IsOwned(this) ) then
		if ( this.isBag ) then
			BagSlotButton_OnEnter();
		else
			PaperDollItemSlotButton_OnEnter();
		end
	else
		this.updateTooltip = nil;
	end
end