MAX_SPELLS = 1024;
SPELLS_PER_PAGE = 14;
MAX_SPELL_PAGES = ceil(MAX_SPELLS / SPELLS_PER_PAGE);
BOOKTYPE_SPELL = "spell";
BOOKTYPE_ABILITY = "ability";
BOOKTYPE_PET = "pet";
SPELLBOOK_PAGENUMBERS = {
	ability = 1,
	spell = 1,
	pet = 1
};

function ToggleSpellBook(bookType)
	local doToggle = 1;
	-- If has no spells or pet spells and is trying to open the corresponding book, then do nothing
	if ( not PlayerHasSpells() and bookType == BOOKTYPE_SPELL ) then
		doToggle = nil;
	elseif ( not HasPetSpells() and bookType == BOOKTYPE_PET ) then
		doToggle = nil;
	end
	if ( doToggle ) then
		local isVisible = SpellBookFrame:IsVisible();
		HideUIPanel(SpellBookFrame);
		if ( (not isVisible or (SpellBookFrame.bookType ~= bookType)) ) then
			SpellBookFrame.bookType = bookType;
			ShowUIPanel(SpellBookFrame);
		end
		if ( SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] == 1 ) then
			SpellBookPrevPageButton:Disable();
		else
			SpellBookPrevPageButton:Enable();
		end
		if ( SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] == MAX_SPELL_PAGES ) then
			SpellBookNextPageButton:Disable();
		else
			SpellBookNextPageButton:Enable();
		end
		SpellBookPageText:SetText(format(TEXT(PAGE_NUMBER), SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType]));
	end
end

function SpellBookFrame_OnLoad()
	this:RegisterEvent("SPELLS_CHANGED");
	this.bookType = BOOKTYPE_ABILITY;
end

function SpellBookFrame_OnEvent()
	if ( event == "SPELLS_CHANGED" and SpellBookFrame:IsVisible() ) then
		SpellBookFrame_Update();
	end
end

function SpellBookFrame_OnShow()
	UpdateMicroButtons();
	SpellBookFrame_Update();
end

function SpellBookFrame_Update()
	-- Hide all tabs
	SpellBookFrameTabButton1:Hide();
	SpellBookFrameTabButton2:Hide();
	SpellBookFrameTabButton3:Hide();
	-- Setup tabs
	local numSpellBookTabs;
	if ( PlayerHasSpells() ) then
		numSpellBookTabs = 2;
		SpellBookFrame_SetTabType(SpellBookFrameTabButton1, BOOKTYPE_ABILITY);
		SpellBookFrame_SetTabType(SpellBookFrameTabButton2, BOOKTYPE_SPELL);
	end

	local hasPetSpells, petToken = HasPetSpells();
	SpellBookFrame.petTitle = nil;
	if ( hasPetSpells ) then
		if ( numSpellBookTabs ) then
			numSpellBookTabs = numSpellBookTabs + 1;
			SpellBookFrame_SetTabType(SpellBookFrameTabButton3, BOOKTYPE_PET, petToken);
		else
			numSpellBookTabs = 2;
			SpellBookFrame_SetTabType(SpellBookFrameTabButton1, BOOKTYPE_ABILITY);
			SpellBookFrame_SetTabType(SpellBookFrameTabButton2, BOOKTYPE_PET, petToken);
		end

	elseif ( SpellBookFrame.bookType == BOOKTYPE_PET ) then
		-- if has no pet spells but trying to show the pet spellbook close the window;
		HideUIPanel(SpellBookFrame);
		SpellBookFrame.bookType = BOOKTYPE_ABILITY;
	end
	if ( SpellBookFrame.bookType == BOOKTYPE_SPELL ) then
		SpellBookTitleText:SetText(TEXT(SPELLBOOK));
		PlaySound("igSpellBookOpen");
	elseif ( SpellBookFrame.bookType == BOOKTYPE_ABILITY ) then
		SpellBookTitleText:SetText(TEXT(ABILITIES));
		PlaySound("igAbilityOpen");
	else
		SpellBookTitleText:SetText(SpellBookFrame.petTitle);
		-- Need to change to pet book open sound
		PlaySound("igAbilityOpen");
	end
end

function SpellBookFrame_SetTabType(tabButton, bookType, token)
	if ( bookType == BOOKTYPE_SPELL ) then
		tabButton.bookType = BOOKTYPE_SPELL;
		tabButton:SetText(TEXT(SPELLBOOK));
		tabButton.binding = "TOGGLESPELLBOOK";
	elseif ( bookType == BOOKTYPE_ABILITY ) then
		tabButton.bookType = BOOKTYPE_ABILITY;
		tabButton:SetText(TEXT(ABILITIES));
		tabButton.binding = "TOGGLEABILITYBOOK";
	else
		tabButton.bookType = BOOKTYPE_PET;
		tabButton:SetText(TEXT(getglobal("PET_TYPE_"..token)));
		tabButton.binding = "TOGGLEPETBOOK";
		SpellBookFrame.petTitle = TEXT(getglobal("PET_TYPE_"..token));
	end
	if ( SpellBookFrame.bookType == bookType ) then
		tabButton:Disable();
	else
		tabButton:Enable();
	end
	tabButton:Show();
end


function SpellBookFrame_OnHide()
	if ( this.bookType == BOOKTYPE_SPELL ) then
		PlaySound("igSpellBookClose");
	elseif ( this.bookType == BOOKTYPE_ABILITY ) then
		PlaySound("igAbilityClose");
	else
		-- Need to change to pet book close sound
		PlaySound("igAbilityClose");
	end
	UpdateMicroButtons();
end

function SpellButton_OnLoad() 
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("CURRENT_SPELL_CAST_CHANGED");
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	this:RegisterEvent("CRAFT_SHOW");
	this:RegisterEvent("CRAFT_CLOSE");
	this:RegisterEvent("TRADE_SKILL_SHOW");
	this:RegisterEvent("TRADE_SKILL_CLOSE");
	this:RegisterForDrag("LeftButton");
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	SpellButton_UpdateButton();
end

function SpellButton_OnEvent(event) 
	if ( event == "SPELLS_CHANGED" or event == "SPELL_UPDATE_COOLDOWN" ) then 
		SpellButton_UpdateButton();
	elseif ( event == "CURRENT_SPELL_CAST_CHANGED" ) then
		SpellButton_UpdateSelection();
	elseif ( event == "CRAFT_SHOW" or event == "CRAFT_CLOSE" or event == "TRADE_SKILL_SHOW" or event == "TRADE_SKILL_CLOSE" ) then
		SpellButton_UpdateSelection();
		return;
	end

end

function SpellButton_OnEnter()
	local id = this:GetID() + (SPELLS_PER_PAGE * (SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] - 1));
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	if ( GameTooltip:SetSpell(id, SpellBookFrame.bookType) ) then
		this.updateTooltip = TOOLTIP_UPDATE_TIME;
	else
		this.updateTooltip = nil;
	end
end

function SpellButton_OnUpdate(elapsed)
	if ( not this.updateTooltip ) then
		return;
	end

	this.updateTooltip = this.updateTooltip - elapsed;
	if ( this.updateTooltip > 0 ) then
		return;
	end

	if ( GameTooltip:IsOwned(this) ) then
		SpellButton_OnEnter();
	else
		this.updateTooltip = nil;
	end
end

function SpellButton_OnClick(drag) 
	local id = this:GetID() + (SPELLS_PER_PAGE * (SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] - 1));
	if ( id > MAX_SPELLS ) then
		return;
	end
	this:SetChecked("false");
	if ( drag ) then
		PickupSpell(id, SpellBookFrame.bookType );
	elseif ( IsShiftKeyDown() ) then
		if ( MacroFrame:IsVisible() ) then
			local spellName, subSpellName = GetSpellName(id, SpellBookFrame.bookType);
			if ( spellName and not IsSpellPassive(id, SpellBookFrame.bookType) ) then
				if ( subSpellName and (strlen(subSpellName) > 0) ) then
					MacroFrame_AddMacroLine(TEXT(SLASH_CAST1).." "..spellName.." ("..subSpellName..")");
				else
					MacroFrame_AddMacroLine(TEXT(SLASH_CAST1).." "..spellName);
				end
			end
		else
			PickupSpell(id, SpellBookFrame.bookType );
		end
	else
		CastSpell(id, SpellBookFrame.bookType);
	end
end

function SpellButton_UpdateSelection()
	local id = this:GetID() + (SPELLS_PER_PAGE * (SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] - 1));
	if ( IsCurrentCast(id,  SpellBookFrame.bookType) ) then
		this:SetChecked("true");
	else
		this:SetChecked("false");
	end
end

function SpellButton_UpdateButton()
	if ( not this:IsVisible() ) then
		return;
	end
	if ( GameTooltip:IsOwned(this) ) then
		SpellButton_OnEnter();
	end

	local id = this:GetID() + (SPELLS_PER_PAGE * (SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] - 1));
	local name = this:GetName();
	local texture;
	local iconTexture = getglobal(name.."IconTexture");
	local spellString = getglobal(name.."SpellName");
	local subSpellString = getglobal(name.."SubSpellName");
	local cooldown = getglobal(name.."Cooldown");
	if ( id > MAX_SPELLS ) then
		this:Disable();
		iconTexture:Hide();
		spellString:Hide();
		subSpellString:Hide();
		cooldown:Hide();
		return;
	else
		this:Enable();
	end
	texture = GetSpellTexture(id, SpellBookFrame.bookType);
	local highlightTexture = getglobal(name.."Highlight");
	local normalTexture = getglobal(name.."NormalTexture");
	-- If no spell, hide everything and return
	if ( not texture or (strlen(texture) == 0) ) then
		iconTexture:Hide();
		spellString:Hide();
		subSpellString:Hide();
		cooldown:Hide();
		highlightTexture:SetTexture("Interface\\Buttons\\ButtonHilight-Square");
		this:SetChecked(0);
		normalTexture:SetVertexColor(1.0, 1.0, 1.0);
		return;
	end
	
	local start, duration, enable = GetSpellCooldown(id, SpellBookFrame.bookType);
	CooldownFrame_SetTimer(cooldown, start, duration, enable);
	if ( enable == 1 ) then
		iconTexture:SetVertexColor(1.0, 1.0, 1.0);
	else
		iconTexture:SetVertexColor(0.4, 0.4, 0.4);
	end
	
	local spellName, subSpellName = GetSpellName(id, SpellBookFrame.bookType);
	local isPassive = IsSpellPassive(id, SpellBookFrame.bookType);
	if ( isPassive ) then
		normalTexture:SetVertexColor(0, 0, 0);
		highlightTexture:SetTexture("Interface\\Buttons\\UI-PassiveHighlight");
		--subSpellName = TEXT(PASSIVE_PARENS);
		spellString:SetTextColor(0.77, 0.64, 0);
	else
		normalTexture:SetVertexColor(1.0, 1.0, 1.0);
		highlightTexture:SetTexture("Interface\\Buttons\\ButtonHilight-Square");
		spellString:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
	end
	iconTexture:SetTexture(texture);
	spellString:SetText(spellName);
	subSpellString:SetText(subSpellName);
	if ( subSpellName ~= "" ) then
		spellString:SetPoint("LEFT", this:GetName(), "RIGHT", 4, 7);
	else
		spellString:SetPoint("LEFT", this:GetName(), "RIGHT", 4, 2);
	end

	iconTexture:Show();
	spellString:Show();
	subSpellString:Show();
	SpellButton_UpdateSelection();
end

function PrevPageButton_OnClick()
	local pageNum = SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] - 1;
	SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] = pageNum;
	if ( pageNum == 1 ) then
		this:Disable();
	end
	SpellBookNextPageButton:Enable();
	SpellBookPageText:SetText(format(TEXT(PAGE_NUMBER), pageNum));
	UpdateSpells();
	if ( SpellBookFrame.bookType == BOOKTYPE_SPELL ) then
		PlaySound("SPELLBOOKCHANGEPAGE");
	elseif ( SpellBookFrame.bookType == BOOKTYPE_ABILITY ) then
		SpellBookTitleText:SetText(TEXT(ABILITIES));
		PlaySound("igAbiliityPageTurn");
	else
		SpellBookTitleText:SetText(SpellBookFrame.petTitle);
		-- Need to change to pet book pageturn sound
		PlaySound("igAbiliityPageTurn");
	end
end

function NextPageButton_OnClick()
	local pageNum = SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] + 1;
	SPELLBOOK_PAGENUMBERS[SpellBookFrame.bookType] = pageNum;
	if ( pageNum == MAX_SPELL_PAGES ) then
		this:Disable();
	end 
	SpellBookPrevPageButton:Enable();
	SpellBookPageText:SetText(format(TEXT(PAGE_NUMBER), pageNum));
	UpdateSpells();
	if ( SpellBookFrame.bookType == BOOKTYPE_SPELL ) then
		PlaySound("SPELLBOOKCHANGEPAGE");
	elseif ( SpellBookFrame.bookType == BOOKTYPE_ABILITY ) then
		SpellBookTitleText:SetText(TEXT(ABILITIES));
		PlaySound("igAbiliityPageTurn");
	else
		SpellBookTitleText:SetText(SpellBookFrame.petTitle);
		-- Need to change to pet book pageturn sound
		PlaySound("igAbiliityPageTurn");
	end
end

