MAX_TALENT_TABS = 5;
MAX_NUM_TALENTS = 20;
MAX_NUM_TALENT_TIERS = 8;
NUM_TALENT_COLUMNS = 4;
TALENT_BRANCH_ARRAY = {};
TALENT_BUTTON_SIZE = 32;
MAX_NUM_BRANCH_TEXTURES = 30;
MAX_NUM_ARROW_TEXTURES = 30;

TALENT_BRANCH_TEXTURECOORDS = {
	up = {0.125, 0.25, 0 , 1.0},
	down = {0, 0.125, 0, 1.0},
	left = {0.25, 0.375, 0, 1.0},
	right = {0.25, 0.375, 0, 1.0},
	topright = {0.5, 0.625, 0, 1.0},
	topleft = {0.625, 0.5, 0, 1.0},
	bottomright = {0.375, 0.5, 0, 1.0},
	bottomleft = {0.5, 0.375, 0, 1.0},
	tdown = {0.625, 0.75, 0, 1.0},
	tup = {0.75, 0.825, 0, 1.0},
};

TALENT_ARROW_TEXTURECOORDS = {
	top = {0, 0.5, 0, 1.0},
	right = {1.0, 0.5, 0, 1.0},
	left = {0.5, 1.0, 0, 1.0},
};

function TalentFrame_OnLoad()
	PanelTemplates_SetNumTabs(TalentFrame, 3);
	PanelTemplates_SetTab(TalentFrame, 1);
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
	for i=1, MAX_NUM_TALENT_TIERS do
		TALENT_BRANCH_ARRAY[i] = {};
		for j=1, NUM_TALENT_COLUMNS do
			TALENT_BRANCH_ARRAY[i][j] = {id=nil, up=0, left=0, right=0, down=0, leftArrow=0, rightArrow=0, topArrow=0};
		end
	end

end

function TalentFrame_OnShow()
	TalentFrame_Update();
end

function TalentFrame_OnHide()
	TALENTS_TO_LEARN = {};
	UpdateMicroButtons();
end

function TalentFrame_OnEvent()
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		TalentFrame_Update();
	end
end

function TalentFrameTalent_OnEvent()
	if ( GameTooltip:IsOwned(this) ) then
		GameTooltip:SetTalent(PanelTemplates_GetSelectedTab(TalentFrame), this:GetID());
	end
end

function TalentFrame_Update()
	-- Setup Tabs
	local tab, name, iconTexture, pointsSpent, button;
	local numTabs = GetNumTalentTabs();
	for i=1, MAX_TALENT_TABS do
		tab = getglobal("TalentFrameTab"..i);
		if ( i <= numTabs ) then
			name, iconTexture, pointsSpent = GetTalentTabInfo(i);
			if ( i == PanelTemplates_GetSelectedTab(TalentFrame) ) then
				-- If tab is the selected tab set the points spent info
				TalentFrameSpentPoints:SetText("Points in "..name.." Mastery: "..HIGHLIGHT_FONT_COLOR_CODE..pointsSpent..FONT_COLOR_CODE_CLOSE);
				TalentFrame.pointsSpent = pointsSpent;
			end
			tab:SetText(name);
			PanelTemplates_TabResize(10, tab);
			tab:Show();
		else
			tab:Hide();
		end
	end
	PanelTemplates_SetNumTabs(TalentFrame, numTabs);
	PanelTemplates_UpdateTabs(TalentFrame);

	-- Setup Frame
	SetPortraitTexture(TalentFramePortrait, "player");
	TalentFrame_UpdateTalentPoints();
	local talentTabName = GetTalentTabInfo(PanelTemplates_GetSelectedTab(TalentFrame));
	local base;
	local name, texture, points, fileName = GetTalentTabInfo(PanelTemplates_GetSelectedTab(TalentFrame));
	if ( talentTabName ) then
		base = "Interface\\TalentFrame\\"..fileName.."-";
	else
		-- temporary default for classes without talents poor guys
		base = "Interface\\TalentFrame\\MageFire-";
	end
	
	TalentFrameBackgroundTopLeft:SetTexture(base.."TopLeft");
	TalentFrameBackgroundTopRight:SetTexture(base.."TopRight");
	TalentFrameBackgroundBottomLeft:SetTexture(base.."BottomLeft");
	TalentFrameBackgroundBottomRight:SetTexture(base.."BottomRight");
	
	local numTalents = GetNumTalents(PanelTemplates_GetSelectedTab(TalentFrame));
	-- Just a reminder error if there are more talents than available buttons
	if ( numTalents > MAX_NUM_TALENTS ) then
		_ERRORMESSAGE("Too many talents in talent frame!");
	end

	TalentFrame_ResetBranches();
	local tier, column, rank, maxRank, isExceptional, isLearnable;
	for i=1, MAX_NUM_TALENTS do
		button = getglobal("TalentFrameTalent"..i);
		if ( i <= numTalents ) then
			-- Set the button info
			name, iconTexture, tier, column, rank, maxRank, isExceptional = GetTalentInfo(PanelTemplates_GetSelectedTab(TalentFrame), i);
			SetItemButtonTexture(button, iconTexture);
			getglobal("TalentFrameTalent"..i.."Rank"):SetText(rank);
			SetTalentButtonLocation(button, tier, column);
			TALENT_BRANCH_ARRAY[tier][column].id = button:GetID();
			button:Show();
		else	
			button:Hide();
		end
	end
	

	-- Set the prereq info
	local showUnlearned;
	for i=1, numTalents do
		button = getglobal("TalentFrameTalent"..i);
		name, iconTexture, tier, column, rank, maxRank, isExceptional = GetTalentInfo(PanelTemplates_GetSelectedTab(TalentFrame), i);
		-- If player has no talent points then gray out all talents with no rank
		if ( TalentFrame.talentPoints <= 0 and rank == 0 ) then
			showUnlearned = nil;
		else
			showUnlearned = 1;
		end

		-- Talent must meet prereqs, the player must have spent at least 5 talent points in the previous tier and the player must have points to spend
		if ( TalentFrame_SetPrereqs(tier, column, GetTalentPrereqs(PanelTemplates_GetSelectedTab(TalentFrame), i)) and ( (tier - 1) * 5 <= TalentFrame.pointsSpent ) and showUnlearned ) then
			SetItemButtonTextureVertexColor(button, 1.0, 1.0, 1.0);
			getglobal("TalentFrameTalent"..i.."Slot"):SetVertexColor(1.0, 1.0, 1.0);
			if ( rank < maxRank ) then
				-- Rank is green if not maxed out
				getglobal("TalentFrameTalent"..i.."Rank"):SetTextColor(GREEN_FONT_COLOR.r, GREEN_FONT_COLOR.g, GREEN_FONT_COLOR.b);
			else
				getglobal("TalentFrameTalent"..i.."Rank"):SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
			end
			
		else
			SetItemButtonTextureVertexColor(button, 0.6, 0.6, 0.6);
			getglobal("TalentFrameTalent"..i.."Slot"):SetVertexColor(0.5, 0.5, 0.5);
			getglobal("TalentFrameTalent"..i.."Rank"):SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
		end
	end

	-- Draw the prerq branches
	local node;
	local textureIndex = 1;
	local xOffset, yOffset;
	local texCoords;
	TalentFrame_ResetBranchTextureCount();
	TalentFrame_ResetArrowTextureCount();
	for i=1, MAX_NUM_TALENT_TIERS do
		for j=1, NUM_TALENT_COLUMNS do
			node = TALENT_BRANCH_ARRAY[i][j];
			
			xOffset = ((j - 1) * 63) + 33;
			yOffset = -((i - 1) * 63) - 5 ;
			if ( node.id ) then
				-- Has talent
				if ( node.up > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["up"], xOffset, yOffset + TALENT_BUTTON_SIZE);
				end
				if ( node.down > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["down"], xOffset, yOffset - TALENT_BUTTON_SIZE);
				end
				if ( node.left > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["left"], xOffset - TALENT_BUTTON_SIZE, yOffset);
				end
				if ( node.right > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["right"], xOffset + TALENT_BUTTON_SIZE + 1, yOffset);
				end
				-- Draw arrows
				if ( node.rightArrow > 0 ) then
					TalentFrame_SetArrowTexture(i, j, TALENT_ARROW_TEXTURECOORDS["right"], xOffset + TALENT_BUTTON_SIZE/2 + 5, yOffset);
				end
				if ( node.leftArrow > 0 ) then
					TalentFrame_SetArrowTexture(i, j, TALENT_ARROW_TEXTURECOORDS["left"], xOffset - TALENT_BUTTON_SIZE/2 - 5, yOffset);
				end
				if ( node.topArrow > 0 ) then
					TalentFrame_SetArrowTexture(i, j, TALENT_ARROW_TEXTURECOORDS["top"], xOffset, yOffset + TALENT_BUTTON_SIZE/2 + 5);
				end
			else
				-- Doesn't have a talent
				if ( node.up > 0 and node.left > 0 and node.right > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["tup"], xOffset , yOffset);
				elseif ( node.down > 0 and node.left > 0 and node.right > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["tdown"], xOffset , yOffset);
				elseif ( node.left > 0 and node.down > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["topright"], xOffset , yOffset);
				elseif ( node.left > 0 and node.up > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["bottomright"], xOffset , yOffset);
				elseif ( node.left > 0 and node.right > 0 ) then
					--TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["left"], xOffset - TALENT_BUTTON_SIZE + 3, yOffset);
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["right"], xOffset + TALENT_BUTTON_SIZE, yOffset);
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["left"], xOffset + 1, yOffset);
				elseif ( node.right > 0 and node.down > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["topleft"], xOffset , yOffset);
				elseif ( node.right > 0 and node.up > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["bottomleft"], xOffset , yOffset);
				elseif ( node.up > 0 and node.down > 0 ) then
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["up"], xOffset , yOffset);
					TalentFrame_SetBranchTexture(i, j, TALENT_BRANCH_TEXTURECOORDS["down"], xOffset , yOffset - 32);
				end
			end
		end
		TalentFrameScrollFrame:UpdateScrollChildRect();
	end
	-- Hide any unused branch textures
	for i=TalentFrame_GetBranchTextureCount(), MAX_NUM_BRANCH_TEXTURES do
		getglobal("TalentFrameBranch"..i):Hide();
	end
	-- Hide and unused arrowl textures
	for i=TalentFrame_GetArrowTextureCount(), MAX_NUM_ARROW_TEXTURES do
		getglobal("TalentFrameArrow"..i):Hide();
	end
end

function TalentFrame_SetArrowTexture(tier, column, texCoords, xOffset, yOffset)
	local arrowTexture = TalentFrame_GetArrowTexture();
	arrowTexture:SetTexCoord(texCoords[1], texCoords[2], texCoords[3], texCoords[4]);
	arrowTexture:SetPoint("TOPLEFT", "TalentFrameArrowFrame", "TOPLEFT", xOffset, yOffset);
end

function TalentFrame_SetBranchTexture(tier, column, texCoords, xOffset, yOffset)
	local branchTexture = TalentFrame_GetBranchTexture();
	branchTexture:SetTexCoord(texCoords[1], texCoords[2], texCoords[3], texCoords[4]);
	branchTexture:SetPoint("TOPLEFT", "TalentFrameScrollChildFrame", "TOPLEFT", xOffset, yOffset);
	--[[if (  ) then
		branchTexture:SetVertexColor(0.6, 0.6, 0.6);
	else
		branchTexture:SetVertexColor(1.0, 1.0, 1.0);
	end]]
end

function TalentFrame_GetArrowTexture()
	local arrowTexture = getglobal("TalentFrameArrow"..TalentFrame.arrowIndex);
	TalentFrame.arrowIndex = TalentFrame.arrowIndex + 1;
	if ( not arrowTexture ) then
		_ERRORMESSAGE("Not enough arrow textures");
	else
		arrowTexture:Show();
		return arrowTexture;
	end
end

function TalentFrame_GetBranchTexture()
	local branchTexture = getglobal("TalentFrameBranch"..TalentFrame.textureIndex);
	TalentFrame.textureIndex = TalentFrame.textureIndex + 1;
	if ( not branchTexture ) then
		_ERRORMESSAGE("Not enough branch textures");
	else
		branchTexture:Show();
		return branchTexture;
	end
end

function TalentFrame_ResetArrowTextureCount()
	TalentFrame.arrowIndex = 1;
end

function TalentFrame_ResetBranchTextureCount()
	TalentFrame.textureIndex = 1;
end

function TalentFrame_GetArrowTextureCount()
	return TalentFrame.arrowIndex;
end

function TalentFrame_GetBranchTextureCount()
	return TalentFrame.textureIndex;
end

function TalentFrame_SetPrereqs(...)
	local buttonTier = arg[1];
	local buttonColumn = arg[2];
	local tier, column, isLearnable;
	local requirementsMet = 1;
	for i=3, arg.n, 3 do
		tier = arg[i];
		column = arg[i+1];
		isLearnable = arg[i+2];
		if ( not isLearnable ) then
			requirementsMet = nil;
		end
		TalentFrame_DrawLines(buttonTier, buttonColumn, tier, column);
	end
	return requirementsMet;
end

function TalentFrame_DrawLines(buttonTier, buttonColumn, tier, column)
	-- Check to see if are in the same column
	if ( buttonColumn == column ) then
		-- Check for blocking talents
		if ( (buttonTier - tier) > 1 ) then
			-- If more than one tier difference
			for i=tier + 1, buttonTier - 1 do
				if ( TALENT_BRANCH_ARRAY[i][buttonColumn].id ) then
					-- If there's an id, there's a blocker
					message("Error this layout is blocked vertically "..TALENT_BRANCH_ARRAY[buttonTier][i].id);
					return;
				end
			end
		end
		
		-- Draw the lines
		for i=tier, buttonTier - 1 do
			TALENT_BRANCH_ARRAY[i][buttonColumn].down = TALENT_BRANCH_ARRAY[i][buttonColumn].down + 1;
			TALENT_BRANCH_ARRAY[i + 1][buttonColumn].up = TALENT_BRANCH_ARRAY[i + 1][buttonColumn].up + 1;
		end
		
		-- Set the arrow
		TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].topArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].topArrow + 1;
		return;
	end
	-- Check to see if they're in the same tier
	if ( buttonTier == tier ) then
		local left = min(buttonColumn, column);
		local right = max(buttonColumn, column);
		
		-- See if the distance is greater than one space
		if ( (right - left) > 1 ) then
			-- Check for blocking talents
			for i=left + 1, right - 1 do
				if ( TALENT_BRANCH_ARRAY[tier][i].id ) then
					-- If there's an id, there's a blocker
					message("there's a blocker");
					return;
				end
			end
		end
		-- If we get here then we're in the clear
		for i=left, right - 1 do
			TALENT_BRANCH_ARRAY[tier][i].right = TALENT_BRANCH_ARRAY[tier][i].right + 1;
			TALENT_BRANCH_ARRAY[tier][i+1].left = TALENT_BRANCH_ARRAY[tier][i].left + 1;
		end
		-- Determine where the arrow goes
		if ( buttonColumn < column ) then
			TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].rightArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].rightArrow + 1;
		else
			TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].leftArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].leftArrow + 1;
		end
		return;
	end
	-- Now we know the prereq is diagonal from us
	local left = min(buttonColumn, column);
	local right = max(buttonColumn, column);
	-- Don't check the location of the current button
	if ( left == column ) then
		left = left + 1;
	else
		right = right - 1;
	end
	-- Check for blocking talents
	local blocked = nil;
	for i=left, right do
		if ( TALENT_BRANCH_ARRAY[tier][i].id ) then
			-- If there's an id, there's a blocker
			blocked = 1;
		end
	end
	left = min(buttonColumn, column);
	right = max(buttonColumn, column);
	if ( not blocked ) then
		TALENT_BRANCH_ARRAY[tier][buttonColumn].down = TALENT_BRANCH_ARRAY[tier][buttonColumn].down + 1;
		TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].up = TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].up + 1;
		
		for i=left, right - 1 do
			TALENT_BRANCH_ARRAY[tier][i].right = TALENT_BRANCH_ARRAY[tier][i].right + 1;
			TALENT_BRANCH_ARRAY[tier][i+1].left = TALENT_BRANCH_ARRAY[tier][i].left + 1;
		end
		-- Place the arrow
		TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].topArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].topArrow + 1;
		return;
	end
	-- If we're here then we were blocked trying to go vertically first so we have to go over first, then up
	if ( left == buttonColumn ) then
		left = left + 1;
	else
		right = right - 1;
	end
	-- Check for blocking talents
	for i=left, right do
		if ( TALENT_BRANCH_ARRAY[buttonTier][i].id ) then
			-- If there's an id, then throw an error
			message("Error, this layout is undrawable "..TALENT_BRANCH_ARRAY[buttonTier][i].id);
			return;
		end
	end
	-- If we're here we can draw the line
	left = min(buttonColumn, column);
	right = max(buttonColumn, column);
	TALENT_BRANCH_ARRAY[tier][column].down = TALENT_BRANCH_ARRAY[tier][column].down + 1;
	TALENT_BRANCH_ARRAY[buttonTier][column].up = TALENT_BRANCH_ARRAY[buttonTier][column].up + 1;

	for i=left, right - 1 do
		TALENT_BRANCH_ARRAY[buttonTier][i].right = TALENT_BRANCH_ARRAY[buttonTier][i].right + 1;
		TALENT_BRANCH_ARRAY[buttonTier][i+1].left = TALENT_BRANCH_ARRAY[buttonTier][i].left + 1;
	end

	-- Determine where the arrow goes
	if ( buttonColumn < column ) then
		TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].rightArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].rightArrow + 1;
	else
		TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].leftArrow =  TALENT_BRANCH_ARRAY[buttonTier][buttonColumn].leftArrow + 1;
	end
end

function TalentFrameTalent_OnClick()
	LearnTalent(PanelTemplates_GetSelectedTab(TalentFrame), this:GetID());
end

function TalentFrameTab_OnClick()
	PanelTemplates_SetTab(TalentFrame, this:GetID());
	TalentFrame_Update();
end

-- Helper functions
function TalentFrame_UpdateTalentPoints()
	local cp1, cp2 = UnitCharacterPoints("player");
	TalentFrameTalentPointsText:SetText(cp1);
	TalentFrame.talentPoints = cp1;
end

function SetTalentButtonLocation(button, tier, column)
	column = ((column - 1) * 63) + 31;
	tier = -((tier - 1) * 63) -3 ;
	button:SetPoint("TOPLEFT", button:GetParent():GetName(), "TOPLEFT", column, tier);
end

function TalentFrame_ResetBranches()
	for i=1, MAX_NUM_TALENT_TIERS do
		for j=1, NUM_TALENT_COLUMNS do
			TALENT_BRANCH_ARRAY[i][j].id = nil;
			TALENT_BRANCH_ARRAY[i][j].up = 0;
			TALENT_BRANCH_ARRAY[i][j].down = 0;
			TALENT_BRANCH_ARRAY[i][j].left = 0;
			TALENT_BRANCH_ARRAY[i][j].right = 0;
			TALENT_BRANCH_ARRAY[i][j].rightArrow = 0;
			TALENT_BRANCH_ARRAY[i][j].leftArrow = 0;
			TALENT_BRANCH_ARRAY[i][j].topArrow = 0;
		end
	end
end

function ToggleTalentFrame()
	if ( TalentFrame:IsVisible() ) then
		HideUIPanel(TalentFrame);
	else
		ShowUIPanel(TalentFrame);
	end
	UpdateMicroButtons();
end