-- "name" is the name of the frame to open, "ticketType" is the trouble ticket category associated with that frame
HELPFRAME_FRAMES = {};
HELPFRAME_FRAMES[1] = { name = "HelpFrameHome", ticketType = nil };
HELPFRAME_FRAMES[2] = { name = "HelpFrameOpenTicket", ticketType = 1 };
HELPFRAME_FRAMES[3] = { name = "HelpFrameHarassment", ticketType = 2 };
HELPFRAME_FRAMES[4] = { name = "HelpFrameStuck", ticketType = 3 };
HELPFRAME_FRAMES[5] = { name = "HelpFrameOpenTicket", ticketType = nil };
HELPFRAME_FRAMES[6] = { name = "HelpFrameGM", ticketType = 4 };

function HelpFrame_OnLoad()
	-- Tab Handling code
	--PanelTemplates_SetNumTabs(this, 5);
	--PanelTemplates_SetTab(this, 1);
	this:RegisterEvent("UPDATE_GM_STATUS");
end

function HelpFrame_OnShow()
	--HelpFrame_ShowFrame(PanelTemplates_GetSelectedTab(this));
	HelpFrame_ShowFrame(1);
	UpdateMicroButtons();
	PlaySound("igCharacterInfoOpen");
	GetGMStatus();
end

function HelpFrame_OnEvent()
	if ( event ==  "UPDATE_GM_STATUS" ) then
		if ( arg1 == 1 ) then
			HelpFrameHomeGMButton:Show();
		else
			HelpFrameHomeGMButton:Hide();
		end
	end
end

function HelpFrame_ShowFrame(id)
	for i=1, getn(HELPFRAME_FRAMES) do
		getglobal(HELPFRAME_FRAMES[i].name):Hide();
	end
	-- Set the ticketType category based on the tab
	if ( HELPFRAME_FRAMES[id].ticketType ) then
		HelpFrameOpenTicket.ticketType = HELPFRAME_FRAMES[id].ticketType;
	end
	getglobal(HELPFRAME_FRAMES[id].name):Show();
	--PanelTemplates_SetTab(HelpFrame, id);
end



function ToggleHelpFrame()
	if ( HelpFrame:IsVisible() ) then
		HideUIPanel(HelpFrame);
	else
		ShowUIPanel(HelpFrame);
		StaticPopup_Hide("HELP_TICKET_ABANDON_CONFIRM");
		StaticPopup_Hide("HELP_TICKET");
	end
end

function HelpFrameOpenTicketDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, HelpFrameOpenTicketDropDown_Initialize);
	UIDropDownMenu_SetWidth(335, HelpFrameOpenTicketDropDown);
end

function HelpFrameOpenTicketDropDown_Initialize()
	local index = 1;
	local ticketType = getglobal("TICKET_TYPE"..index);
	local info;
	while (ticketType) do
		info = {};
		info.text = ticketType;
		info.func = HelpFrameOpenTicketDropDown_OnClick;
		info.checked = checked;
		UIDropDownMenu_AddButton(info);
		index = index + 1;
		ticketType = getglobal("TICKET_TYPE"..index);
	end
end

function HelpFrameOpenTicketDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(HelpFrameOpenTicketDropDown, this:GetID());
end

function HelpFrameOpenTicketDropDown_OnShow()
	GetGMTicket();
end

function HelpFrameOpenTicket_OnEvent()
	-- If there are args then the player has a ticket
	if ( arg1 ~= 0 ) then
		-- Has an open ticket
		HelpFrameOpenTicket.ticketType = arg1;
		HelpFrameOpenTicketText:SetText(arg2);
		HelpFrameOpenTicket.hasTicket = 1;
		HelpFrameOpenTicketSubmit:SetText(EDIT_TICKET);
		HelpFrameOpenTicketCancel:SetText(EXIT);
		HelpFrameOpenTicketLabel:SetText(HELPFRAME_OPENTICKET_EDITTEXT);
	else
		-- Doesn't have an open ticket
		HelpFrameOpenTicketText:SetText("");
		HelpFrameOpenTicket.hasTicket = nil;
		HelpFrameOpenTicketSubmit:SetText(SUBMIT);
		HelpFrameOpenTicketCancel:SetText(CANCEL);
		HelpFrameOpenTicketLabel:SetText(HELPFRAME_OPENTICKET_TEXT);
	end	
end

function HelpFrameOpenTicketSubmit_OnClick()
	if ( HelpFrameOpenTicket.hasTicket ) then
		UpdateGMTicket(HelpFrameOpenTicket.ticketType, HelpFrameOpenTicketText:GetText());
		HideUIPanel(HelpFrame);
	else
		NewGMTicket(HelpFrameOpenTicket.ticketType, HelpFrameOpenTicketText:GetText());
		HideUIPanel(HelpFrame);
	end
	
	
end

function TicketStatusFrame_OnEvent()
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		GetGMTicket();
	else
		if ( arg1 ~= 0 ) then
			this:Show();
			BuffFrame:SetPoint("TOPRIGHT", this:GetParent():GetName(), "TOPRIGHT", -205, (-this:GetHeight()));
		else
			this:Hide();
			BuffFrame:SetPoint("TOPRIGHT", this:GetParent():GetName(), "TOPRIGHT", -205, -13);
		end
	end	
	
	
end

function HelpFrameHarassmentButton_OnClick()
	HelpFrameHarassment:Hide();
	HelpFrameOpenTicket.ticketType = 2;
	HelpFrameOpenTicket:Show();
end
