NUM_FACTIONS_DISPLAYED = 14;
REPUTATIONFRAME_FACTIONHEIGHT = 26;
FACTION_BAR_COLORS = {
	[1] = {r = 0.8, g = 0, b = 0},
	[2] = {r = 0.8, g = 0, b = 0},
	[3] = {r = 0.75, g = 0.27, b = 0},
	[4] = {r = 0.9, g = 0.7, b = 0},
	[5] = {r = 0, g = 0.6, b = 0.1},
	[6] = {r = 0, g = 0.6, b = 0.1},
	[7] = {r = 0, g = 0.6, b = 0.1},
};
function ReputationFrame_OnLoad()
	this:RegisterEvent("UPDATE_FACTION");
end

function ReputationFrame_OnShow()
	ReputationFrame_Update();
end

function ReputationFrame_OnEvent(event)
	if ( event == "UPDATE_FACTION" ) then
		ReputationFrame_Update();
	end
end

function ReputationFrame_Update()
	local numFactions = GetNumFactions();
	local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame);
	local factionIndex, factionStanding, factionBar, color;
	local name, standingID, barValue, atWarWith
	
	-- Update scroll frame
	FauxScrollFrame_Update(ReputationListScrollFrame, numFactions, NUM_FACTIONS_DISPLAYED, REPUTATIONFRAME_FACTIONHEIGHT )
		
	for i=1, NUM_FACTIONS_DISPLAYED, 1 do
		factionIndex = factionOffset + i;
		factionBar = getglobal("ReputationBar"..i);
		if ( factionIndex <= numFactions ) then
			name, standingID, barValue, atWarWith, canToggleAtWar = GetFactionInfo(factionIndex);
			factionStanding = getglobal("FACTION_STANDING_LABEL"..standingID);
			getglobal("ReputationBar"..i.."FactionName"):SetText(name);
			getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionStanding);
			local checkbox = getglobal("ReputationBar"..i.."AlliedCheckButton");
			checkbox:SetChecked(atWarWith);
			if ( canToggleAtWar ) then
				checkbox:Enable();
			else
				checkbox:Disable();
			end
			factionBar:SetValue(barValue);
			color = FACTION_BAR_COLORS[standingID];
			factionBar:SetStatusBarColor(color.r, color.g, color.b);
			factionBar:SetID(factionIndex);
			factionBar:Show();
		else
			factionBar:Hide();
		end
	end
end
