
function TextStatusBar_Initialize()
	this:RegisterEvent("CVAR_UPDATE");
	this.lockShow = 0;
end

function SetTextStatusBarText(bar, text)
	if ( not bar or not text ) then
		return
	end

	bar.TextString = text;
	if ( (OptionsFrameCheckButtons["STATUS_BAR_TEXT"].value == "0") and (bar.lockShow == 0) ) then
		text:Hide();
	else
		text:Show();
	end
end

function TextStatusBar_OnEvent(cvar, value)
	if ( event == "CVAR_UPDATE" and cvar == "STATUS_BAR_TEXT" ) then
		if ( this.TextString ) then
			if ( (value == "0") and (this.lockShow == 0) ) then
				this.TextString:Hide();
			else
				this.TextString:Show();
			end
		end
	end
end

function TextStatusBar_UpdateTextString()
	local string = this.TextString;
	if(string) then
		local value = this:GetValue();
		local valueMin, valueMax = this:GetMinMaxValues();
		if ( valueMax > 0 ) then
			this:Show();
			if ( value == 0 and this.zeroText ) then
				string:SetText(this.zeroText);
				this.isZero = 1;
				string:Show();
			else
				this.isZero = nil;
				if ( this.lockShow == 0 ) then
					HideTextStatusBarText(this);
				end
				if ( this.prefix ) then
					string:SetText(this.prefix.." "..value.." / "..valueMax);
				else
					string:SetText(value.." / "..valueMax);
				end
			end
		else
			this:Hide();
		end
	end
end

function TextStatusBar_OnValueChanged()
	TextStatusBar_UpdateTextString();
end

function SetTextStatusBarTextPrefix(bar, prefix)
	if ( bar and bar.TextString ) then
		bar.prefix = prefix;
	end
end

function SetTextStatusBarTextZeroText(bar, zeroText)
	if ( bar and bar.TextString ) then
		bar.zeroText = zeroText;
	end
end

function ShowTextStatusBarText(bar)
	if ( bar and bar.TextString ) then
		bar.TextString:Show();
		bar.lockShow = bar.lockShow + 1;
	end
end

function HideTextStatusBarText(bar)
	if ( bar and bar.TextString ) then
		if ( bar.lockShow > 0 ) then
			bar.lockShow = bar.lockShow - 1;
		end
		if ( bar.lockShow == 0 and OptionsFrameCheckButtons["STATUS_BAR_TEXT"].value == "0" and this.isZero ~= 1 ) then
			bar.TextString:Hide();
		end
	end
end
