MAX_TRADE_ITEMS = 6;

function TradeFrame_OnLoad()
	this:RegisterEvent("TRADE_CLOSED");
	this:RegisterEvent("TRADE_SHOW");
	this:RegisterEvent("TRADE_UPDATE");
	this:RegisterEvent("TRADE_TARGET_ITEM_CHANGED");
	this:RegisterEvent("TRADE_PLAYER_ITEM_CHANGED");
	this:RegisterEvent("TRADE_ACCEPT_UPDATE");
	this:RegisterEvent("TRADE_MONEY_CHANGED");
	this:RegisterEvent("PLAYER_TRADE_MONEY");
end

function TradeFrame_OnShow()
	TradeFrame.acceptState = 0;
end

function TradeFrame_OnEvent()
	if ( event == "TRADE_SHOW" or event == "TRADE_UPDATE" ) then
		ShowUIPanel(this, 1);
		TradeFrameTradeButton:Enable();
		TradeFrame_Update();
	elseif ( event == "TRADE_CLOSED" ) then
		HideUIPanel(this);
	elseif ( event == "TRADE_TARGET_ITEM_CHANGED" ) then
		TradeFrame_UpdateTargetItem(arg1);
	elseif ( event == "TRADE_PLAYER_ITEM_CHANGED" ) then
		TradeFrame_UpdatePlayerItem(arg1);
	elseif ( event == "TRADE_ACCEPT_UPDATE" ) then
		TradeFrame_SetAcceptState(arg1, arg2);
	end
end

function TradeFrame_Update()
	SetPortraitTexture(TradeFramePlayerPortrait, "player");
	SetPortraitTexture(TradeFrameRecipientPortrait, "NPC");
	TradeFramePlayerNameText:SetText(UnitName("player"));
	TradeFrameRecipientNameText:SetText(UnitName("NPC"));
	for i=1, MAX_TRADE_ITEMS, 1 do
		TradeFrame_UpdateTargetItem(i);
		TradeFrame_UpdatePlayerItem(i);
	end
	TradeFrameRecipientHighlightLeft:Hide();
	TradeFrameRecipientHighlightRight:Hide();
	TradeFramePlayerHighlightLeft:Hide();
	TradeFramePlayerHighlightRight:Hide();
end

function TradeFrame_UpdatePlayerItem(id)
	local name, texture, numItems, isEnchanted = GetTradePlayerItemInfo(id);
	getglobal("TradePlayerItem"..id.."Name"):SetText(name);
	local tradeItemButton = getglobal("TradePlayerItem"..id.."ItemButton");
	SetItemButtonTexture(tradeItemButton, texture);
	SetItemButtonCount(tradeItemButton, numItems);
end

function TradeFrame_UpdateTargetItem(id)
	local name, texture, numItems, isEnchanted, quality, isUsable = GetTradeTargetItemInfo(id);
	getglobal("TradeRecipientItem"..id.."Name"):SetText(name);
	local tradeItemButton = getglobal("TradeRecipientItem"..id.."ItemButton");
	local tradeItem = getglobal("TradeRecipientItem"..id);
	SetItemButtonTexture(tradeItemButton, texture);
	SetItemButtonCount(tradeItemButton, numItems);
	if ( isUsable or not name ) then
		SetItemButtonTextureVertexColor(tradeItemButton, 1.0, 1.0, 1.0);
		SetItemButtonNameFrameVertexColor(tradeItem, 1.0, 1.0, 1.0);
		SetItemButtonSlotVertexColor(tradeItem, 1.0, 1.0, 1.0);
	else
		SetItemButtonTextureVertexColor(tradeItemButton, 0.9, 0, 0);
		SetItemButtonNameFrameVertexColor(tradeItem, 0.9, 0, 0);
		SetItemButtonSlotVertexColor(tradeItem, 1.0, 0, 0);
	end
end

function TradeFrame_SetAcceptState(playerState, targetState)
	TradeFrame.acceptState = playerState;
	if ( playerState == 1 ) then
		TradeFramePlayerHighlightLeft:Show();
		TradeFramePlayerHighlightRight:Show();
		TradeFrameTradeButton:Disable();
	else
		TradeFramePlayerHighlightLeft:Hide();
		TradeFramePlayerHighlightRight:Hide();
		TradeFrameTradeButton:Enable();
	end
	if ( targetState == 1 ) then
		TradeFrameRecipientHighlightLeft:Show();
		TradeFrameRecipientHighlightRight:Show();
	else
		TradeFrameRecipientHighlightLeft:Hide();
		TradeFrameRecipientHighlightRight:Hide();
	end
end

function TradeFrameCancelButton_OnClick() 
	if ( TradeFrame.acceptState == 1 ) then
		CancelTradeAccept();
	else
		HideUIPanel(TradeFrame);
	end
end

function TradeFrame_OnHide()
	CloseTrade();
end

function TradeFrame_OnMouseUp()
	if ( GetCursorMoney() ) then
		AddTradeMoney();
	end
end
