OneHitWonder_Hunter_MarkIsBusy = 0;

OneHitWonder_Hunter_ShouldAutoMarkRogues = 0;
OneHitWonder_Hunter_ShouldPetAttack = 0;
OneHitWonder_Hunter_PreferredAspect = nil;

function OneHitWonder_Init_Hunter()
	OneHitWonder_Options["OneHitWonder_Hunter_ShouldPetAttack"] = OneHitWonder_Hunter_ShouldPetAttack;
	OneHitWonder_Options["OneHitWonder_Hunter_PreferredAspect"] = OneHitWonder_Hunter_PreferredAspect;
	OneHitWonder_Options["OneHitWonder_Hunter_ShouldAutoMarkRogues"] = OneHitWonder_Hunter_ShouldAutoMarkRogues;
end

function OneHitWonder_Hunter(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_IsChannelSpellRunning() ) or ( OneHitWonder_IsRegularSpellRunning() ) then
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		OneHitWonder_DoBuffs();
		return;
	end

	local inAutoShotRange = OneHitWonder_CheckIfInRangeSpellId(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_AUTOSHOT_NAME));

	if ( inAutoShotRange ) or ( PlayerFrame.inCombat ~= 1 ) then
		if ( OneHitWonder_Hunter_MarkIsBusy ~= 1 ) then
			if ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_HUNTERS_MARK_EFFECT) ) then
				if ( OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_HUNTERS_MARK_NAME)) ) then
					return;
				end
			end
		end
	end

	if (OneHitWonder_PetIsAttacking == false) then
		OneHitWonder_Hunter_SmartPetAttack();
	end
	
	if ( inAutoShotRange ) then
		if ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_CONCUSSIVE_SHOT_EFFECT) ) then
			if ( OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_CONCUSSIVE_SHOT_NAME)) ) then
				return;
			end
		end
		if ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_SERPENT_STING_EFFECT) ) then
			if ( OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_SERPENT_STING_NAME)) ) then
				return;
			end
		end
		if ( OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_ARCANE_SHOT_NAME)) ) then
			return;
		end
	else
		OneHitWonder_MeleeAttack();
		local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_RAPTOR_STRIKE_NAME);
		if ( OneHitWonder_CheckIfUsableSpellId(spellId) ) then
			if ( OneHitWonder_CastSpell(spellId) ) then
				return;
			end
		end
	end
	
end		


function OneHitWonder_Hunter_SetShouldPetAttack(toggle)
	OneHitWonder_Hunter_ShouldPetAttack = toggle;
end

function OneHitWonder_Hunter_SetAutoMarkRogues(toggle)
	OneHitWonder_Hunter_AutoMarkRogues = toggle;
end

function OneHitWonder_Hunter_Cosmos()
	if ( Cosmos_RegisterConfiguration ) and ( Cosmos_UpdateValue ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_HUNTER_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_HUNTER_SEPARATOR),
			TEXT(ONEHITWONDER_HUNTER_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_HUNTER_USE_SMART_PET_ATTACK",
			"CHECKBOX",
			TEXT(ONEHITWONDER_HUNTER_USE_SMART_PET_ATTACK),
			TEXT(ONEHITWONDER_HUNTER_USE_SMART_PET_ATTACK_INFO),
			OneHitWonder_Hunter_SetShouldPetAttack,
			OneHitWonder_Hunter_ShouldPetAttack
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_HUNTER_AUTO_MARK_ROGUES",
			"CHECKBOX",
			TEXT(ONEHITWONDER_HUNTER_AUTO_MARK_ROGUES),
			TEXT(ONEHITWONDER_HUNTER_AUTO_MARK_ROGUES_INFO),
			OneHitWonder_Hunter_SetAutoMarkRogues,
			OneHitWonder_Hunter_ShouldAutoMarkRogues
		);
		
	end
	
end



function OneHitWonder_Hunter_SmartPetAttack()
	return OneHitWonder_SmartPetAttack(OneHitWonder_Hunter_ShouldPetAttack);
end

function OneHitWonder_SetupStuffContinuously_Hunter()
	--OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_] = 5*60;
end


function OneHitWonder_GetParryCounter_Hunter()
	local counterId = -1;
	local abilityName = "";
	abilityName = ONEHITWONDER_ABILITY_COUNTERATTACK_NAME;
	counterId = OneHitWonder_GetSpellId(abilityName);
	return counterId, abilityName;
end

function OneHitWonder_GetDodgeCounter_Hunter()
	local counterId = -1;
	local abilityName = "";
	abilityName = ONEHITWONDER_ABILITY_MONGOOSE_BITE_NAME;
	counterId = OneHitWonder_GetSpellId(abilityName);
	return counterId, abilityName;
end


function OneHitWonder_DoStuffContinuously_Hunter()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	if ( OneHitWonder_ShouldKeepBuffsUp ~= 1 ) then
		return false;
	end
	local hasAnyAspect = false;
	if ( ( AuraAspects_Enabled ) and ( AuraAspects_Enabled == 1 ) ) then
		hasAnyAspect = OneHitWonder_HasAnActiveWhatever(ONEHITWONDER_SPELL_ASPECT_SUBSTRING, false);
	else
		hasAnyAspect = OneHitWonder_HasPlayerEffect(nil, OneHitWonder_HunterAspects);
	end
	local buffIndex, untilCancelled;
	if ( not hasAnyAspect ) and ( OneHitWonder_ShouldTryToCastABuff() ) then
		local aspectId = nil;
		local tryToCastAspect = true;
		if ( OneHitWonder_Hunter_PreferredAspect ) then
			if ( OneHitWonder_Hunter_PreferredAspect == ONEHITWONDER_SPELL_NO_ASPECT_NAME ) then
				tryToCastAspect = false;
			else
				aspectId = OneHitWonder_GetSpellId(OneHitWonder_Hunter_PreferredAspect);
				if ( aspectId > -1 ) and ( OneHitWonder_IsSpellAvailable(aspectId) ) and 
					( not OneHitWonder_HasPlayerEffect(nil, OneHitWonder_Hunter_PreferredAspect) ) then
					if ( OneHitWonder_CastSpell(aspectId) ) then
						return true;
					end
				end
				tryToCastAspect = false;
			end
		end
		if ( tryToCastAspect ) then
			for k, v in OneHitWonder_HunterAspects do
				aspectId = OneHitWonder_GetSpellId(v);
				if ( ( OneHitWonder_IsSpellAvailable(aspectId) ) and ( not OneHitWonder_HasPlayerEffect(nil, v) ) ) then
					OneHitWonder_CastSpell(aspectId);
					return true;
				end
			end
		end
	end
	return false;
end


function OneHitWonder_Hunter_IsTargetAutoMarkMaterial()
	return ( UnitClass("target") == ONEHITWONDER_CLASS_ROGUE );
	--return true;
end

function OneHitWonder_Target_Changed_Hunter()
	if ( OneHitWonder_HasTarget() ) and ( not UnitIsDead("target") ) and ( OneHitWonder_Hunter_IsTargetAutoMarkMaterial() ) and ( UnitCanAttack("target", "player") and ( OneHitWonder_Hunter_MarkIsBusy ~= 1 ) ) then
		if ( OneHitWonder_Hunter_ShouldAutoMarkRogues == 1 ) then
			if ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_HUNTERS_MARK_EFFECT) ) then
				local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_HUNTERS_MARK_NAME);
				if ( spellId > -1 ) then
					local parameters = { spellId, "target", GetTime() + 3};
					OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TARGET, parameters);
				end
			end
		end
	end
end
