ONEHITWONDER_ABILITY_REND_TEXTURE = "Interface\\Icons\\Ability_Gouge";
ONEHITWONDER_ABILITY_BATTLESHOUT_TEXTURE = "Interface\\Icons\\Ability_Warrior_BattleShout";

-- needs to be modified by talents
ONEHITWONDER_ABILITY_RAGECOST = {
	[ONEHITWONDER_ABILITY_BATTLESHOUT_NAME] = 20,
	[ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME] = 15,
	[ONEHITWONDER_ABILITY_PUMMEL_NAME] = 10,
	[ONEHITWONDER_ABILITY_REVENGE_NAME] = 5,
	[ONEHITWONDER_ABILITY_SHIELDBASH_NAME] = 10,
	[ONEHITWONDER_ABILITY_REND_NAME] = 10,
	[ONEHITWONDER_ABILITY_HAMSTRING_NAME] = 10,
	[ONEHITWONDER_ABILITY_MOCKINGBLOW_NAME] = 10,
	[ONEHITWONDER_ABILITY_OVERPOWER_NAME] = 5,
	[ONEHITWONDER_ABILITY_EXECUTE_NAME] = 15,
	[ONEHITWONDER_ABILITY_SUNDER_ARMOR_NAME] = 15,
	[ONEHITWONDER_ABILITY_CHARGE_NAME] = 0
};

function OneHitWonder_GetRageConsumption(abilityName)
	return ONEHITWONDER_ABILITY_RAGECOST[abilityName];
end

ONEHITWONDER_WARRIOR_TALENT_RAGE_REDUCERS = {
	{ 
		{ 1,1 },
		ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME,
		{ 14, 13, 12 }
	},
};

--[[
	{ 
		{ talent tab, talent },
		Ability index,
		{ rage cost at rank 1, rage cost at rank 2, ... }
	},
]]--

ONEHITWONDER_ABILITY_SUNDER_ARMOR = {
	90,
	180,
	270,
	360,
	450
};


ONEHITWONDER_MAXIMUM_NUMBER_OF_SUNDERS 		= 5;


OneHitWonder_Warrior_UseShieldBash = 1;
OneHitWonder_Warrior_ShouldAutoExecute = 1;

OneHitWonder_Warrior_SundersApplied = {};
OneHitWonder_Warrior_TargetSundersApplied = { numberOfTimesApplied = 0, timeApplied = 0 };

function OneHitWonder_TryToInterruptSpell_Warrior(unitName, spellName)
	local interruptId = -1;
	local abilityName = ONEHITWONDER_ABILITY_SHIELDBASH_NAME;
	if ( OneHitWonder_Warrior_UseShieldBash ~= 1 ) then
		abilityName = "";
	end
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName);
		if ( not OneHitWonder_IsSpellAvailable(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return interruptId, abilityName;
end

function OneHitWonder_Warrior_SetUseShieldBash(toggle)
	OneHitWonder_Warrior_UseShieldBash = toggle;
end



function OneHitWonder_Warrior_Cosmos()
	if ( Cosmos_RegisterConfiguration ) and ( Cosmos_UpdateValue ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_WARRIOR_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_WARRIOR_SEPARATOR),
			TEXT(ONEHITWONDER_WARRIOR_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_WARRIOR_USE_SHIELD_BASH",
			"CHECKBOX",
			TEXT(ONEHITWONDER_WARRIOR_USE_SHIELD_BASH),
			TEXT(ONEHITWONDER_WARRIOR_USE_SHIELD_BASH_INFO),
			OneHitWonder_Warrior_SetUseShieldBash,
			OneHitWonder_Warrior_UseShieldBash
		);
	end
end

function OneHitWonder_Warrior_IsUnitRendable(unit)
	if ( OneHitWonder_IsUnitOfType(unit, OneHitWonder_NonRendableMobTypes, true) ) then
		return false;
	else
		return true;
	end
end

function OneHitWonder_Warrior(removeDefense)
	local targetName = UnitName("target");

	if ( OneHitWonder_IsChannelSpellRunning() ) or ( OneHitWonder_IsRegularSpellRunning() ) then
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_Warrior_BattleShoutRefresh() ) then
			OneHitWonder_DoStuffContinuously();
		end
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	local stance = OneHitWonder_Warrior_GetStance();

	OneHitWonder_DebugPrint(format("Current stance = %d", stance));

	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);
		
		local chargeActionId = -1;
		if ( chargeId > -1 ) then
			chargeActionId = OneHitWonder_GetActionIdFromSpellId(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL);
		end
		
		if ( chargeActionId > -1 ) then
			if ( OneHitWonder_CheckIfInRangeActionId(chargeActionId) ) then
				--Print("In range for Charge.");
				if ( OneHitWonder_CheckIfUsable(chargeActionId, chargeId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
					--Print("Charge!");
					CastSpell(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL);
					return;
				else
					--Print("Charge not available.");
					return;
				end
			else
				--Print("Not in range for Charge.");
				local currentRange = OneHitWonder_Warrior_GetCurrentRange();
				if ( ( PlayerFrame.inCombat ~= 1 ) and (currentRange ~= ONEHITWONDER_WARRIOR_RANGE_MELEE) ) then
					--Print("Not in combat and not close enough - postponing attempt.");
					--Print("Range is "..currentRange);
					return;
				end
			end
		else
			if ( OneHitWonder_CastSpell(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				return;
			end
		end
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( OneHitWonder_Warrior_BattleShoutRefresh() ) then
		return;
	end

	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
	if ( unitHPPercent >= 25 ) then
		if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			if ( ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_ABILITY_REND_NAME) ) and ( OneHitWonder_Warrior_IsUnitRendable("target") ) )then
				if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_REND_NAME) ) then
					local spellId = 0;
					spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
					if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
						return;
					end
				else
					return;
				end
			end
		end
	end	

	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME);
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return;
			end
		else
			return;
		end
	end
end


function OneHitWonder_Warrior_GetStance()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				if ( name == ONEHITWONDER_WARRIOR_STANCE_BATTLE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_BERZERK_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_BERSERK;
				else
					return -1;
				end
			end
		end
	end
	return -1;
end

function OneHitWonder_Warrior_GetStanceOld()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				if ( numForms == 1 ) then
					return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
				elseif ( numForms == 2 ) then
					if ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					end
				elseif ( numForms == 3 ) then
					if ( i == 3 ) then	
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					end
				elseif ( numForms == 4 ) then
					if ( i == 4 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 3 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_BERSERK;
					end
				end
			end
		end
	end
	return -1;
end

function OneHitWonder_Warrior_GetGameStanceId(stanceId)
	local numForms = GetNumShapeshiftForms();
	if ( numForms == 1 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 1;
		end
	elseif ( numForms == 2 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 1;
		end
	elseif ( numForms == 3 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 1;
		end
	elseif ( numForms == 4 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 4;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
			return 1;
		end
	end
	return -1;
end

ONEHITWONDER_WARRIOR_RANGE_UNKNOWN = 0;
ONEHITWONDER_WARRIOR_RANGE_MELEE = 1;
ONEHITWONDER_WARRIOR_RANGE_CHARGE = 2;
ONEHITWONDER_WARRIOR_RANGE_RANGED = 3;
ONEHITWONDER_WARRIOR_RANGE_BEYOND = 4;

function OneHitWonder_Warrior_GetCurrentRange()
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);
		local rangedId = -1;
		local meleeRangeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
		if ( meleeRangeId <= -1 ) then OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HAMSTRING_NAME); end

		if ( not OneHitWonder_CheckIfInRangeSpellId(chargeId) ) then
			if (not OneHitWonder_CheckIfInRangeSpellId(meleeRangeId)) then
				if ( rangedId > -1 ) then
					if (not OneHitWonder_CheckIfInRangeSpellId(rangedId)) then
						return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
					else
						return ONEHITWONDER_WARRIOR_RANGE_RANGED;
					end
				else
					return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
				end
			else
				return ONEHITWONDER_WARRIOR_RANGE_MELEE;
			end
		else
			return ONEHITWONDER_WARRIOR_RANGE_CHARGE;
		end
	end
	return ONEHITWONDER_WARRIOR_RANGE_UNKNOWN;
end



function OneHitWonder_GetBlockCounter_Warrior()
	return OneHitWonder_GetWarriorBlockDodgeParryCounter();
end

function OneHitWonder_GetDodgeCounter_Warrior()
	return OneHitWonder_GetWarriorBlockDodgeParryCounter();
end

function OneHitWonder_GetParryCounter_Warrior()
	return OneHitWonder_GetWarriorBlockDodgeParryCounter();
end

function OneHitWonder_GetTargetDodgeCounter_Warrior()
	local counterId = -1;
	local abilityName = "";
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		abilityName = ONEHITWONDER_ABILITY_OVERPOWER_NAME;
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_OVERPOWER_NAME);
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId, abilityName;
end



function OneHitWonder_GetWarriorBlockDodgeParryCounter()
	local counterId = -1;
	local abilityName = "";
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
		abilityName = ONEHITWONDER_ABILITY_REVENGE_NAME;
		counterId = OneHitWonder_GetSpellId(abilityName);
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId, abilityName;
end


-- Retrieves the current number of armor sundered from a tooltip strings.
function OneHitWonder_Warrior_RetrieveCurrentSunderedArmor(strings)
	local index = nil;
	local tmpStr = nil;
	local armor = nil;
	for k, v in strings do 
		if (v.left) then
			index = strfind(v.left, ONEHITWONDER_ABILITY_SUNDER_ARMOR_TOOLTIP);
			if ( index ) then
				index = index + strlen(ONEHITWONDER_ABILITY_SUNDER_ARMOR_TOOLTIP);
				tmpStr = strsub(v.left, index);
				armor = findpattern(tmpStr, ONEHITWONDER_ABILITY_SUNDER_ARMOR_NUMBER_STRING);
				if ( armor ) then
					return armor;
				else
					tmpStr = strings[k+1];
					if ( tmpStr ) then
						armor = findpattern(tmpStr.left, ONEHITWONDER_ABILITY_SUNDER_ARMOR_NUMBER_STRING); 
						if ( armor ) then
							return armor;
						end
					end
				end
			end
		end
	end
	return 0;
end

-- what this does is check the mouseover and see if our current sunder can be the one that 
-- caused the sundered effect on the poor unit (if any). It does this by checking how much armor 
-- we can sunder and how much armor is currently sundered (I don't know if that tooltip is visible)
-- and dividing the two values. If we end up with a value that is "not allowed", 
-- then we check for another effect (since 2 warriors generate two sunder armor effects AFAIK).
function OneHitWonder_Warrior_RetrieveCurrentSunderNumber(unit, index)
	local effectInfos = DynamicData.effect.getEffectInfos(unit);
	local tmpEffectInfo = nil;
	local effectInfo = nil;
	if ( not index ) then index = 1; end
	local j = 1;
	local i = index;
	while ( i > 1 ) do
		tmpEffectInfo = effectInfos.buffs[j];
		if ( tmpEffectInfo ) then
			if ( tmpEffectInfo.name == ONEHITWONDER_ABILITY_SUNDER_ARMOR_EFFECT ) then
				effectInfo = tmpEffectInfo;
				i = i - 1;
			end
		end
		j = j + 1;
	end
	if ( effectInfo ) then
		local appliedValue = 1;
		
		local sunderValue = OneHitWonder_Warrior_RetrieveCurrentSunderedArmor(effectInfo.strings);
		if ( sunderValue > 0 ) then
			local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SUNDER_ARMOR_NAME, ONEHITWONDER_BOOK_TYPE_SPELL);
			local spellInfo = DynamicData.spell.getSpellInfo(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
			if ( spellInfo ) then
				local armorPerSunder = ONEHITWONDER_ABILITY_SUNDER_ARMOR[spellInfo.realRank];
				local numberOfTimesApplied = ( sunderValue / armorPerSunder );
				if ( numberOfTimesApplied > ONEHITWONDER_MAXIMUM_NUMBER_OF_SUNDERS ) then
					if ( i <= 0 ) then
						return OneHitWonder_Warrior_RetrieveCurrentSunderNumber(unit, index + 1);
					end
				elseif ( numberOfTimesApplied < 0 ) then
					if ( i <= 0 ) then
						return OneHitWonder_Warrior_RetrieveCurrentSunderNumber(unit, index + 1);
					end
				elseif ( math.floor(numberOfTimesApplied) ~= numberOfTimesApplied  ) then
					if ( i <= 0 ) then
						return OneHitWonder_Warrior_RetrieveCurrentSunderNumber(unit, index + 1);
					end
				end
				appliedValue = numberOfTimesApplied;
			end
		end
		
		return appliedValue;
	else
		return 0;
	end
end

function OneHitWonder_Warrior_ApplySunderArmor()
	local curTime = GetTime();
	if ( OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied < curTime ) then
		Print("HELLO SIR1!");
		OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied = OneHitWonder_Warrior_RetrieveCurrentSunderNumber("target");
	end
			Print("HELLO SIR3!");
	if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_SUNDER_ARMOR_NAME) ) then
		local spellId = 0;
		Print("HELLO SIR2!");
		spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SUNDER_ARMOR_NAME, ONEHITWONDER_BOOK_TYPE_SPELL);
		OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
		if ( not OneHitWonder_IsSpellAvailable(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) and ( not OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
			return;
		end
	else
		return;
	end
	Print("HELLO SIR4!");
	if ( not OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied ) then
		OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied = 1;
	else
		OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied = OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied + 1;
	end
	if ( OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied > ONEHITWONDER_MAXIMUM_NUMBER_OF_SUNDERS ) then
		OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied = ONEHITWONDER_MAXIMUM_NUMBER_OF_SUNDERS;
	end
	OneHitWonder_Warrior_TargetSundersApplied.timeApplied = curTime;
end

-- place any nice logic here
function OneHitWonder_Warrior_GetNumberOfSundersToApply(unit)
	return ONEHITWONDER_MAXIMUM_NUMBER_OF_SUNDERS;
end

function OneHitWonder_Warrior_ShouldApplySunderArmor()
	local data = OneHitWonder_Warrior_TargetSundersApplied;
	local curTime = GetTime();
	if ( data.numberOfTimesApplied < OneHitWonder_Warrior_GetNumberOfSundersToApply() ) then
		return true;
	end
	-- if the effect expires within 5 seconds, suggest that we reapply it
	if ( data.timeApplied < ( curTime + 5 ) ) then
		return true;
	else
		return false;
	end
end

-- is it this advanced?
function OneHitWonder_Warrior_CleanSunderArmors()
	local unitName = UnitName("target");
	if ( not OneHitWonder_Warrior_SundersApplied[unitName] ) then
		OneHitWonder_Warrior_SundersApplied[unitName] = {};
		return;
	end
	local i = 1;
	local data = nil;
	local curTime = GetTime();
	while ( i < table.getn(OneHitWonder_Warrior_SundersApplied[unitName] ) ) do
		data = OneHitWonder_Warrior_SundersApplied[unitName][i];
		if ( data ) then
			if ( data.time < curTime ) then
				table.remove(OneHitWonder_Warrior_SundersApplied[unitName], i);
			else
				i = i + 1;
			end
		else
			break;
		end
	end
end

function OneHitWonder_UnitHealthCheck_Warrior(unit)

	-- Do the execute check.
	if ( PlayerFrame.inCombat == 1 ) and (( OneHitWonder_HasTarget() ) and ( UnitCanAttack("target", "player") ) and ( unit == "target" ) ) then
		local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
		local stance = OneHitWonder_Warrior_GetStance();

		--Do the Execute Holler. 
		if ( unitHPPercent <= 20 ) then	
			if (( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) or ( stance == ONEHITWONDER_WARRIOR_STANCE_BERZERK_NAME)) then
				if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_EXECUTE_NAME, true) ) then
					local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_EXECUTE_NAME);
					if ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) then
						OneHitWonder_ShowImperativeMessage(ONEHITWONDER_ABILITY_EXECUTE_NAME);
						if ( OneHitWonder_Warrior_ShouldAutoExecute == 1 ) then
							local parameters = { spellId, "target", ( GetTime() + 2 ) };
							OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TARGET, parameters);
						end
						return;
						--local spellId = 0;
						--spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_EXECUTE_NAME);
						--if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
						--	return;
						--end
					end
				end
			end
		end
	end
end



function OneHitWonder_Target_Changed_Warrior()
	local unitName = UnitName("target");

	OneHitWonder_Warrior_TargetSundersApplied.numberOfTimesApplied = OneHitWonder_Warrior_RetrieveCurrentSunderNumber("target");
	OneHitWonder_Warrior_TargetSundersApplied.timeApplied = curTime;
	--OneHitWonder_Warrior_SundersApplied[unitName] = {};

end
