OneHitWonder_ShouldTryToInterruptSpell = true;
OneHitWonder_UseBlockCounter = true;
OneHitWonder_UseDodgeCounter = true;
OneHitWonder_UseParryCounter = true;

ONEHITWONDER_ACTIONID_SPELL = 1;
ONEHITWONDER_ACTIONID_SPELL_TIMEOUT = 2;

OneHitWonder_ActionQueue = {};

OneHitWonder_Saved_ChatFrame_OnEvent = nil;

function OneHitWonder_IsTargetedUnit(name)
	if ( UnitName("target") == name ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_ExtractUnitNameFromCombatMessage(msg, source, stringAfterName)
	if ( ( source ) and ( strlen(source) > 0 ) ) then 
		return source;
	else
		local index = strfind(arg1, stringAfterName);
		if ( index ~= nil ) then
			return strsub(arg1, 1, index-2);
		else
			return "";
		end
	end
end

OneHitWonder_WaitForFeedBack = false;
OneHitWonder_WaitForFeedBackTimeout = 0;
OneHitWonder_WaitForFeedBackDefaultTimeout = 2;
OneHitWonder_ChatFeedBack = "";

-- verify this
ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES = {
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
	"SPELL_CREATURE_VS_CREATURE_DAMAGE",
	"SPELL_CREATURE_VS_CREATURE_BUFF"
};

ONEHITWONDER_CLASS_ROGUE = "Rogue";
ONEHITWONDER_CLASS_WARRIOR = "Warrior";

ONEHITWONDER_WARRIOR_STANCE_BATTLE = 1;
ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE = 2;
ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE = 3;
ONEHITWONDER_WARRIOR_STANCE_BERSERK = 4;

function OneHitWonder_Warrior_GetStance()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				return i;
			end
		end
	end
	return -1;
end

function OneHitWonder_TryToInterruptSpell()
	local interruptId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_KICK_NAME);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		-- this gets tricky
		local stance = OneHitWonder_Warrior_GetStance();
		if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SHIELDBASH_NAME);
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
		end
	end
	if ( interruptId > -1 ) then
		local parameters = { interruptId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_GetWarriorBlockDodgeParryCounter()
	local counterId = -1;
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REVENGE_NAME);
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId;
end

function OneHitWonder_DoBlockCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoDodgeCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoParryCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_RIPOSTE_NAME);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_ChatFrame_OnEvent(event)
	if ( true ) then
		if ( strsub(event, 1, 8) == "CHAT_MSG" ) then
			local typeOfEvent = strsub(event, 10);
			local info = ChatTypeInfo[type];
			local unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "begins to cast");
			if ( ( strfind(arg1, "begins to cast" ) ) and (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToInterruptSpell ) ) then
				local shouldInterrupt = false;
				for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
					if ( strfind(typeOfEvent, v) ) then
						shouldInterrupt = true;
					end
				end
				if ( shouldInterrupt ) then
					OneHitWonder_TryToInterruptSpell();
				end
			end
			if ( ( OneHitWonder_UseParryCounter ) and ( strfind(arg1, "You parry") ) ) then
				OneHitWonder_DoParryCounter();
			end
			if ( ( OneHitWonder_UseBlockCounter ) and ( strfind(arg1, "You block") ) ) then
				OneHitWonder_DoBlockCounter();
			end
			if ( ( OneHitWonder_UseDodgeCounter ) and ( strfind(arg1, "You dodge") ) ) then
				OneHitWonder_DoDodgeCounter();
			end
		end
	end
	OneHitWonder_Saved_ChatFrame_OnEvent(event);
end

function OneHitWonder_HasTargetBuffTexture(texture)
	local buff;
	for i=1, MAX_TARGET_DEBUFFS do
		buff = UnitBuff("target", i);
		if ( buff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetDebuffTexture(texture)
	local debuff;
	local i = 0;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetAnyBuffTexture(texture)
	if ( OneHitWonder_HasTargetBuffTexture(texture) ) then
		return true;
	else
		return OneHitWonder_HasTargetDebuffTexture(texture);
	end
end

function OneHitWonder_HasBuffTexture(texture)
	local id = 1;
	for id = 1, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

ONEHITWONDER_BOOK_TYPE_SPELL = "spell";

function OneHitWonder_GetSpellId(spellName)
	local i = 1;
	local name, rankName;
	name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	while name do
		if ( name == spellName) then
			return i;
		end
		i = i + 1;
		name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	end
	return -1;
end

function OneHitWonder_HasEnoughEnergy(abilityName)
	local energy = PlayerFrameManaBar:GetValue();

	if ( OneHitWonder_GetEnergyConsumption(abilityName) <= energy ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasEnoughRage(abilityName)
	local rage = PlayerFrameManaBar:GetValue();

	if ( OneHitWonder_GetRageConsumption(abilityName) <= rage ) then
		return true;
	else
		return false;
	end
end


function OneHitWonder_CheckIfInRangeAndUsableInActionBar(texture)
	if ( texture ) then
		local id = 1;
		local actionTexture;
		for id = 1, 120 do
			actionTexture = GetActionTexture(id);
			if ( ( actionTexture ) and ( actionTexture == texture ) ) then
				local isUsable, notEnoughMana = IsUsableAction(id);
				local isActionInRange = true;
				if ( IsActionInRange(id) == 0) then
					isActionInRange = false;
				end
				if ( ( isUsable ) and ( not notEnoughMana ) and (isActionInRange) ) then
					return true;
				else
					return false;
				end
			end
		end
	end
	return true;
end

-- /script PrintTable(OneHitWonder_SpellAvailability);
-- /script OneHitWonder_SpellAvailability = {};

OneHitWonder_SpellAvailability = {};

function OneHitWonder_Log(spellId, spellBook, start, duration, enable)
	if ( enable == 0 ) then
		return;
	end
	if ( not OneHitWonder_SpellAvailability[spellId]) then
		OneHitWonder_SpellAvailability[spellId] = {};
	end
	local currentTime = GetTime() * 1000;
	local cooldownTime = start * 1000 + duration * 1000;
	local available = "true";
	if ( cooldownTime > currentTime ) then
		available = "false";
	end
	local parameter = {start, duration, enable, GetTime(), available};
	table.insert(OneHitWonder_SpellAvailability[spellId], parameter);
end

function OneHitWonder_IsSpellAvailable(spellId, spellBook)
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) )then
			if ( OneHitWonder_CheckIfInRangeAndUsableInActionBar(GetSpellTexture(spellId, spellBook)) ) then
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_CastSpell(spellId, spellBook)
	if ( OneHitWonder_IsSpellAvailable(spellId, spellBook) ) then
		CastSpell(spellId, spellBook);
		return true;
	end
	return false;
end

function OneHitWonder_GetTargetHPPercentage()
	local unitMinHP, unitMaxHP, unitCurrHP;
	unitMinHP, unitMaxHP = TargetFrameHealthBar:GetMinMaxValues();
	unitCurrHP = TargetFrameHealthBar:GetValue();
	
	local unitHPPercent = TargetFrame.unitHPPercent;



	if ( not UnitIsPlayer("target") ) then
		unitHPPercent = unitCurrHP;
	else
		unitHPPercent = math.floor(unitHPPercent * 100);
	end
	return unitHPPercent;
end

function OneHitWonder_GetComboPointsNeededToEviscerate()
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
	local playerLevel = UnitLevel("player");
	local targetLevel = UnitLevel("target");
	if ( targetLevel - playerLevel > 5 ) then
		-- does not matter, you're not going to do something good with it anyhow
		return 1;
	end
	if ( playerLevel - targetLevel >= 10 ) then
		-- will prolly kill it quick
		return 1;
	end
	if ( playerLevel - targetLevel >= 5 ) then
		if ( unitHPPercent <= 15 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 3;
		end
	end
	if ( playerLevel - targetLevel >= 3 ) then
		if ( unitHPPercent <= 20 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 4;
		end
	end
	if ( playerLevel - targetLevel >= -1 ) then
		if ( unitHPPercent <= 25 ) then
			return 1;
		elseif ( unitHPPercent <= 40 ) then
			return 2;
		elseif ( unitHPPercent <= 50 ) then
			return 3;
		else
			return 5;
		end
	else
		if ( unitHPPercent <= 10 ) then
			return 2;
		elseif ( unitHPPercent <= 25 ) then
			return 3;
		elseif ( unitHPPercent <= 50 ) then
			return 4;
		else
			return 5;
		end
	end
end

function OneHitWonder_HasPartyMembers()
	local partyMembers = 0;
	
	for i=1, MAX_PARTY_MEMBERS, 1 do
		if ( GetPartyMember(i) ) then
			partyMembers = partyMembers + 1;
		end
	end
	if ( partyMembers > 0 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_DumpDebuffsOnce()
	if ( not DebuffsShown ) then
		DebuffsShown = {};
	end
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) and ( not DebuffsShown[debuff] ) ) then
			OneHitWonder_Print(debuff);
			DebuffsShown[debuff] = true;
		end
	end
end

function OneHitWonder_DumpTargetBuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitBuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpTargetDebuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpOwnBuffs()
	local texture, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			texture = GetPlayerBuffTexture(buffIndex);
			OneHitWonder_Print(texture);
		end
	end
end

function OneHitWonder_AddActionToQueue(actionId, actionParameter)
	local entry = { actionId, actionParameter};
	table.insert(OneHitWonder_ActionQueue, entry);
end

function OneHitWonder_RemoveActionFromQueue(actionId, actionParameter)
	local entry = table.remove(OneHitWonder_ActionQueue);
	return entry[1], entry[2];
end

-- /script PrintTable(OneHitWonder_ActionQueue);

function OneHitWonder_HandleActionQueue()
	if ( getn(OneHitWonder_ActionQueue) <= 0 ) then
		return false;
	end
	
	local actionId, actionParameter = OneHitWonder_RemoveActionFromQueue();
	
	if ( actionId == ONEHITWONDER_ACTIONID_SPELL ) then
		if ( OneHitWonder_CastSpell(actionParameter, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			return true;
		else
			return false;
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_TIMEOUT ) then
		local spellId = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			if ( OneHitWonder_IsSpellAvailable(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
					return true;
				else
					return false;
				end
			else
				OneHitWonder_AddActionToQueue(actionId, actionParameter);
				return false;
			end
		end
	else
		return false;
	end
end

function OneHitWonder_Rogue(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if ( OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_STEALTH_TEXTURE) ) then
		local spellId = 0;
		if ( ( not TargetFrame.hasBeenPickPocketed ) ) then
		
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PICKPOCKET_NAME);

			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				-- should be replaced for check for "No pockets to pick" and "You loot XYZ Copper" at a latter stage
				TargetFrame.hasBeenPickPocketed = true;
			end
			return;
		else
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_AMBUSH_NAME);
			if ( spellId <= 0 ) then
				spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BACKSTAB_NAME);
			end
		end
		OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
		return;
	end

	local comboPoints = GetComboPoints();
	
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local comboPointsNeeded = OneHitWonder_GetComboPointsNeededToEviscerate();

	if ( unitHPPercent >= 80 ) then
		if ( ( comboPoints > 0 ) and ( comboPoints <= 2 ) ) then
			if ( not OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_SLICEDICE_TEXTURE) ) then
				if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SLICEDICE_NAME) ) then
					OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SLICEDICE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
				end
				return;
			end
		end
	end	
	
	local abilityName = ONEHITWONDER_ABILITY_EVISCERATE_NAME;

	if ( ( removeDefense ) and ( not OneHitWonder_HasTargetDebuffTexture(ONEHITWONDER_ABILITY_EXPOSEARMOR_TEXTURE) ) ) then
		abilityName = ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME;
	end
	
	if ( comboPoints >= comboPointsNeeded ) then
		if ( OneHitWonder_HasEnoughEnergy(abilityName) ) then
			OneHitWonder_CastSpell(OneHitWonder_GetSpellId(abilityName), ONEHITWONDER_BOOK_TYPE_SPELL);
		end
		return;
	end
	if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME) ) then
		OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
	end
end

function OneHitWonder_OnLoad()
	OneHitWonder_Saved_ChatFrame_OnEvent = ChatFrame_OnEvent;
	ChatFrame_OnEvent = OneHitWonder_ChatFrame_OnEvent;

	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
end

function OneHitWonder_OnEvent(event)
	if ( event == "PLAYER_TARGET_CHANGED" ) then
		TargetFrame.hasBeenPickPocketed = false;
	end
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_ENERGYCOST", ONEHITWONDER_ROGUE_TALENT_ENERGY_REDUCERS);
		elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_RAGECOST", ONEHITWONDER_WARRIOR_TALENT_RAGE_REDUCERS);
		end
	end
end

function OneHitWonder_UpdateRageConsumptionWithTalents(costTableName, reducerTable)
	local costTable = getglobal(costTableName);
	local name, iconTexture, tier, column, rank, maxRank, isExceptional, meetsPrereq;
	local talentTable;
	local abilityName;
	local newCostTable;
	for k, v in reducerTable do
		talentTable = v[1];
		abilityName = v[2];
		newCostTable = v[3];
		name, iconTexture, tier, column, rank, maxRank = GetTalentInfo(talentTable[1], talentTable[2]);
		if ( ( rank > 0 ) and ( rank <= getn(newCostTable) ) ) then
			costTable[abilityName] = newCostTable[rank];
		end
	end
end

--OneHitWonder_Debug = true;

function OneHitWonder_DebugPrint(msg)
	if ( OneHitWonder_Debug ) then
		OneHitWonder_Print(msg, 1.0, 0.3, 0.3);
	end
end

-- Prints out text to a chat box.
function OneHitWonder_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end


function OneHitWonder_ShouldCast(buffTexture, minimalTimeLeft)
	if ( not minimalTimeLeft ) then
		minimalTimeLeft = 0;
	end
	local timeLeft, texture;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex < 0 ) then
			return true;
		end
		texture = GetPlayerBuffTexture(buffIndex);
		if ( texture == buffTexture ) then
			if ( minimalTimeLeft > 0 ) then
				timeLeft = GetPlayerBuffTimeLeft(buffIndex);
				if ( timeLeft < minimalTimeLeft ) then
					return true;
				else
					return false;
				end
			else
				return false;
			end
		end
	end
	return true;
end

function OneHitWonder_Warrior_BattleShoutRefresh()
	if ( OneHitWonder_ShouldCast(ONEHITWONDER_ABILITY_BATTLESHOUT_TEXTURE, 20) ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			OneHitWonder_DebugPrint(format("Battleshout id = %d", spellId));
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return true;
			end
		else
			OneHitWonder_DebugPrint("Not enough rage for BattleShout");
			return true;
		end
	end
	return false;
end

function OneHitWonder_Warrior(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		OneHitWonder_Warrior_BattleShoutRefresh();
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);

	if ( OneHitWonder_IsSpellAvailable(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
		if ( OneHitWonder_CastSpell(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			OneHitWonder_DebugPrint("Charge!");
			return;
		end
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end
	
	if ( OneHitWonder_Warrior_BattleShoutRefresh() ) then
		return;
	end

	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local stance = OneHitWonder_Warrior_GetStance();

	OneHitWonder_DebugPrint(format("Current stance = %d", stance));
	if ( unitHPPercent >= 25 ) then
		if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			if ( not OneHitWonder_HasTargetDebuffTexture(ONEHITWONDER_ABILITY_REND_TEXTURE) ) then
				if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_REND_NAME) ) then
					local spellId = 0;
					spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
					if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
						return;
					end
				else
					return;
				end
			end
		end
	end	

	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME);
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return;
			end
		else
			return;
		end
	end
end

function OneHitWonder_GiveMeWonder(removeDefense)
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		OneHitWonder_Rogue(removeDefense);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		OneHitWonder_Warrior(removeDefense);
	end
end