OneHitWonder_ShouldTryToInterruptSpell = true;
OneHitWonder_UseBlockCounter = true;
OneHitWonder_UseDodgeCounter = true;
OneHitWonder_UseParryCounter = true;
OneHitWonder_ShouldTryToAntiDodge = true;

ONEHITWONDER_ACTIONID_SPELL = 1;
ONEHITWONDER_ACTIONID_SPELL_TIMEOUT = 2;

OneHitWonder_ActionQueue = {};

OneHitWonder_Enabled = true;


OneHitWonder_EnergyReservation = 0;

OneHitWonder_RageReservation = 0;


--OneHitWonder_Saved_ChatFrame_OnEvent = nil;

OneHitWonder_WaitForFeedBack = false;
OneHitWonder_WaitForFeedBackTimeout = 0;
OneHitWonder_WaitForFeedBackDefaultTimeout = 2;
OneHitWonder_ChatFeedBack = "";

-- verify this
ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES = {
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
	"SPELL_CREATURE_VS_CREATURE_DAMAGE",
	"SPELL_CREATURE_VS_CREATURE_BUFF"
};

ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES = {
	"COMBAT_SELF_HITS",
	"COMBAT_SELF_MISSES",
	"COMBAT_CREATURE_VS_SELF_HITS",
	"COMBAT_CREATURE_VS_SELF_MISSES"
};

ONEHITWONDER_CLASS_ROGUE = "Rogue";
ONEHITWONDER_CLASS_SHAMAN = "Shaman";
ONEHITWONDER_CLASS_WARRIOR = "Warrior";

ONEHITWONDER_WARRIOR_STANCE_BATTLE = 1;
ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE = 2;
ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE = 3;
ONEHITWONDER_WARRIOR_STANCE_BERSERK = 4;

function OneHitWonder_ShowBigMessage(msg)
    ZoneTextString:SetText(msg);
    ZoneTextString:SetTextColor(1.0, 0.2, 0.2);
    ZoneTextFrame.startTime = GetTime();
    ZoneTextFrame:Show();
    PlaySound("MapPing");
end

function OneHitWonder_IsTargetedUnit(name)
	if ( UnitName("target") == name ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_ExtractUnitNameFromCombatMessage(msg, source, stringAfterName)
	if ( ( source ) and ( strlen(source) > 0 ) ) then 
		return source;
	else
		local index = strfind(msg, stringAfterName);
		if ( index ~= nil ) then
			local tmpStr = strsub(msg, 1, index-2);
			local cutAwayStr = "%. "; -- sigh. damn patterns
			index = strfind(tmpStr, cutAwayStr);
			if ( index ) then
				tmpStr = strsub(tmpStr, index+2);
			end
			return tmpStr;
		else
			return "";
		end
	end
end

function OneHitWonder_Warrior_GetStance()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				if ( numForms == 1 ) then
					return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
				elseif ( numForms == 2 ) then
					if ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					end
				elseif ( numForms == 3 ) then
					if ( i == 3 ) then	
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					end
				elseif ( numForms == 4 ) then
					if ( i == 4 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 3 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_BERSERK;
					end
				end
			end
		end
	end
	return -1;
end

function OneHitWonder_Warrior_GetGameStanceId(stanceId)
	local numForms = GetNumShapeshiftForms();
	if ( numForms == 1 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 1;
		end
	elseif ( numForms == 2 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 1;
		end
	elseif ( numForms == 3 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 1;
		end
	elseif ( numForms == 4 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 4;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
			return 1;
		end
	end
	return -1;
end

function OneHitWonder_TryToInterruptSpell()
	local interruptId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_KICK_NAME);
		if ( interruptId > -1 ) then
			OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_KICK_NAME));
		end
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_SHAMAN ) then
		interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_EARTHSHOCK_NAME, "highest");
		if ( interruptId > -1 ) then
			OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_EARTHSHOCK_NAME));
		end
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		-- this gets tricky
		local stance = OneHitWonder_Warrior_GetStance();
		if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
			if ( interruptId > -1 ) then
				OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_PUMMEL_NAME));
			end
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SHIELDBASH_NAME);
			if ( interruptId > -1 ) then
				OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_SHIELDBASH_NAME));
			end
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
			if ( interruptId > -1 ) then
				OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_PUMMEL_NAME));
			end
		elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
			interruptId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PUMMEL_NAME);
			if ( interruptId > -1 ) then
				OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_PUMMEL_NAME));
			end
		end
	end
	if ( interruptId > -1 ) then
		local parameters = { interruptId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_GetWarriorBlockDodgeParryCounter()
	local counterId = -1;
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REVENGE_NAME);
		if ( counterId > -1 ) then
			OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_REVENGE_NAME));
		end
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId;
end

function OneHitWonder_GetWarriorTargetDodgeCounter()
	local counterId = -1;
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_OVERPOWER_NAME);
		if ( counterId > -1 ) then
			OneHitWonder_ShowBigMessage(format(COOLDOWNCOUNT_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_OVERPOWER_NAME));
		end
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId;
end


function OneHitWonder_DoBlockCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoDodgeCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoParryCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_RIPOSTE_NAME);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoTargetDodgeCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorTargetDodgeCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end


function OneHitWonder_ChatFrame_OnEvent(event)
	if ( arg1 ) then
		if ( strfind(arg1, "dodges") ) then
			unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "dodges");
			if ( (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToAntiDodge ) ) then
				--OneHitWonder_DoTargetDodgeCounter();
			end
			if ( strfind(arg1, "You attack") ) then
				if (not unitName ) then
					unitName = "nil";
				end
				--Print(format("Found the event : %s   Extracted unitname : %s", event, unitName));
			end
		end
	end
	OneHitWonder_Saved_ChatFrame_OnEvent(event);
end

function OneHitWonder_Chat_OnEvent(event)
	if ( OneHitWonder_Enabled ) then
		if ( strsub(event, 1, 8) == "CHAT_MSG" ) then
			local typeOfEvent = strsub(event, 10);
			local info = ChatTypeInfo[type];
			local unitName = nil;
			if ( strfind(arg1, "begins to cast" ) ) then
				unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "begins to cast");
				if ( (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToInterruptSpell ) ) then
					local shouldInterrupt = false;
					for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
						if ( strfind(typeOfEvent, v) ) then
							shouldInterrupt = true;
						end
					end
					if ( shouldInterrupt ) then
						OneHitWonder_TryToInterruptSpell();
					end
				end
			end
			if ( strfind(arg1, "dodges") ) then
				unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "dodges");
				if ( ( strfind(arg1, "dodges" ) ) and (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToAntiDodge ) ) then
					OneHitWonder_DoTargetDodgeCounter();
				end
			end
			if ( ( OneHitWonder_UseParryCounter ) and ( strfind(arg1, "You parry") ) ) then
				OneHitWonder_DoParryCounter();
			end
			if ( ( OneHitWonder_UseBlockCounter ) and ( strfind(arg1, "You block") ) ) then
				OneHitWonder_DoBlockCounter();
			end
			if ( ( OneHitWonder_UseDodgeCounter ) and ( strfind(arg1, "You dodge") ) ) then
				OneHitWonder_DoDodgeCounter();
			end
		end
	end
end

function OneHitWonder_HasTargetBuffTexture(texture)
	local buff;
	for i=1, MAX_TARGET_DEBUFFS do
		buff = UnitBuff("target", i);
		if ( buff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetDebuffTexture(texture)
	local debuff;
	local i = 0;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetAnyBuffTexture(texture)
	if ( OneHitWonder_HasTargetBuffTexture(texture) ) then
		return true;
	else
		return OneHitWonder_HasTargetDebuffTexture(texture);
	end
end

function OneHitWonder_HasBuffTexture(texture)
	local id = 1;
	for id = 1, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

ONEHITWONDER_BOOK_TYPE_SPELL = "spell";

function OneHitWonder_GetRankAsNumber(rankName)
	if ( rankName ) then
		local index, index2 = strfind(rankName, "Rank");
		if ( ( index ) and (index2 ) ) then
			local tmpStr = strsub(rankName, index2+1);
			while ( ( tmpStr) and ( strlen(tmpStr) > 1 ) and ( strsub(tmpStr, 1, 1) == " " ) ) do
				tmpStr = strsub(tmpStr, 2);
			end
			local i = tonumber(tmpStr);
			if ( i ) then
				return i;
			else
				return 0;
			end
		else
			return 0;
		end
	else
		return 0;
	end
end

function OneHitWonder_GetSpellId(spellName, spellRank)
	local i = 1;
	local highestId = -1;
	local highestRankSoFar = -1;
	local rank;
	local spellRankNumber = 0;
	if (spellRank) then
		spellRankNumber = tonumber(spellRank);
		if (spellRankNumber) then
			spellRankNumber = 0;
		end
	end
	local name, rankName;
	name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	while name do
		if ( name == spellName) then
			if ( spellRank == nil ) then
				return i;
			else
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank == spellRankNumber ) then
					highestId = i;
					break;
				elseif ( rank > highestRankSoFar ) then
					highestId = i;
				end
			end
		end
		i = i + 1;
		name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	end
	return highestId;
end

function OneHitWonder_HasEnoughEnergy(abilityName, ignoreEnergyReservation)
	local energy = PlayerFrameManaBar:GetValue();
	
	if ( not ignoreEnergyReservation ) then
		energy = energy - OneHitWonder_EnergyReservation;
	end

	if ( OneHitWonder_GetEnergyConsumption(abilityName) <= energy ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasEnoughRage(abilityName, ignoreRageReservation)
	local rage = PlayerFrameManaBar:GetValue();

	if ( not ignoreRageReservation ) then
		rage = rage - OneHitWonder_RageReservation;
	end

	if ( OneHitWonder_GetRageConsumption(abilityName) <= rage ) then
		return true;
	else
		return false;
	end
end


function OneHitWonder_GetActionId(texture)
	if ( texture ) then
		local id = 1;
		local actionTexture;
		for id = 1, 120 do
			actionTexture = GetActionTexture(id);
			if ( ( actionTexture ) and ( actionTexture == texture ) ) then
				return id;
			end
		end
	end
	return -1;
end

function OneHitWonder_GetSpellBook(spellBook)
	if ( not spellBook ) then spellBook = ONEHITWONDER_BOOK_TYPE_SPELL; end;
	return spellBook;
end

function OneHitWonder_CheckIfInRangeSpellId(id, spellBook)
	local actionId = 0;
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	actionId = OneHitWonder_GetActionId(GetSpellTexture(id, spellBook));
	return OneHitWonder_CheckIfInRangeActionId(actionId);
end

function OneHitWonder_CheckIfInRangeActionId(id)
	if ( ( id > -1) and ( IsActionInRange(id) == 0) ) then
		return false;
	else	
		return true;
	end
end

function OneHitWonder_CheckIfUsableActionId(id)
	if ( id > -1) then
		local isUsable, notEnoughMana = IsUsableAction(id);
		if ( ( isUsable ) and ( not notEnoughMana ) )  then
			return true;
		else
			return false;
		end
	else	
		return true;
	end
end

function OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook)
	if ( id == -1 ) then
		return true;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(id, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) ) then
			return false;
		end
	end
	return true;
end

function OneHitWonder_CheckIfUsable(actionId, spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( spellId > -1 ) then
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(spellId, spellBook) ) then
			return false;
		end
	end
	return OneHitWonder_CheckIfUsableActionId(actionId);
end

function OneHitWonder_CheckIfUsableSpellId(id, spellBook)
	if ( id == -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local actionId = 0;
	if ( not OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook) ) then
		actionId = OneHitWonder_GetActionId(GetSpellTexture(id, spellBook));
		return OneHitWonder_CheckIfUsableActionId(actionId);
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBar(texture)
	if ( texture ) then
		local id = OneHitWonder_GetActionId(texture);
		if ( (OneHitWonder_CheckIfUsableActionId(id) ) and ( OneHitWonder_CheckIfInRangeActionId(id) ) ) then
			return true;
		else
			return false;
		end
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBarByActionId(actionId)
	if ( (OneHitWonder_CheckIfUsableActionId(actionId) ) and ( OneHitWonder_CheckIfInRangeActionId(actionId) ) ) then
		return true;
	else
		return false;
	end
end

-- /script PrintTable(OneHitWonder_SpellAvailability);
-- /script OneHitWonder_SpellAvailability = {};

OneHitWonder_SpellAvailability = {};

function OneHitWonder_Log(spellId, spellBook, start, duration, enable)
	if ( spellId <= -1 ) then
		return
	end
	if ( enable == 0 ) then
		return;
	end
	if ( not OneHitWonder_SpellAvailability[spellId]) then
		OneHitWonder_SpellAvailability[spellId] = {};
	end
	local currentTime = GetTime() * 1000;
	local cooldownTime = start * 1000 + duration * 1000;
	local available = "true";
	if ( cooldownTime > currentTime ) then
		available = "false";
	end
	local parameter = {start, duration, enable, GetTime(), available};
	table.insert(OneHitWonder_SpellAvailability[spellId], parameter);
end

function OneHitWonder_IsSpellAvailable(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) )then
			if ( OneHitWonder_CheckIfInRangeAndUsableInActionBar(GetSpellTexture(spellId, spellBook)) ) then
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_CastSpell(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( OneHitWonder_IsSpellAvailable(spellId, spellBook) ) then
		CastSpell(spellId, spellBook);
		return true;
	end
	return false;
end

function OneHitWonder_GetTargetHPPercentage()
	local unitMinHP, unitMaxHP, unitCurrHP;
	unitMinHP, unitMaxHP = TargetFrameHealthBar:GetMinMaxValues();
	unitCurrHP = TargetFrameHealthBar:GetValue();
	
	local unitHPPercent = TargetFrame.unitHPPercent;

	if ( not UnitIsPlayer("target") ) then
		unitHPPercent = unitCurrHP;
	else
		unitHPPercent = math.floor(unitHPPercent * 100);
	end
	return unitHPPercent;
end

function OneHitWonder_WiggleStop()
	MoveForwardStop();
end

function OneHitWonder_Wiggle()
	if ( CosmosSchedule ) then
		MoveForwardStart();
		CosmosSchedule(0.2, OneHitWonder_WiggleStop);
	end
end

function OneHitWonder_GetComboPointsNeededToEviscerate()
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
	local playerLevel = UnitLevel("player");
	local targetLevel = UnitLevel("target");
	if ( targetLevel - playerLevel > 5 ) then
		-- does not matter, you're not going to do something good with it anyhow
		return 1;
	end
	if ( playerLevel - targetLevel >= 10 ) then
		-- will prolly kill it quick
		return 1;
	end
	if ( playerLevel - targetLevel >= 5 ) then
		if ( unitHPPercent <= 15 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 3;
		end
	end
	if ( playerLevel - targetLevel >= 3 ) then
		if ( unitHPPercent <= 20 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 4;
		end
	end
	if ( playerLevel - targetLevel >= -1 ) then
		if ( unitHPPercent <= 25 ) then
			return 1;
		elseif ( unitHPPercent <= 40 ) then
			return 2;
		elseif ( unitHPPercent <= 50 ) then
			return 3;
		else
			return 5;
		end
	else
		if ( unitHPPercent <= 10 ) then
			return 2;
		elseif ( unitHPPercent <= 25 ) then
			return 3;
		elseif ( unitHPPercent <= 50 ) then
			return 4;
		else
			return 5;
		end
	end
end

function OneHitWonder_HasPartyMembers()
	local partyMembers = 0;
	
	for i=1, MAX_PARTY_MEMBERS, 1 do
		if ( GetPartyMember(i) ) then
			partyMembers = partyMembers + 1;
		end
	end
	if ( partyMembers > 0 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_DumpDebuffsOnce()
	if ( not DebuffsShown ) then
		DebuffsShown = {};
	end
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) and ( not DebuffsShown[debuff] ) ) then
			OneHitWonder_Print(debuff);
			DebuffsShown[debuff] = true;
		end
	end
end

function OneHitWonder_DumpTargetBuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitBuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpTargetDebuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpOwnBuffs()
	local texture, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			texture = GetPlayerBuffTexture(buffIndex);
			OneHitWonder_Print(texture);
		end
	end
end

function OneHitWonder_GetBuffNameUsingBuffIndex(buffIndex)
	if (buffIndex ~= -1) then
		OneHitWonderTooltip:SetPlayerBuff(buffIndex);
		local tooltiptext = getglobal("OneHitWonderTooltipTextLeft1");
		if ( tooltiptext ) then
			local name = tooltiptext:GetText();
			if ( name ~= nil ) then
				return name;
			end
		end
	end
	return nil;
end

function OneHitWonder_DumpOwnBuffNames()
	local name, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			name = OneHitWonder_GetBuffNameUsingBuffIndex(buffIndex);
			if ( name ) then
				OneHitWonder_Print(name);
			end
		end
	end
end

function OneHitWonder_AddActionToQueue(actionId, actionParameter)
	local entry = { actionId, actionParameter};
	table.insert(OneHitWonder_ActionQueue, entry);
end

function OneHitWonder_RemoveActionFromQueue(actionId, actionParameter)
	local entry = table.remove(OneHitWonder_ActionQueue);
	return entry[1], entry[2];
end

-- /script PrintTable(OneHitWonder_ActionQueue);
function OneHitWonder_GetTimeRemaining(spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	if ( ( start > 0 ) and ( duration > 0 ) ) then
		return (( start + duration ) - GetTime());
	else
		return 0;
	end
end

function OneHitWonder_UseCountermeasures()
	OneHitWonder_HandleActionQueue();
end

function OneHitWonder_HandleActionQueue()
	if ( getn(OneHitWonder_ActionQueue) <= 0 ) then
		return false;
	end
	
	local actionId, actionParameter = OneHitWonder_RemoveActionFromQueue();
	
	if ( actionId == ONEHITWONDER_ACTIONID_SPELL ) then
		if ( OneHitWonder_CastSpell(actionParameter, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			return true;
		else
			return false;
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_TIMEOUT ) then
		local spellId = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			if ( OneHitWonder_IsSpellAvailable(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
					return true;
				else
					return false;
				end
			else
				OneHitWonder_AddActionToQueue(actionId, actionParameter);
				local remainingTime = OneHitWonder_GetTimeRemaining(spellId, ONEHITWONDER_BOOK_TYPE_SPELL );
				if ( remainingTime <= 1 ) then
					return true;
				end
				return false;
			end
		end
	else
		return false;
	end
end

function OneHitWonder_Rogue(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if ( OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_STEALTH_TEXTURE) ) then
		local spellId = 0;
		if ( ( not TargetFrame.hasBeenPickPocketed ) ) then
		
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PICKPOCKET_NAME);

			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				-- should be replaced for check for "No pockets to pick" and "You loot XYZ Copper" at a latter stage
				TargetFrame.hasBeenPickPocketed = true;
			end
			return;
		else
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_AMBUSH_NAME);
			if ( spellId <= 0 ) then
				spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BACKSTAB_NAME);
			end
		end
		OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
		return;
	end

	local comboPoints = GetComboPoints();
	
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local comboPointsNeeded = OneHitWonder_GetComboPointsNeededToEviscerate();

	if ( unitHPPercent >= 80 ) then
		if ( ( comboPoints > 0 ) and ( comboPoints <= 2 ) ) then
			if ( not OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_SLICEDICE_TEXTURE) ) then
				if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SLICEDICE_NAME) ) then
					OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SLICEDICE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
				end
				return;
			end
		end
	end	
	
	local abilityName = ONEHITWONDER_ABILITY_EVISCERATE_NAME;

	if ( ( removeDefense ) and ( not OneHitWonder_HasTargetDebuffTexture(ONEHITWONDER_ABILITY_EXPOSEARMOR_TEXTURE) ) ) then
		abilityName = ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME;
	end
	
	if ( comboPoints >= comboPointsNeeded ) then
		if ( OneHitWonder_HasEnoughEnergy(abilityName) ) then
			OneHitWonder_CastSpell(OneHitWonder_GetSpellId(abilityName), ONEHITWONDER_BOOK_TYPE_SPELL);
		end
		return;
	end
	if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME) ) then
		OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
	end
end

function OneHitWonder_OnLoad()
	--OneHitWonder_Saved_ChatFrame_OnEvent = ChatFrame_OnEvent;
	--ChatFrame_OnEvent = OneHitWonder_ChatFrame_OnEvent;

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end

	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
end

function OneHitWonder_OnEvent(event)
	if ( event == "PLAYER_TARGET_CHANGED" ) then
		TargetFrame.hasBeenPickPocketed = false;
	end
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_ENERGYCOST", ONEHITWONDER_ROGUE_TALENT_ENERGY_REDUCERS);
		elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_RAGECOST", ONEHITWONDER_WARRIOR_TALENT_RAGE_REDUCERS);
		end
	end
	if ( strfind(event, "CHAT_MSG") ) then
		OneHitWonder_Chat_OnEvent(event);
	end
end

function OneHitWonder_UpdateRageConsumptionWithTalents(costTableName, reducerTable)
	local costTable = getglobal(costTableName);
	local name, iconTexture, tier, column, rank, maxRank, isExceptional, meetsPrereq;
	local talentTable;
	local abilityName;
	local newCostTable;
	for k, v in reducerTable do
		talentTable = v[1];
		abilityName = v[2];
		newCostTable = v[3];
		name, iconTexture, tier, column, rank, maxRank = GetTalentInfo(talentTable[1], talentTable[2]);
		if ( ( rank > 0 ) and ( rank <= getn(newCostTable) ) ) then
			costTable[abilityName] = newCostTable[rank];
		end
	end
end

--OneHitWonder_Debug = true;

function OneHitWonder_DebugPrint(msg)
	if ( OneHitWonder_Debug ) then
		OneHitWonder_Print(msg, 1.0, 0.3, 0.3);
	end
end

-- Prints out text to a chat box.
function OneHitWonder_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end


function OneHitWonder_GetTimeLeft(buffTexture)
	local timeLeft, texture;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex < 0 ) then
			return 0;
		end
		texture = GetPlayerBuffTexture(buffIndex);
		if ( texture == buffTexture ) then
			timeLeft = GetPlayerBuffTimeLeft(buffIndex);
			return timeLeft;
		end
	end
	return 0;
end

function OneHitWonder_ShouldCast(buffTexture, minimalTimeLeft)
	if ( not minimalTimeLeft ) then
		minimalTimeLeft = 0;
	end
	local timeLeft = OneHitWonder_GetTimeLeft(buffTexture);
	if ( minimalTimeLeft > 0 ) then
		timeLeft = GetPlayerBuffTimeLeft(buffIndex);
		if ( timeLeft < minimalTimeLeft ) then
			return true;
		else
			return false;
		end
	else
		return false;
	end
	return true;
end

OneHitWonder_Warrior_BattleShoutRageReservation = 0;
OneHitWonder_Warrior_BattleShoutStartRageReservation = 30;

function OneHitWonder_Warrior_BattleShoutRefresh()
	local timeLeft = OneHitWonder_GetTimeLeft(ONEHITWONDER_ABILITY_BATTLESHOUT_TEXTURE);
	OneHitWonder_RageReservation = OneHitWonder_RageReservation - OneHitWonder_Warrior_BattleShoutRageReservation;
	OneHitWonder_Warrior_BattleShoutRageReservation = 0;
	if ( timeLeft < OneHitWonder_Warrior_BattleShoutStartRageReservation ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME, true) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			OneHitWonder_DebugPrint(format("Battleshout id = %d", spellId));
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return true;
			end
		else
			OneHitWonder_DebugPrint("Not enough rage for BattleShout");
			OneHitWonder_DebugPrint("Allocating rage for BattleShout");
			OneHitWonder_Warrior_BattleShoutRageReservation = OneHitWonder_Warrior_BattleShoutStartRageReservation - timeLeft;
			local maxRageReserved = OneHitWonder_GetRageConsumption(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			if ( OneHitWonder_Warrior_BattleShoutRageReservation > maxRageReserved) then
				OneHitWonder_Warrior_BattleShoutRageReservation = maxRageReserved;
			end
			OneHitWonder_RageReservation = OneHitWonder_RageReservation + OneHitWonder_Warrior_BattleShoutRageReservation;
		end
	end
	return false;
end

ONEHITWONDER_WARRIOR_RANGE_UNKNOWN = 0;
ONEHITWONDER_WARRIOR_RANGE_MELEE = 1;
ONEHITWONDER_WARRIOR_RANGE_CHARGE = 2;
ONEHITWONDER_WARRIOR_RANGE_RANGED = 3;
ONEHITWONDER_WARRIOR_RANGE_BEYOND = 4;

function OneHitWonder_Warrior_GetCurrentRange()
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);
		local rangedId = -1;
		local meleeRangeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
		if ( meleeRangeId <= -1 ) then OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HAMSTRING_NAME); end

		if ( not OneHitWonder_CheckIfInRangeSpellId(chargeId) ) then
			if (not OneHitWonder_CheckIfInRangeSpellId(meleeRangeId)) then
				if ( rangedId > -1 ) then
					if (not OneHitWonder_CheckIfInRangeSpellId(rangedId)) then
						return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
					else
						return ONEHITWONDER_WARRIOR_RANGE_RANGED;
					end
				else
					return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
				end
			else
				return ONEHITWONDER_WARRIOR_RANGE_MELEE;
			end
		else
			return ONEHITWONDER_WARRIOR_RANGE_CHARGE;
		end
	end
	return ONEHITWONDER_WARRIOR_RANGE_UNKNOWN;
end

function OneHitWonder_Warrior(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		OneHitWonder_Warrior_BattleShoutRefresh();
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		OneHitWonder_DebugPrint("Handled Action Queue");
		return;
	end

	local stance = OneHitWonder_Warrior_GetStance();

	OneHitWonder_DebugPrint(format("Current stance = %d", stance));

	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);
		
		local chargeTexture = nil;
		local chargeActionId = -1;
		if ( chargeId > -1 ) then
			chargeTexture = GetSpellTexture(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL);
			chargeActionId = OneHitWonder_GetActionId(chargeTexture);
		end
		
		if ( chargeActionId > -1 ) then
			if ( OneHitWonder_CheckIfInRangeActionId(chargeActionId) ) then
				--Print("In range for Charge.");
				if ( OneHitWonder_CheckIfUsable(chargeActionId, chargeId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
					--Print("Charge!");
					CastSpell(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL);
					return;
				else
					--Print("Charge not available.");
					return;
				end
			else
				--Print("Not in range for Charge.");
				local currentRange = OneHitWonder_Warrior_GetCurrentRange();
				if ( ( PlayerFrame.inCombat ~= 1 ) and (currentRange ~= ONEHITWONDER_WARRIOR_RANGE_MELEE) ) then
					--Print("Not in combat and not close enough - postponing attempt.");
					--Print("Range is "..currentRange);
					return;
				end
			end
		else
			if ( OneHitWonder_CastSpell(chargeId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				return;
			end
		end
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end
	
	if ( OneHitWonder_Warrior_BattleShoutRefresh() ) then
		return;
	end

	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	if ( unitHPPercent >= 25 ) then
		if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			if ( not OneHitWonder_HasTargetDebuffTexture(ONEHITWONDER_ABILITY_REND_TEXTURE) ) then
				if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_REND_NAME) ) then
					local spellId = 0;
					spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
					if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
						return;
					end
				else
					return;
				end
			end
		end
	end	

	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HEROICSTRIKE_NAME);
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return;
			end
		else
			return;
		end
	end
end

function OneHitWonder_GiveMeWonder(removeDefense)
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		OneHitWonder_Rogue(removeDefense);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_SHAMAN ) then
		OneHitWonder_UseCountermeasures();
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		OneHitWonder_Warrior(removeDefense);
	else
		if ( not OneHitWonder_NoWonder ) then
			OneHitWonder_Print("Sorry, no wonder for you yet.");
			OneHitWonder_NoWonder = true;
		end
	end
end


