ONEHITWONDER_SPELL_HAMMER_OF_JUSTICE_NAME = "Hammer of Justice";

ONEHITWONDER_SPELL_BLESSING_OF_KINGS_NAME = "Blessing of Kings";
ONEHITWONDER_SPELL_BLESSING_OF_LIGHT_NAME = "Blessing of Light";
ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME = "Blessing of Might";
ONEHITWONDER_SPELL_BLESSING_OF_PROTECTION_NAME = "Blessing of Protection";
ONEHITWONDER_SPELL_BLESSING_OF_SANCTUARY_NAME = "Blessing of Sanctuary";
ONEHITWONDER_SPELL_BLESSING_OF_SALVATION_NAME = "Blessing of Salvation";
ONEHITWONDER_SPELL_BLESSING_OF_WISDOM_NAME = "Blessing of Wisdom";

ONEHITWONDER_SPELL_JUDGEMENT_NAME = "Judgement";

ONEHITWONDER_SPELL_SEAL_OF_COMMAND_NAME = "Seal of Command";
ONEHITWONDER_SPELL_SEAL_OF_FURY_NAME = "Seal of Fury";
ONEHITWONDER_SPELL_SEAL_OF_JUSTICE_NAME = "Seal of Justice";
ONEHITWONDER_SPELL_SEAL_OF_LIGHT_NAME = "Seal of Light";
ONEHITWONDER_SPELL_SEAL_OF_RIGHTEOUSNESS_NAME = "Seal of Righteousness";
ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_JUDGEMENT_EFFECT = "Judgement of the Crusader";
ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_NAME = "Seal of the Crusader";
ONEHITWONDER_SPELL_SEAL_OF_WISDOM_NAME = "Seal of Wisdom";


function OneHitWonder_PaladinMoreThanOnePaladinInGroup()
	local nr = OneHitWonder_GetNumberOfClassInGroup(ONEHITWONDER_CLASS_PALADIN);
	if ( ( nr ) and ( nr > 1 ) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_GetCurrentSeal()
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
			if ( strfind(buffName, "Seal") ) then
				return buffName;
			end
		end
	end
	return nil;
end

function OneHitWonder_Paladin_GetDesiredJugdementSealSpellName()
	local spellName = ONEHITWONDER_SPELL_SEAL_OF_RIGHTEOUSNESS_NAME;
	if ( 
		( OneHitWonder_PaladinMoreThanOnePaladinInGroup() ) 
		and ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_JUDGEMENT_EFFECT) ) ) then
		spellName = ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_NAME;
	end
	return spellName;
end

function OneHitWonder_Paladin_GetDesiredPoundingSealSpellName()
	local spellName = ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_NAME;
	if ( OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_JUDGEMENT_EFFECT) ) then
		spellName = ONEHITWONDER_SPELL_SEAL_OF_RIGHTEOUSNESS_NAME;
	end
	return spellName;
end
function OneHitWonder_Paladin(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) or ( ( not UnitCanAttack("target", "player") ) ) ) then
		if ( not OneHitWonder_DoBuffs() ) then
			OneHitWonder_UseCountermeasures();
		end
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end
	local judgmentId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_JUDGEMENT_NAME);
	if ( judgmentId <= -1 ) then
		local spellName = ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_NAME;
		local spellId = OneHitWonder_GetSpellId(spellName);
		if ( spellId <= -1 ) then
			spellName = ONEHITWONDER_SPELL_SEAL_OF_RIGHTEOUSNESS_NAME; 
			spellId = OneHitWonder_GetSpellId(spellName);
		end
		if ( spellId > -1 ) then
			if ( not OneHitWonder_HasPlayerEffect(nil, spellName) ) then
				OneHitWonder_CastSpell(spellId);
				return;
			end
		end
	else
		local spellBook = OneHitWonder_GetSpellBook(spellBook);
		local isJudgementAvailable = OneHitWonder_IsSpellAvailable(judgmentId);
		local start, duration, enable = GetSpellCooldown(judgmentId, spellBook);
		local currentSeal = OneHitWonder_GetCurrentSeal();
		
		local spellName = ONEHITWONDER_SPELL_SEAL_OF_THE_CRUSADER_NAME;
		local spellId = -1;
		if ( not currentSeal ) then
			if ( start == 0 ) then
				spellName = OneHitWonder_Paladin_GetDesiredJugdementSealSpellName();
			else
				spellName = OneHitWonder_Paladin_GetDesiredPoundingSealSpellName();
			end
		elseif ( isJudgementAvailable ) then
			spellName = OneHitWonder_Paladin_GetDesiredJugdementSealSpellName();
			if ( spellName == currentSeal ) then
				spellName = ONEHITWONDER_SPELL_JUDGEMENT_NAME;
			end
		else
			spellName = nil;
		end
		if ( spellName ) then
			spellId = OneHitWonder_GetSpellId(spellName);
		end
		if ( spellId > -1 ) then
			OneHitWonder_CastSpell(spellId);
			return;
		end
	end
	if ( not OneHitWonder_DoBuffs() ) then
		OneHitWonder_UseCountermeasures();
	end
	return;
end


function OneHitWonder_SetupStuffContinously_Paladin()
	--[[
	local wisdomId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_BLESSING_OF_WISDOM_NAME);
	local salvationId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_BLESSING_OF_SALVATION_NAME);
	]]--
	
	local bestMeleeBlessing = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	local bestCasterBlessing = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	local bestCasterBlessingTarget = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	local bestDruidCasterBlessing = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	local bestDruidTankBlessing = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	local bestDruidDPSBlessing = ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME;
	
	bestCasterBlessing = { ONEHITWONDER_SPELL_BLESSING_OF_WISDOM_NAME, ONEHITWONDER_SPELL_BLESSING_OF_SALVATION_NAME, ONEHITWONDER_SPELL_BLESSING_OF_KINGS_NAME, ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME };
	bestDruidCasterBlessing = { ONEHITWONDER_SPELL_BLESSING_OF_WISDOM_NAME, ONEHITWONDER_SPELL_BLESSING_OF_SALVATION_NAME, ONEHITWONDER_SPELL_BLESSING_OF_KINGS_NAME, ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME };
	
	
	OneHitWonder_AddStuffContinously(bestMeleeBlessing, false, true, {onlyBuffClass = {"Warrior"}});
	OneHitWonder_AddStuffContinously(bestMeleeBlessing, false, true, {onlyBuffClass = {"Rogue"}});
	OneHitWonder_AddStuffContinously({ ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME, ONEHITWONDER_SPELL_BLESSING_OF_WISDOM_NAME, ONEHITWONDER_SPELL_BLESSING_OF_KINGS_NAME }, false, true, {onlyBuffClass = {"Paladin"}});
	OneHitWonder_AddStuffContinously(bestDruidCasterBlessing, false, true, {onlyBuffClass = {"Druid"}, powerType = { ONEHITWONDER_POWERTYPE_MANA} });
	OneHitWonder_AddStuffContinously(bestDruidDPSBlessing, false, true, {onlyBuffClass = {"Druid"}, powerType = { ONEHITWONDER_POWERTYPE_ENERGY} });
	OneHitWonder_AddStuffContinously(bestDruidTankBlessing, false, true, {onlyBuffClass = {"Druid"}, powerType = { ONEHITWONDER_POWERTYPE_RAGE} });
	OneHitWonder_AddStuffContinously(bestCasterBlessing, false, true, {onlyBuffClass = OneHitWonder_CasterClassesArray, invalidUnit = {"target"} });
	OneHitWonder_AddStuffContinously(bestCasterBlessingTarget, false, true, {onlyBuffClass = OneHitWonder_CasterClassesArray, validUnit = {"target"}});
end

function OneHitWonder_Paladin_GetHighestStunSpellName()
	return ONEHITWONDER_SPELL_HAMMER_OF_JUSTICE_NAME;
end

function OneHitWonder_TryToInterruptSpell_Paladin(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	abilityName = OneHitWonder_Paladin_GetHighestStunSpellName();
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName, "highest");
		if ( not OneHitWonder_IsSpellAvailable(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return abilityName, interruptId;
end

