ONEHITWONDER_ABILITY_FROST_WARD_NAME = "Frost Ward";
ONEHITWONDER_ABILITY_FIRE_WARD_NAME = "Fire Ward";

ONEHITWONDER_ABILITY_ARCANE_INTELLECT_NAME = "Arcane Intellect";
ONEHITWONDER_ABILITY_FROST_ARMOR_NAME = "Frost Armor";
ONEHITWONDER_ABILITY_ICE_ARMOR_NAME = "Ice Armor";

OneHitWonder_Mage_ShouldBuffNonCastersIntellect = 0;
OneHitWonder_Mage_ShouldReactiveCastFireWard = 1;
OneHitWonder_Mage_ShouldReactiveCastFrostWard = 1;
OneHitWonder_Mage_ShouldReactiveCastManaShield = 1;

function OneHitWonder_Mage_SetShouldBuffNonCastersIntellect(toggle)
	OneHitWonder_Mage_ShouldBuffNonCastersIntellect = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFireWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFireWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFrostWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFrostWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastManaShield(toggle)
	OneHitWonder_Mage_ShouldReactiveCastManaShield = toggle;
end


function OneHitWonder_Mage_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_MAGE_SEPARATOR),
			TEXT(ONEHITWONDER_MAGE_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT),
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT_INFO),
			OneHitWonder_Mage_SetShouldBuffNonCastersIntellect,
			OneHitWonder_Mage_ShouldBuffNonCastersIntellect
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFireWard,
			OneHitWonder_Mage_ShouldReactiveCastFireWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFrostWard,
			OneHitWonder_Mage_ShouldReactiveCastFrostWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastManaShield,
			OneHitWonder_Mage_ShouldReactiveCastManaShield
		);
	end
end


function OneHitWonder_Mage_SmartPetAttack()
	return OneHitWonder_SmartPetAttack(OneHitWonder_Mage_ShouldPetAttack);
end


function OneHitWonder_SetupStuffContinously_Mage()
	if ( OneHitWonder_Mage_ShouldBuffNonCastersIntellect == 1 ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_ARCANE_INTELLECT_NAME, false, true);
	else
		OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_ARCANE_INTELLECT_NAME, false, true, {onlyBuffClass = OneHitWonder_ManaClassesArray});
	end
	local armorName = ONEHITWONDER_ABILITY_ICE_ARMOR_NAME;
	if ( OneHitWonder_GetSpellId(armorName) <= 0 ) then
		armorName = ONEHITWONDER_ABILITY_FROST_ARMOR_NAME;
	end
	OneHitWonder_AddStuffContinously(armorName, true, true);
end

function OneHitWonder_TryToInterruptSpell_Mage(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	if ( OneHitWonder_IsSpellFireBased(spellName) ) then
		abilityName = ONEHITWONDER_ABILITY_FIRE_WARD_NAME;
	elseif ( OneHitWonder_IsSpellFrostBased(spellName) ) then
		abilityName = ONEHITWONDER_ABILITY_FROST_WARD_NAME;
	end
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) and ( not OneHitWonder_HasPlayerEffect(nil, abilityName) ) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName);
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return abilityName, interruptId;
end
