ONEHITWONDER_ABILITY_POWER_WORD_FORTITUDE_NAME = "Power Word: Fortitude";
ONEHITWONDER_ABILITY_INNER_FIRE_NAME = "Inner Fire";

function OneHitWonder_SetupStuffContinously_Priest()
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_POWER_WORD_FORTITUDE_NAME] = 25*60;
	--OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_INNER_FIRE_NAME] = 5*60;
	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_POWER_WORD_FORTITUDE_NAME, false, true);
	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_INNER_FIRE_NAME, true, true);
end

function OneHitWonder_Priest_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_PRIEST_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_PRIEST_SEPARATOR),
			TEXT(ONEHITWONDER_PRIEST_SEPARATOR_INFO)
		);
	end
end

function OneHitWonder_Priest(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end
