OneHitWonder_NormalBuffProgression = {
	1, 
	6, 
	18
};

OneHitWonder_BuffSpellList = {
	[ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME] = {
		1,
		6,
		18,
	},
	[ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME] = {
		1,
		6,
		18,
	},

};


function OneHitWonder_GetHighestSpellName(spellName, highestSpellRank, spellBook, doNotUseCache)
	local i = 1;
	local highestId = -1;
	local highestRankSoFar = -1;
	local rank;
	local spellRankNumber = 0;
	if (highestSpellRank) then
		spellRankNumber = tonumber(highestSpellRank);
		if (not spellRankNumber) then
			spellRankNumber = 0;
		end
	end
	if ( not spellBook ) then
		spellBook = OneHitWonder_GetSpellBook();
	end
	local name, rankName;
	name, rankName = OneHitWonder_GetSpellName(i, spellBook, doNotUseCache);
	while name do
		if ( name == spellName) then
			if ( highestSpellRank == nil ) then
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank ) then
					if ( rank > highestRankSoFar ) then
						highestRankSoFar = rank;
						highestId = i;
					end
				else
					return i;
				end
			else
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank == spellRankNumber ) then
					highestId = i;
					highestRankSoFar = rank;
					break;
				elseif ( rank < spellRankNumber ) then
					if ( rank > highestRankSoFar ) then
						highestId = i;
						highestRankSoFar = rank;
					end
				end
			end
		end
		i = i + 1;
		name, rankName = OneHitWonder_GetSpellName(i, spellBook)
	end
	local qwe = highestRankSoFar;
	if ( highestRankSoFar <= 0 ) then
		qwe = nil;
	end
	return spellName, qwe;
end




function OneHitWonder_GetAppropriateBuff(unitLevel, buffName)
	local list = OneHitWonder_BuffSpellList[buffName];
	if ( list ) then
		local highestI = 0;
		for i = getn(list), 1, -1 do
			if ( unitLevel >= list[i] ) then
				highestI = i;
				break;
			end
		end
		return OneHitWonder_GetHighestSpellName(buffName, highestI);
	else
		return OneHitWonder_GetHighestSpellName(buffName);
	end
end