-- contains the current state that the tooltip relocation should be in
RelocateTooltip_TOOLTIP = nil;

-- contains the default state (0 is off, 1 is on, other are more specific)
RelocateTooltip_DEFAULT_STATE = 1;

function RelocateTooltip_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
end

function RelocateTooltip_OnEvent( event )
	if ( event == "VARIABLES_LOADED" ) then
		if (RelocateTooltip_ENABLE == nil) then
			RelocateTooltip_TOOLTIP = RelocateTooltip_DEFAULT_STATE;
		end
		RelocateTooltip_ToggleToolTip(RelocateTooltip_ENABLE);
		return;
	end
end

function RelocateTooltip_ToggleToolTip ( toggle )
	RelocateTooltip_TOOLTIP = toggle;
	if (toggle ~= 0) then
		BlizzardGameTooltip_SetDefaultAnchor = GameTooltip_SetDefaultAnchor;
		GameTooltip_SetDefaultAnchor = function ( tooltip, parent)
			if( not ( RelocateTooltip_TOOLTIP == nil )) then
				if(RelocateTooltip_TOOLTIP == 0) then
					BlizzardGameTooltip_SetDefaultAnchor(tooltip,parent);
				elseif(RelocateTooltip_TOOLTIP == 1) then
					tooltip:SetOwner(parent, "ANCHOR_NONE");
					tooltip:SetPoint("TOP", "UIParent", "TOP", 0, -32);
				elseif(RelocateTooltip_TOOLTIP == 2) then
					tooltip:SetOwner(parent, "ANCHOR_Cursor");
				end
			end
		end
	else
		if(not (BlizzardGameTooltip_SetDefaultAnchor == nil)) then
			GameTooltip_SetDefaultAnchor = BlizzardGameTooltip_SetDefaultAnchor;
		end
	end
	RelocateTooltip_Save();
end

function RelocateTooltip_Save()
	RegisterForSave("RelocateTooltip_ENABLE");
	RelocateTooltip_ENABLE = RelocateTooltip_TOOLTIP;
end

function mooprint ( text)
	if ( not (text==nil)) then
		DEFAULT_CHAT_FRAME:AddMessage(text,1.0, 1.0, 0.0, 1.0);
	end
end

SLASH_TOOLTIP1 = "/tooltip";
SlashCmdList["TOOLTIP"] = function(msg)
	local tag = string.lower(msg);
	if ((tag ~= nil) and not (string.len(tag) == 0)) then
		if((string.find("on",tag) ~= nil) or (string.find("top",tag) ~= nil)) then
			if(RelocateTooltip_TOOLTIP ~= 1) then
				RelocateTooltip_ToggleToolTip(1);
				mooprint("Tooltip relocated to the top");
			end
		elseif((string.find("mouse",tag) ~= nil) or (string.find("cursor",tag) ~= nil)) then
			if(RelocateTooltip_TOOLTIP ~= 2) then
				RelocateTooltip_ToggleToolTip(2);
				mooprint("Tooltip relocated to the mouse cursor");
			end
		elseif((string.find("off",tag) ~= nil) or (string.find("default",tag) ~= nil)) then
			if(RelocateTooltip_TOOLTIP ~= 0) then
				RelocateTooltip_ToggleToolTip(0);
				mooprint("Tooltip defaulted to right side");
			end
		elseif((string.find("save",tag) ~= nil)) then
			RelocateTooltip_Save();
			mooprint("Tooltip persistent variables saved");
		end
	else
		mooprint("Tooltip parameters: on (or top), off (or default), mouse (or cursor), save");
	end
end