
MOVE_ITEM_TIMEOFFSET = 0;
MOVE_ITEM_TIMEOFFSET_LOCKED = nil;

function FindFreeBagSlot()
	for bag = 0,4 do
		for slot = 1,GetContainerNumSlots(bag) do
			if ( not SlotHasItem(bag, slot ) ) then
				return bag, slot;
			end
		end
	end
	return -1,-1;
end

function GetNumberOfFreeItemSlots()
	local freeSlots = 0;
	for bag = 0,4 do
		for slot = 1,GetContainerNumSlots(bag) do
			local texture, itemCount = GetContainerItemInfo(bag, slot);
			if (not itemCount) then
				freeSlots = freeSlots + 1;
			end
		end
	end
	return freeSlots;
end

function SarfPickupItem(bag, slot)
	if ( ( ( bag ~= nil ) or ( slot ~= nil ) ) and ( ( bag > -1 ) or ( slot > -1 ) ) ) then
		if ( ( not bag ) or ( bag == -1 ) ) then
			PickupInventoryItem(slot);
		else
			if ( ( not slot ) or ( slot == -1 ) ) then
				PickupInventoryItem(bag);
			else
				PickupContainerItem(bag, slot);
			end
		end
	end
end

function SarfPutdownItem(bag, slot)
	if ( SlotHasItem(bag, slot) ) then
		bag, slot = FindFreeBagSlot();
	end
	SarfPickupItem(bag, slot);
end

function MoveItemInCursorTo(bag, slot)
	if ( CursorHasItem() ) then
		SarfPickupItem(bag, slot);
	end
	return true;
end

function SlotHasItem(bag, slot)
	if ( bag == -1) then
		if (slot == -1) then
			return false;
		end
		local hasItem, hasCooldown = CosmosTooltip:SetInventoryItem("player", slot);
		if ( not hasItem) then
			return false;
		else
			return true;
		end
	end
	local texture, itemCount = GetContainerItemInfo(bag, slot);
	if (not itemCount) then
		return false;
	else
		return true;
	end
end

-- placeholder function until I find a way of extracting the current latency
function GetLatency()
	return 0.3;
end

function GetEquipLatency()
	return GetLatency()*2;
end

function MoveItem(bagSource, slotSource, bagDestination, slotDestination)
	if ( not SlotHasItem(bagSource, slotSource) ) then
		Print("Source location did not have an item.");
		return false;
	end
	if ( SlotHasItem(bagDestination, slotDestination) ) then
		Print("Destination did have an item occupying it.");
		return false;
	end
	--Print("MoveTo Source : "..bagSource..","..slotSource.."    dest : "..bagDestination..","..slotDestination)
	local cursorItemBag = -1;
	local cursorItemSlot = -1;
	local tempItemBag = -1;
	local tempItemSlot = -1;
	
	if ( not MOVE_ITEM_TIMEOFFSET_LOCKED ) then
		MOVE_ITEM_TIMEOFFSET = 0;
	end
	
	if (CursorHasItem()) then
		if ( GetNumberOfFreeItemSlots() > 1) then
			cursorItemBag, cursorItemSlot = FindFreeBagSlot();
			if ( (tempItemBag > -1) and (tempItemSlot > -1) ) then
				MoveItemInCursorTo(cursorItemBag, cursorItemSlot);
				MOVE_ITEM_TIMEOFFSET = MOVE_ITEM_TIMEOFFSET + GetEquipLatency();
			else
				Print("Could not place cursor item in temporary slot.");
				return false;
			end
		end
	end
	Cosmos_Schedule(MOVE_ITEM_TIMEOFFSET, SarfPickupItem, bagSource, slotSource);
	MOVE_ITEM_TIMEOFFSET = MOVE_ITEM_TIMEOFFSET + GetEquipLatency();
	Cosmos_Schedule(MOVE_ITEM_TIMEOFFSET, SarfPutdownItem, bagDestination, slotDestination);
	MOVE_ITEM_TIMEOFFSET = MOVE_ITEM_TIMEOFFSET + GetEquipLatency();
	
	if ( (cursorItemBag > -1) and (cursorItemSlot > -1) ) then
		if ( SlotHasItem(cursorItemBag, cursorItemSlot) ) then
			Cosmos_Schedule(MOVE_ITEM_TIMEOFFSET, PickupContainerItem, cursorItemBag, cursorItemSlot);
			MOVE_ITEM_TIMEOFFSET = MOVE_ITEM_TIMEOFFSET + GetEquipLatency();
		else
			Print("Cursor item which was temporarily stored could not be found.");
			return false;
		end
	end
	return true;
end

function SarfEquipByBagSlot(equipmentID, bag, slot)
	if ( ( bag > -1 ) or (slot > -1) ) then
		return MoveItem(bag, slot, -1, equipmentID);
	end
end

function SarfEquipByName(equipmentID, name)
	local bag, slot = SarfFindItemByName(name);
	return SarfEquipByBagSlot(equipmentID, bag, slot);
end

function SarfUnequipByID(equipmentID)
	local bag, slot = FindFreeBagSlot();
	return MoveItem(-1, equipmentID, bag, slot);
end

function SarfEquipByName(name)
	Print("SarfEquipByName not implented yet.");
end

function SarfGetItemName(bag, slot)
	local name = "";
	local strings = nil;
	if ( bag > -1 ) then
		strings = GetItemInfoStrings(bag, slot, "CosmosTooltip");
	else
		local hasItem, hasCooldown = CosmosTooltip:SetInventoryItem("player", slot);
		strings = ScanTooltip("CosmosTooltip");
		if ( not hasItem) then
			if ( strings[1] ) then
				strings[1].left = "";
			end
		end
	end
	-- Determine if the item is an ore, gem or herb
	if ( strings[1] ) then
		name = strings[1].left;
	end
	return name;
end

function SarfGetEquipmentNumSlots()
	return 20;
end

function SarfFindItemByNameInBags(name, allowedMatches)
	if ( (not name) or (strlen(name) <= 0) ) then
		return -1, -1;
	end
	if (not allowedMatches) then
		allowedMatches = 1;
	end
	for bag = 0,4 do
		for slot = 1,GetContainerNumSlots(bag) do
			if ( name == SarfGetItemName(bag, slot) ) then
				if ( allowedMatches <= 1 ) then
					return bag, slot;
				else
					allowedMatches = allowedMatches - 1;
				end
			end
		end
	end
	return -1, -1;
end

function SarfFindItemByNameInEquipment(name, allowedMatches)
	if ( (not name) or (strlen(name) <= 0) ) then
		return -1, -1;
	end
	if (not allowedMatches) then
		allowedMatches = 1;
	end
	for slot = 1, SarfGetEquipmentNumSlots() do
		if ( name == SarfGetItemName(-1, slot) ) then
			if ( allowedMatches <= 1 ) then
				return -1, slot;
			else
				allowedMatches = allowedMatches - 1;
			end
		end
	end
	return -1, -1;
end

function SarfFindItemByName(name, prioritizeEquippedItems, allowedMatches)
	if ( (not name) or (strlen(name) <= 0) ) then
		return -1, -1;
	end
	local bag, slot;
	if ( not prioritizeEquippedItems ) then
		bag, slot = SarfFindItemByNameInBags(name, allowedMatches);
	else
		bag, slot = SarfFindItemByNameInEquipment(name, allowedMatches);
	end

	if ( ( bag == -1 ) and ( slot == -1 ) ) then
		if ( not prioritizeEquippedItems ) then
			bag, slot = SarfFindItemByNameInEquipment(name, allowedMatches);
		else
			bag, slot = SarfFindItemByNameInBags(name, allowedMatches);
		end
	end

	return bag, slot;
end

function SarfWieldoffHandWeapon(bagOff, slotOff)
	if ( ( bagOff > -1 ) or ( ( slotOff ~= 17 ) and ( slotOff > -1 ) ) ) then
		MoveItem(bagOff, slotOff, -1, 17);
	end
end

function SarfWieldWeapons(mainweapon, offweapon)
	if ( mainweapon == nil ) then
		mainweapon = "";
	end
	if ( offweapon == nil ) then
		offweapon = "";
	end
	local mainHandWeapon = SarfGetItemName(-1, 16);
	local offHandWeapon = SarfGetItemName(-1, 17);
	local bagMain, slotMain = SarfFindItemByName(mainweapon, nil);
	local bagOff, slotOff = SarfFindItemByName(offweapon, nil);
	if ( ( bagMain == bagOff ) and ( slotMain == slotOff ) ) then
		bagOff, slotOff = SarfFindItemByName(offweapon, nil, 2);
	end
	
	if ( ( mainHandWeapon == mainweapon) and ( offHandWeapon == offweapon ) ) then
		return true;
	end
	if (mainHandWeapon == offweapon) and ( offHandWeapon == mainweapon) then
		MOVE_ITEM_TIMEOFFSET_LOCKED = nil;
		if ( ( strlen(mainHandWeapon) > 0 ) and ( strlen(offHandWeapon) > 0 ) ) then
			return MoveItem(-1, 16, -1, 17);
		else
			if ( strlen(mainHandWeapon) > 0 ) then
				return MoveItem(-1, 16, -1, 17);
			else
				return MoveItem(-1, 17, -1, 16);
			end
		end
	end

	MOVE_ITEM_TIMEOFFSET_LOCKED = nil;
	if ( mainHandWeapon ~= mainweapon ) then
		if ( strlen(mainHandWeapon) > 0) then
			SarfUnequipByID(16);
			MOVE_ITEM_TIMEOFFSET_LOCKED = 1;
		end
		MoveItem(bagMain, slotMain, -1, 16);
		MOVE_ITEM_TIMEOFFSET_LOCKED = 1;
	end
	if (offHandWeapon ~= offweapon ) then
		if ( strlen(offHandWeapon) > 0) then
			SarfUnequipByID(17);
			MOVE_ITEM_TIMEOFFSET_LOCKED = 1;
		end
		if ( strlen(offweapon) > 0 ) then
			if ( ( mainweapon == offweapon ) and ( mainHandWeapon == mainweapon ) ) then
				MoveItem(bagMain, slotMain, -1, 17);
			else
				MoveItem(bagOff, slotOff, -1, 17);
			end
			MOVE_ITEM_TIMEOFFSET_LOCKED = nil;
		end
		return true;
	end
	return true;
	
end

function SarfEquip_OnLoad()

end