SpellChecker2_GUI_CurrentSelection = "";
SpellChecker2_GUI_Array = {};

function SpellChecker2_GUI_OnLoad()
end

function SpellChecker2_GUI_OnEvent()
end

function SpellChecker2_GUI_Column_SetWidth(width, frame)
	if ( not frame ) then
		frame = this;
	end
	frame:SetWidth(width);
	getglobal(frame:GetName().."Middle"):SetWidth(width - 9);
end

function SpellChecker2_GUI_InitiateCorrections(arr)
	SpellChecker2_GUI_Array = SpellChecker2_User_Corrections;
	SpellChecker2_GUI_CurrentSelection = nil;
	SpellChecker2_GUI_Update();
end


function SpellChecker2_GUI_GetItemByNumber(number)
	local i = 1;
	for k, v in SpellChecker2_GUI_Array do
		if ( i == number ) then
			return k, v;
		end
		i = i + 1;
	end
	return nil, nil;
end

function SpellChecker2_GUI_Update()
	local maxItems = 0;
	for k, v in pairs(SpellChecker2_GUI_Array) do
		maxItems = maxItems + 1;
	end
	local find, replace;
	local SpellChecker2_GUIItemSlot;
	local findText, replaceText;
	FauxScrollFrame_Update(SpellChecker2_GUIFrameScrollFrame, maxItems, SPELLCHECKER2_GUI_ITEMS_SHOWN, SPELLCHECKER2_GUI_ITEM_HEIGHT);
	
	for iItem = 1, SPELLCHECKER2_GUI_ITEMS_SHOWN, 1 do
		local itemIndex = iItem + FauxScrollFrame_GetOffset(SpellChecker2_GUIFrameScrollFrame);
		SpellChecker2_GUIItemSlot = getglobal("SpellChecker2_GUIItem"..iItem);
		findText = getglobal("SpellChecker2_GUIItem"..iItem.."FindText");
		replaceText = getglobal("SpellChecker2_GUIItem"..iItem.."ReplaceText");
		if( itemIndex <= maxItems) then
			find, replace = SpellChecker2_GUI_GetItemByNumber(itemIndex);
			if ( find == SpellChecker2_GUI_CurrentSelection ) then
				findText:SetTextColor(1,1,0);
				replaceText:SetTextColor(1,1,0);
			else
				findText:SetTextColor(1,1,1);
				replaceText:SetTextColor(1,1,1);
			end
			findText:SetText(find);
			replaceText:SetText(replace);
			SpellChecker2_GUIItemSlot:Show();
		else
			SpellChecker2_GUIItemSlot:Hide();
		end
	end
end

function SpellChecker2_GUI_ToggleShow()
	if ( not SpellChecker2_GUIFrame:IsVisible() ) then
		ShowUIPanel(SpellChecker2_GUIFrame);
	else
		HideUIPanel(SpellChecker2_GUIFrame);
	end
end

function SpellChecker2_GUI_SaveArray()
end

function SpellChecker2_GUIItemButton_OnEnter()
end

function SpellChecker2_GUI_AddCorrection()
	StaticPopup_Show("SPELLCHECKER2_ADD_CORRECTION");
end

function SpellChecker2_GUI_RemoveCorrection()
	if ( not SpellChecker2_GUI_CurrentSelection ) then
		return;
	end
	if ( SpellChecker2_GUI_Array[SpellChecker2_GUI_CurrentSelection] ) then
		SpellChecker2_GUI_Array[SpellChecker2_GUI_CurrentSelection] = nil;
		SpellChecker2_GUI_CurrentSelection = nil;
		SpellChecker2_GUI_Update();
	end
end

SpellChecker2_GUI_AddCorrection_Find = nil;

function SpellChecker2_GUI_AddCorrection_Callback(name)
	if ( name ) and ( strlen(name) > 0 ) then
		SpellChecker2_GUI_AddCorrection_Find = name;
		StaticPopup_Show("SPELLCHECKER2_ADD_CORRECTION_STAGE_TWO");
	end
end

function SpellChecker2_GUI_AddCorrection_Stage_Two_Callback(correction)
	if ( correction ) and ( strlen(correction) > 0 ) and ( SpellChecker2_GUI_AddCorrection_Find ) then
		SpellChecker2_GUI_Array[SpellChecker2_GUI_AddCorrection_Find] = correction;
		SpellChecker2_GUI_AddCorrection_Find = nil;
		SpellChecker2_GUI_Update();
	end
end

SpellChecker2_GUI_EditCorrection_Find = nil;
SpellChecker2_GUI_EditCorrection_Replace = nil;

function SpellChecker2_GUI_EditCorrection()
	if ( SpellChecker2_GUI_CurrentSelection ) then
		SpellChecker2_GUI_EditCorrection_Find = SpellChecker2_GUI_CurrentSelection;
		SpellChecker2_GUI_EditCorrection_Replace = SpellChecker2_GUI_Array[SpellChecker2_GUI_CurrentSelection];
		if ( not SpellChecker2_GUI_EditCorrection_Replace ) then 
			SpellChecker2_GUI_EditCorrection_Replace = "";
		end
		StaticPopup_Show("SPELLCHECKER2_EDIT_CORRECTION");
	end
end

function SpellChecker2_GUI_EditCorrection_Callback(name)
	if ( name ) and ( strlen(name) > 0 ) then
		SpellChecker2_GUI_EditCorrection_Find = name;
		StaticPopup_Show("SPELLCHECKER2_EDIT_CORRECTION_STAGE_TWO");
	end
end

function SpellChecker2_GUI_EditCorrection_Stage_Two_Callback(correction)
	if ( correction ) and ( strlen(correction) > 0 ) and ( SpellChecker2_GUI_EditCorrection_Find ) then
		SpellChecker2_GUI_Array[SpellChecker2_GUI_EditCorrection_Find] = correction;
		SpellChecker2_GUI_EditCorrection_Find = nil;
		SpellChecker2_GUI_Update();
	end
end

StaticPopupDialogs["SPELLCHECKER2_ADD_CORRECTION"] = {
	text = TEXT(SPELLCHECKER2_GUI_FIND_TEXT),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		SpellChecker2_GUI_AddCorrection_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	EditBoxOnEnterPressed = function()
		SpellChecker2_GUI_AddCorrection_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
		getglobal(this:GetParent():GetName().."EditBox"):SetText("");
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

StaticPopupDialogs["SPELLCHECKER2_ADD_CORRECTION_STAGE_TWO"] = {
	text = TEXT(SPELLCHECKER2_GUI_REPLACE_TEXT),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		SpellChecker2_GUI_AddCorrection_Stage_Two_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	EditBoxOnEnterPressed = function()
		SpellChecker2_GUI_AddCorrection_Stage_Two_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
		getglobal(this:GetParent():GetName().."EditBox"):SetText("");
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	hasEditBox = 1,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

StaticPopupDialogs["SPELLCHECKER2_EDIT_CORRECTION"] = {
	text = TEXT(SPELLCHECKER2_GUI_FIND_TEXT),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		SpellChecker2_GUI_EditCorrection_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	EditBoxOnEnterPressed = function()
		SpellChecker2_GUI_EditCorrection_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
		getglobal(this:GetParent():GetName().."EditBox"):SetText("");
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
		getglobal(this:GetName().."EditBox"):SetText(SpellChecker2_GUI_EditCorrection_Find);
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

StaticPopupDialogs["SPELLCHECKER2_EDIT_CORRECTION_STAGE_TWO"] = {
	text = TEXT(SPELLCHECKER2_GUI_REPLACE_TEXT),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		SpellChecker2_GUI_EditCorrection_Stage_Two_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	EditBoxOnEnterPressed = function()
		SpellChecker2_GUI_EditCorrection_Stage_Two_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
		getglobal(this:GetParent():GetName().."EditBox"):SetText("");
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
		getglobal(this:GetName().."EditBox"):SetText(SpellChecker2_GUI_EditCorrection_Replace);
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

