--[[
	Tell Track

	By sarf

	This mod ...

	Thanks goes to Lash for the idea and support!
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=
	
   ]]


-- Constants

-- Variables
TellTrack_Enabled = 0;

TellTrack_ButtonCount = 4;

TellTrack_Array = {};

TellTrack_WhisperedTargets = {};

TellTrack_Saved_SendChatMessage = nil;
TellTrack_Cosmos_Registered = 0;

-- executed on load, calls general set-up functions
function TellTrack_OnLoad()
	TellTrack_Register();
	TellTrack_UpdateTellTrackButtonsText();
end

-- registers the mod with Cosmos
function TellTrack_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( TellTrack_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_TELLTRACK_HEADER",
			"SEPARATOR",
			TELLTRACK_CONFIG_HEADER,
			TELLTRACK_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_TELLTRACK_ENABLED",
			"CHECKBOX",
			TELLTRACK_ENABLED,
			TELLTRACK_ENABLED_INFO,
			TellTrack_Toggle_Enabled,
			0
		);
		TellTrack_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function TellTrack_Register()
	if ( Cosmos_RegisterConfiguration ) then
		TellTrack_Register_Cosmos();
	else
		SlashCmdList["TELLTRACKSLASHENABLE"] = TellTrack_Enable_ChatCommandHandler;
		SLASH_TELLTRACKSLASHENABLE1 = "/telltracktoggle";
		SLASH_TELLTRACKSLASHENABLE2 = "/ttracktoggle";
		SLASH_TELLTRACKSLASHENABLE3 = "/telltrackenable";
		SLASH_TELLTRACKSLASHENABLE4 = "/ttrackenable";
		SLASH_TELLTRACKSLASHENABLE5 = "/telltrackdisable";
		SLASH_TELLTRACKSLASHENABLE6 = "/ttrackdisable";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local TellTrackEnableCommands = {"/telltracktoggle","/ttracktoggle","/telltrackenable","/ttrocknenable","/telltrackdisable","/ttrackdisable"};
		Cosmos_RegisterChatCommand (
			"TELLTRACK_ENABLE_COMMANDS", -- Some Unique Group ID
			TellTrackEnableCommands, -- The Commands
			TellTrack_Enable_ChatCommandHandler,
			TELLTRACK_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end 

-- Handles chat - e.g. slashcommands - enabling/disabling the TellTrack
function TellTrack_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		TellTrack_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			TellTrack_Toggle_Enabled(0);
		else
			TellTrack_Toggle_Enabled(-1);
		end
	end
end

-- Does things with the hooked function
function TellTrack_SendChatMessage(text, type, language, target)
	if ( TellTrack_Enabled == 1 ) then
		if ( type == "WHISPER" ) then 
			TellTrack_HandleSentMessageToSomeone(target);
		end
	end
	TellTrack_Saved_SendChatMessage(text, type, language, target);
end

-- Hooks/unhooks functions. If toggle is 1, hooks functions, otherwise it unhooks functions.
--  Hooking functions mean that you replace them with your own functions and then call the 
--  original function at your leisure.
function TellTrack_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( SendChatMessage ~= TellTrack_SendChatMessage ) and (TellTrack_Saved_SendChatMessage == nil) ) then
			TellTrack_Saved_SendChatMessage = SendChatMessage;
			SendChatMessage = TellTrack_SendChatMessage;
		end
	else
		if ( SendChatMessage == TellTrack_SendChatMessage) then
			SendChatMessage = TellTrack_Saved_SendChatMessage;
			TellTrack_Saved_SendChatMessage = nil;
		end
	end
end

-- Handles events
function TellTrack_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( TellTrack_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_TELLTRACK_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			TellTrack_Toggle_Enabled(value);
		end
	end
end

-- Toggles the enabled/disabled state of an option and returns the new state
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function TellTrack_Generic_Toggle(toggle, variableName, CVarName, enableMessage, disableMessage)
	local oldvalue = getglobal(variableName);
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	setglobal(variableName, newvalue);
	setglobal(CVarName, newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			TellTrack_Print(TEXT(getglobal(enableMessage)));
		else
			TellTrack_Print(TEXT(getglobal(disableMessage)));
		end
	end
	TellTrack_Register_Cosmos();
	if ( TellTrack_Cosmos_Registered == 0 ) then 
		RegisterForSave(CVarName);
	end
	return newvalue;
end

-- Toggles the enabled/disabled state of the TellTrack
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function TellTrack_Toggle_Enabled(toggle)
	local newvalue = TellTrack_Generic_Toggle(toggle, "TellTrack_Enabled", "TellTrack_Enabled", "TELLTRACK_CHAT_ENABLED", "TELLTRACK_CHAT_DISABLED");
	if ( newvalue == 0 ) then
		TellTrackFrame:Hide();
	else
		TellTrackFrame:Show();
	end
	TellTrack_Setup_Hooks(newvalue);
end

-- Prints out text to a chat box.
function TellTrack_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end

function TellTrackTextButton_OnEnter()
	local id = this:GetID();
	if ( id ) then
		TellTrackTooltip:SetOwner(TellTrackFrame, "ANCHOR_TOPLEFT");
		TellTrackSetTooltip(id);
	end
end

function TellTrackTextButton_OnLeave()
	if ( TellTrackTooltip:IsOwned(this) ) then
		TellTrackTooltip:Hide();
	end
end

function TellTrackTextButton_OnLoad()
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
end

function TellTrack_InitiateWhisperByID(id)
	local name = TellTrackGetName(id);
	TellTrack_InitiateWhisperToTarget(name);
end

function TellTrack_InitiateWhisperToTarget(name)
	if ( not name ) then
		return;
	end
	local chatFrame = DEFAULT_CHAT_FRAME;
	chatFrame.editBox.chatType = "WHISPER";
	chatFrame.editBox.tellTarget = name;
	ChatEdit_UpdateHeader(chatFrame.editBox);
	if ( not chatFrame.editBox:IsVisible() ) then
		ChatFrame_OpenChat("", chatFrame);
	end
end

function TellTrackTextButton_OnClick(button)
	local id = this:GetID();
	if ( not id ) then
		return
	end
	if ( button == "RightButton" ) then
		TellTrack_EraseByID(id);
	elseif ( button == "LeftButton" ) then
		TellTrack_InitiateWhisperByID(id);
	end
end

function TellTrack_EraseByID(id)
	if ( id ) then
		if ( TellTrack_Array ) and ( TellTrack_Array[id] ) then
			TellTrack_Array[id] = nil;
		end
		TellTrack_UpdateTellTrackButtonsText();
	end
end

function TellTrackGetName(id)
	if ( id ) then
		if ( ( TellTrack_Array ) and ( TellTrack_Array[id] ) and ( TellTrack_Array[id].name ) ) then
			return TellTrack_Array[id].name;
		end
	end
	return nil;
end

function TellTrackSetTooltip(id)
	local name = TellTrackGetName(id);
	if ( name ) then
		TellTrackTooltip:SetText(name);
	end
end

function TellTrack_CanIgnoreTopCount()
	return false;
end

function TellTrack_CanIgnoreTopTime()
	return true;
end

-- Yet another function from George Warner, modified a bit to fit my own nefarious purposes. 
-- It can now accept r, g and b specifications, too (leaving out a), as well as handle 255 255 255
-- Source : http://www.cosmosui.org/cgi-bin/bugzilla/show_bug.cgi?id=159
function TellTrack_GetColorFormatString(a, r, g, b)
	local percent = false;
	if ( ( ( not b ) or ( b <= 1 ) ) and ( a <= 1 ) and ( r <= 1 ) and ( g <= 1) ) then percent = true; end
	if ( ( not b ) and ( a ) and ( r ) and ( g ) ) then b = g; g = r; r = a; if ( percent ) then a = 1; else a = 255; end end
	if ( percent ) then a = a * 255; r = r * 255; g = g * 255; b = b * 255; end
	a = Cosmos_GetByteValue(a); r = Cosmos_GetByteValue(r); g = Cosmos_GetByteValue(g); b = Cosmos_GetByteValue(b);
	
	return format("|c%02X%02X%02X%02X%%s|r", a, r, g, b);
end

function TellTrack_UpdateTellTrackButtonsText()
	local gotNameFormatStr = TellTrack_GetColorFormatString(0.2, 1.0, 0.2);
	local noNameFormatStr = TellTrack_GetColorFormatString(0.4, 0.4, 0.4);
	for i = 1, TellTrack_ButtonCount do
		local buttonText = getglobal("TellTrack"..i.."Text");
		local formatStr, valueStr;
		if ( ( TellTrack_Array[i] ) and ( TellTrack_Array[i].name ) ) then
			formatStr = gotNameFormatStr;
			valueStr = TellTrack_Array[i].name;
		else
			formatStr = noNameFormatStr;
			valueStr = "not set";
		end
		if ( buttonText ) then
			if ( strlen(valueStr) > 7 ) then
				valueStr = substr(valueStr, 1, 4).."...";
			end
			buttonText:SetText(format(formatStr, valueStr));
			buttonText:Show();
		end
	end
end

function TellTrack_UpdateTellTrackButtons()
	local index = 1;
	local topName = nil;
	local top = 0;
	local topTime = 0;
	local skipThisOne = false;
	TellTrack_Array = {};
	while ( index <= TellTrack_ButtonCount ) do
		topName = nil;
		for k, v in TellTrack_WhisperedTargets do
			skipThisOne = false;
			for i = 1,(index-1),1 do
				if ( TellTrack_Array[i] ) then
					if ( k == TellTrack_Array[i].name ) then
						skipThisOne = true;
						Print("TT: Found an already existing match.");
						break;
					end
				end
			end
			if ( not skipThisOne ) then
				if ( ( ( v.whispers > top ) or (TellTrack_CanIgnoreTopCount()) ) and ( ( v.lastWhispered > topTime ) or (TellTrack_CanIgnoreTopTime()) ) ) then
					topName = k;
					top = v.whispers;
					topTime = v.lastWhispered;
				end
			end
		end
		if ( topName ) then
			TellTrack_Array[index].name = topName;
			index = index + 1;
		else
			break;
		end
	end
	TellTrack_UpdateTellTrackButtonsText();
end

function TellTrack_HandleSentMessageToSomeone(target)
	for k, v in TellTrack_Array do
		if ( v.name == target ) then
			Print("TT: Found in array");
			return;
		end
	end
	for i = 1, TellTrack_ButtonCount do
		if ( ( not TellTrack_Array[i] ) or ( not TellTrack_Array[i].name ) ) then
			Print("TT: Found empty slot "..i);
			TellTrack_Array[i] = {};
			TellTrack_Array[i].name = target;
			break;
		end
	end
	Print("TT: Updating Tell Track Button");
	TellTrack_UpdateTellTrackButtonsText();
end

function TellTrack_HandleSentMessageToSomeoneOld(target)
	if ( not TellTrack_WhisperedTargets ) then
		TellTrack_WhisperedTargets = {};
	end
	if ( not TellTrack_WhisperedTargets[target] ) then
		TellTrack_WhisperedTargets[target] = {};
		TellTrack_WhisperedTargets[target].whispers = 0;
		TellTrack_WhisperedTargets[target].lastWhispered = 0;
	end
	TellTrack_WhisperedTargets[target].whispers = TellTrack_WhisperedTargets[target].whispers + 1;
	TellTrack_WhisperedTargets[target].lastWhispered = GetTime();
	
	TellTrack_UpdateTellTrackButtons();
end