--[[
 MonitorStatus v0.4 
 Originally made by wharvey 2004-2-23
 Currently maintained by David Hedbor <david@hedbor.org>
 Updated to v0.4 by Anders "sarf" Kronquist <k@fukt.bth.se>
 Changes in version 0.44:
  * Refactored code to be slightly less redundant
  * Fixed spe11ing err0rs
  * Remade the code to be less local and more global... global variables rock! :)
  * Thanks to vjeux for pointing out obvious errors
 Changes in version 0.4:
  * Added Cosmos compatibility
  * Added slash commands / toggle option
  * Refactored code to be slightly less redundant
 Changes in version 0.3:
  * Made into an addon, fixing one loading issue.
  * Fixed bug where info from removed targets / party members wasn't cleared
    correctly.
]]

MONITORSTATUS_SECONDS_TILL_REVERT = 5;

MonitorStatus_PlayerLastHealth = 0;
MonitorStatus_PlayerTimeStamp = 0;
MonitorStatus_TargetLastHealth = 0;
MonitorStatus_TargetTimeStamp = 0;
MonitorStatus_PartyOneLastHealth = 0;
MonitorStatus_PartyOneTimeStamp = 0;
MonitorStatus_PartyTwoLastHealth = 0;
MonitorStatus_PartyTwoTimeStamp = 0;
MonitorStatus_PartyThreeLastHealth = 0;
MonitorStatus_PartyThreeTimeStamp = 0;
MonitorStatus_PartyFourLastHealth = 0;
MonitorStatus_PartyFourTimeStamp = 0;

-- added by sarf
MonitorStatus_CosmosRegistered = 0;
MonitorStatus_Enabled = 0;

function MonitorStatus_OnLoad()
	MonitorStatus_Register();
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("PARTY_MEMBERS_CHANGED");

	MonitorStatus_CalculateValues();

	MonitorStatus_Print("MonitorStatus v0.4 loaded.", 1, 1, 1);
end

function MonitorStatus_OnUpdate()
	MonitorStatus_CalculateValues();  
end

function MonitorStatus_OnEvent()
	local list = { };
	if (event == "PLAYER_TARGET_CHANGED") then
		local list = { "Target" };
		TargetStatusConditionText:SetText("");
	elseif (event == "PARTY_MEMBERS_CHANGED") then
		list = {"PartyOne", "PartyTwo", "PartyThree", "PartyFour" };
	end
	local nameText = nil;
	for k, v in list do
		setglobal("MonitorStatus_"..v.."LastHealth", 0);
		setglobal("MonitorStatus_"..v.."TimeStamp", 0);
		nameText = getglobal(v.."StatusNameText");
		if (nameText) then
	    	nameText:SetTextColor(1, 0.82, 0);
	    end
	end
end

function MonitorStatus_CalculateValuesSpecific(unitName, prefix)
	local literalHealth, healthPct, healthColor, manaPct, manaColor, timeNow, conditionLine;
	
	local conditionText = getglobal(prefix.."StatusConditionText");
	local healthText = getglobal(prefix.."StatusHealthText");
	local nameText = getglobal(prefix.."StatusNameText");
	local manaText = getglobal(prefix.."StatusManaText");
	
	timeNow = GetTime();

	if (UnitName(unitName)) then
		literalHealth = UnitHealth(unitName);
		nameText:SetText(UnitName(unitName));
		
		healthPct = (literalHealth * 100.0) / UnitHealthMax(unitName);
		healthColor = MonitorStatus_GetHealthColor(healthPct);
		conditionLine = MonitorStatus_GetConditionLine(healthPct);
		
		conditionText:SetText(conditionLine.name);
		conditionText:SetTextColor(conditionLine.r, conditionLine.g, conditionLine.b);
		
		healthPct = string.format("%4.0f", healthPct);
		healthText:SetText(healthPct);
		healthText:SetTextColor(healthColor.r, healthColor.g, healthColor.b);
		
		if (literalHealth < getglobal("MonitorStatus_"..prefix.."LastHealth")) then
			nameText:SetTextColor(1, 0.1, 0.1);
			setglobal(prefix.."TimeStamp", GetTime());
		else
			local timeStamp = getglobal("MonitorStatus_"..prefix.."TimeStamp");
			if ( not timeStamp) or (timeStamp == 0) then
				-- Usual case.  Don't waste cycles on other clause
			elseif ( (timeNow - timeStamp) > MONITORSTATUS_SECONDS_TILL_REVERT ) then
				setglobal("MonitorStatus_"..prefix.."TimeStamp", 0);
				nameText:SetTextColor(1, 0.82, 0);
			end
		end
		setglobal(prefix.."LastHealth", literalHealth);
		
		manaPct = (UnitMana(unitName) * 100.0) / UnitManaMax(unitName);
		manaColor = MonitorStatus_GetManaColor(manaPct);
		manaPct = string.format("%4.0f", manaPct);
		manaText:SetText(manaPct);
		manaText:SetTextColor(manaColor.r, manaColor.g, manaColor.b);
	else
		nameText:SetText("");
		healthText:SetText("");
		manaText:SetText("");
		conditionText:SetText("");
	end
end

function MonitorStatus_CalculateValues()
	local literalHealth, healthPct, healthColor, manaPct, manaColor, timeNow, conditionLine;
	
	timeNow = GetTime();
	
	local unitList = { 
	  { "target", "Target" },
	  { "player", "Player" },
	  { "party1", "PartyOne" },
	  { "party2", "PartyTwo" },
	  { "party3", "PartyThree" },
	  { "party4", "PartyFour" }
	  };
	
	for k, v in unitList do
		MonitorStatus_CalculateValuesSpecific(v[1], v[2]);
	end
end

function MonitorStatus_GetConditionLine(health)
	local returnLine = {name = "", r = 0, g = 0, b = 0};
	if (health > 60) then
		return returnLine;
	end
	
	if (health > 40) then
		returnLine.name = "Fair";
		returnLine.r = 1;
		returnLine.g = 1;
	elseif (health > 20) then
		returnLine.name = "Poor";
		returnLine.r = 1;
		returnLine.g = 0.45;
	elseif (health > 0) then
		returnLine.name = "CRITICAL";
		returnLine.r = 1;
		returnLine.g = 0.1;
		returnLine.b = 0.1;
	else
		returnLine.name = "Slain";
		returnLine.r = 0.5;
		returnLine.g = 0.5;
		returnLine.b = 0.5;
	end
	
	return returnLine;
end

function MonitorStatus_GetHealthColor(health)
	local returnColor = { r = 0, g = 0, b = 0 };
	if (health >= 100) then
		returnColor.r = 1;
		returnColor.g = 1;
		returnColor.b = 1;
	elseif (health > 80) then
		returnColor.g = 1;
	elseif (health > 60) then
		returnColor.g = 0.75;
	elseif (health > 40) then
		returnColor.r = 1;
		returnColor.g = 1;
	elseif (health > 20) then
		returnColor.r = 1;
		returnColor.g = 0.45;
	elseif (health > 0) then
		returnColor.r = 1;
		returnColor.g = 0.1;
		returnColor.b = 0.1;
	else
		returnColor.r = 0.5;
		returnColor.g = 0.5;
		returnColor.b = 0.5;
	end
	
	return returnColor;
end

function MonitorStatus_GetManaColor(mana)
	local returnColor = { r = 0, g = 0, b = 0 };
	if (mana >= 100) then
		returnColor.r = 1;
		returnColor.g = 1;
		returnColor.b = 1;    
	elseif (mana > 80) then
		returnColor.b = 1;
	elseif (mana > 60) then
		returnColor.b = 0.75;
	elseif (mana > 40) then
		returnColor.g = 1;
		returnColor.b = 1;
	elseif (mana > 20) then
		returnColor.g = 1;
		returnColor.b = 0.45;
	elseif (mana > 0) then  
		returnColor.r = 0.1;
		returnColor.g = 1;
		returnColor.b = 0.1;
	else
		returnColor.r = 1;
		returnColor.g = 1;
		returnColor.b = 1;
	end

	return returnColor;
end


-- added by sarf

function MonitorStatus_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end


function MonitorStatus_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( MonitorStatus_CosmosRegistered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_MONITORSTATUS_HEADER",
			"SEPARATOR",
			MONITORSTATUS_CONFIG_HEADER,
			MONITORSTATUS_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_MONITORSTATUS_ENABLED",
			"CHECKBOX",
			MONITORSTATUS_ENABLED,
			MONITORSTATUS_ENABLED_INFO,
			MonitorStatus_Toggle_Enabled,
			MonitorStatus_Enabled
		);
		MonitorStatus_CosmosRegistered = 1;
	end
end


function MonitorStatus_Register()
	if ( Cosmos_RegisterConfiguration ) then
		MonitorStatus_Register_Cosmos();
	else
		SlashCmdList["MONITORSTATUSSLASHENABLE"] = MonitorStatus_Enable_ChatCommandHandler;
		SLASH_MONITORSTATUSSLASHENABLE1 = "/monitorstatusenable";
		SLASH_MONITORSTATUSSLASHENABLE2 = "/msenable";
		SLASH_MONITORSTATUSSLASHENABLE3 = "/monitorstatusdisable";
		SLASH_MONITORSTATUSSLASHENABLE4 = "/msdisable";
		SLASH_MONITORSTATUSSLASHENABLE5 = "/monitorstatustoggle";
		SLASH_MONITORSTATUSSLASHENABLE6 = "/mstoggle";
		this:RegisterEvent("VARIABLES_LOADED");
	end
	if ( Cosmos_RegisterChatCommand ) then
		local MonitorStatusEnableCommands = {"/monitorstatusenable","/msenable","/monitorstatusdisable","/msdisable", "/monitorstatustoggle", "/mstoggle"};
		Cosmos_RegisterChatCommand (
			"MONITORSTATUS_ENABLE_COMMANDS", -- Some Unique Group ID
			MonitorStatusEnableCommands, -- The Commands
			MonitorStatus_Enable_ChatCommandHandler,
			MONITORSTATUS_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end

	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
end


function MonitorStatus_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		MonitorStatus_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			MonitorStatus_Toggle_Enabled(0);
		else
			MonitorStatus_Toggle_Enabled(-1);
		end
	end
end

function MonitorStatus_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if(MonitorStatus_CosmosRegistered == 0) then
			local value = getglobal("COS_MONITORSTATUS_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			MonitorStatus_Toggle_Enabled(value);
		end
		return;
	end
end

function MonitorStatus_Update_Window_State(toggle)
	if ( toggle == 1 ) then
		MonitorStatus:Show();
	else
		MonitorStatus:Hide();
	end
end

function MonitorStatus_Toggle_Enabled(toggle)
	local oldvalue = MonitorStatus_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	MonitorStatus_Enabled = newvalue;
	MonitorStatus_Update_Window_State(newvalue);
	setglobal("COS_MONITORSTATUS_ENABLED_X", newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			MonitorStatus_Print(MONITORSTATUS_CHAT_ENABLED);
		else
			MonitorStatus_Print(MONITORSTATUS_CHAT_DISABLED);
		end
	end
	MonitorStatus_Register_Cosmos();
	--if ( MonitorStatus_CosmosRegistered == 0 ) then 
		RegisterForSave("COS_MONITORSTATUS_ENABLED_X");	
	--end
end

