LOOTFRAME_NUMBUTTONS = 4;

-- +Telo: position the most relevant part of the loot frame under the cursor

local function LootFrame_ItemUnderCursor()
	local index;
	local x, y = GetCursorPosition();
	local scale = LootFrame:GetScale();
	
	x = x / scale;
	y = y / scale;
	
	LootFrame:ClearAllPoints();
	
	for index = 1, LOOTFRAME_NUMBUTTONS, 1 do
		local button = getglobal("LootButton"..index);
		if( button:IsVisible() ) then
			x = x - 42;
			y = y + 56 + (40 * index);
			LootFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", x, y);
			return;
		end
	end
	
	if( LootFrameDownButton:IsVisible() ) then
		-- If down arrow, position on it
		x = x - 158;
		y = y + 223;
	else
		-- Otherwise, position on close box
		x = x - 173;
		y = y + 25;
	end
	
	LootFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", x, y);
end

-- -Telo: position the most relevant part of the loot frame under the cursor

function LootFrame_OnLoad()
	this:RegisterEvent("LOOT_OPENED");
	this:RegisterEvent("LOOT_SLOT_CLEARED");
	this:RegisterEvent("LOOT_CLOSED");
end

function LootFrame_OnEvent(event)
	if ( event == "LOOT_OPENED" ) then
		this.page = 1;
		ShowUIPanel(this);
		if ( not this:IsVisible() ) then
			CloseLoot(1);	-- The parameter tells code that we were unable to open the UI
		end
		return;
	end
	if ( event == "LOOT_SLOT_CLEARED" ) then
		local numLootToShow = LOOTFRAME_NUMBUTTONS;
		if ( this.numLootItems > LOOTFRAME_NUMBUTTONS ) then
			numLootToShow = numLootToShow - 1;
		end
		local slot = arg1 - ((this.page - 1) * numLootToShow);
		if ( (slot > 0) and (slot < (numLootToShow + 1)) ) then
			local button = getglobal("LootButton"..slot);
			if ( button ) then
				button:Hide();
			end
		end
-- +Telo: position the most relevant part of the loot frame under the cursor
		LootFrame_ItemUnderCursor();
-- -Telo: position the most relevant part of the loot frame under the cursor
		return;
	end
	if ( event == "LOOT_CLOSED" ) then
		StaticPopup_Hide("LOOT_BIND");
		HideUIPanel(this);
		return;
	end
end

function LootFrame_Update()
	local numLootItems = LootFrame.numLootItems;
	--Logic to determine how many items to show per page
	local numLootToShow = LOOTFRAME_NUMBUTTONS;
	if ( numLootItems > LOOTFRAME_NUMBUTTONS ) then
		numLootToShow = numLootToShow - 1;
	end
	for index = 1, LOOTFRAME_NUMBUTTONS, 1 do
		local button = getglobal("LootButton"..index);
		local slot = (numLootToShow * (LootFrame.page - 1)) + index;
		if ( slot <= numLootItems ) then	
			if ( (LootSlotIsItem(slot) or LootSlotIsCoin(slot)) and index <= numLootToShow ) then
				local texture;
				local item;
				local quantity;
				texture, item, quantity = GetLootSlotInfo(slot);
				getglobal("LootButton"..index.."IconTexture"):SetTexture(texture);
				getglobal("LootButton"..index.."Text"):SetText(item);

				local countString = getglobal("LootButton"..index.."Count");
				if ( quantity > 1 ) then
					countString:SetText(quantity);
					countString:Show();
				else
					countString:Hide();
				end
				button:SetSlot(slot);
				button:Show();
			else
				button:Hide();
			end
		else
			button:Hide();
		end
	end
	if ( LootFrame.page == 1 ) then
		LootFrameUpButton:Hide();
		LootFramePrev:Hide();
	else
		LootFrameUpButton:Show();
		LootFramePrev:Show();
	end
	if ( LootFrame.page == ceil(LootFrame.numLootItems / numLootToShow) or LootFrame.numLootItems == 0 ) then
		LootFrameDownButton:Hide();
		LootFrameNext:Hide();
	else
		LootFrameDownButton:Show();
		LootFrameNext:Show();
	end
-- +Telo: position the most relevant part of the loot frame under the cursor
	LootFrame_ItemUnderCursor();
-- +Telo: position the most relevant part of the loot frame under the cursor
end

function LootFrame_PageDown()
	LootFrame.page = LootFrame.page + 1;
	LootFrame_Update();
end

function LootFrame_PageUp()
	LootFrame.page = LootFrame.page - 1;
	LootFrame_Update();
end

function LootFrame_OnShow()
	this.numLootItems = GetNumLootItems();
	LootFrame_Update();
	LootFramePortraitOverlay:SetTexture("Interface\\TargetingFrame\\TargetDead");
	if( this.numLootItems == 0 ) then
		PlaySound("LOOTWINDOWOPENEMPTY");
	elseif( IsFishingLoot() ) then
		PlaySound("FISHING REEL IN");
		LootFramePortraitOverlay:SetTexture("Interface\\LootFrame\\FishingLoot-Icon");
	else
		PlaySound("LOOTWINDOWOPEN");
	end
end

function LootFrame_OnHide()
	CloseLoot();
	PlaySound("LOOTWINDOWCLOSE");
end

function LootFrameItem_OnClick(button)
	if ( button == "LeftButton" ) then
		if ( IsShiftKeyDown() ) then
			if ( ChatFrameEditBox:IsVisible() ) then
				ChatFrameEditBox:Insert(GetLootSlotLink(this:GetID()));
			end
		end
	end
end
