--[[
	Mod Name

	By sarf

	This mod adds the ability to display text to the right of the normal health/mana bars.

	Thanks goes to the people on CosmosUI who suggested this.
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=
	
   ]]


-- Constants
TEXTBARRIGHT_BAR_NAMES = { 
--	"PlayerFrameHealthBarTextRight", "PlayerFrameManaBarTextRight", 
	"PartyMemberFrame1HealthBarTextRight", "PartyMemberFrame1ManaBarTextRight",
	"PartyMemberFrame2HealthBarTextRight", "PartyMemberFrame2ManaBarTextRight",
	"PartyMemberFrame3HealthBarTextRight", "PartyMemberFrame3ManaBarTextRight",
	"PartyMemberFrame4HealthBarTextRight", "PartyMemberFrame4ManaBarTextRight"
};

TEXTBARRIGHT_PREFIXNAME = { "Small", "", "Large", "VeryLarge", "Huge"};

TEXTBARRIGHT_DEFAULT_FONTSIZE = 2;

-- Variables
TextBarRight_Enabled = 0;
TextBarRight_HealthBarEnabled = 1;
TextBarRight_ManaBarEnabled = 1;
TextBarRight_HealthBarPercentEnabled = 0;
TextBarRight_ManaBarPercentEnabled = 1;
TextBarRight_FontSize = TEXTBARRIGHT_DEFAULT_FONTSIZE;

TextBarRight_Saved_TextStatusBar_UpdateTextString = nil;
TextBarRight_Cosmos_Registered = 0;

-- executed on load, calls general set-up functions
function TextBarRight_OnLoad()
	TextBarRight_Register();
end

-- registers the mod with Cosmos
function TextBarRight_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( TextBarRight_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_HEADER",
			"SEPARATOR",
			TEXTBARRIGHT_CONFIG_HEADER,
			TEXTBARRIGHT_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_ENABLED",
			"CHECKBOX",
			TEXTBARRIGHT_ENABLED,
			TEXTBARRIGHT_ENABLED_INFO,
			TextBarRight_Toggle_Enabled,
			TextBarRight_Enabled
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_FONTSIZE",
			"SLIDER",
			TEXTBARRIGHT_FONTSIZE,
			TEXTBARRIGHT_FONTSIZE_INFO,
			TextBarRight_ChangeFontSize_Enabled,
			1,
			TEXTBARRIGHT_DEFAULT_FONTSIZE,
			1,
			getn(TEXTBARRIGHT_FONTSIZE),
			TEXTBARRIGHT_FONTSIZE_SLIDERSTRING,
			1,
			0,
			0,
			1
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_HEALTHBAR_ENABLED",
			"CHECKBOX",
			TEXTBARRIGHT_HEALTHBAR_ENABLED,
			TEXTBARRIGHT_HEALTHBAR_ENABLED_INFO,
			TextBarRight_HealthBar_Toggle_Enabled,
			TextBarRight_HealthBarEnabled
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_MANABAR_ENABLED",
			"CHECKBOX",
			TEXTBARRIGHT_MANABAR_ENABLED,
			TEXTBARRIGHT_MANABAR_ENABLED_INFO,
			TextBarRight_ManaBar_Toggle_Enabled,
			TextBarRight_ManaBarEnabled
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_HEALTHBAR_PERCENT",
			"CHECKBOX",
			TEXTBARRIGHT_HEALTHBAR_PERCENT,
			TEXTBARRIGHT_HEALTHBAR_PERCENT_INFO,
			TextBarRight_HealthBar_Toggle_Percent,
			TextBarRight_HealthBarPercentEnabled
		);
		Cosmos_RegisterConfiguration(
			"COS_TEXTBARRIGHT_MANABAR_PERCENT",
			"CHECKBOX",
			TEXTBARRIGHT_MANABAR_PERCENT,
			TEXTBARRIGHT_MANABAR_PERCENT_INFO,
			TextBarRight_ManaBar_Toggle_Percent,
			TextBarRight_ManaBarPercentEnabled
		);
		TextBarRight_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function TextBarRight_Register()
	if ( Cosmos_RegisterConfiguration ) then
		TextBarRight_Register_Cosmos();
	else
		SlashCmdList["TEXTBARRIGHTSLASHENABLE"] = TextBarRight_Enable_ChatCommandHandler;
		SLASH_TEXTBARRIGHTSLASHENABLE1 = "/textbarrightenable";
		SLASH_TEXTBARRIGHTSLASHENABLE2 = "/tbrenable";
		SLASH_TEXTBARRIGHTSLASHENABLE3 = "/textbarrightdisable";
		SLASH_TEXTBARRIGHTSLASHENABLE4 = "/tbrdisable";
		SLASH_TEXTBARRIGHTSLASHENABLE5 = "/textbarrighttoggle";
		SLASH_TEXTBARRIGHTSLASHENABLE6 = "/tbrtoggle";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local TextBarRightEnableCommands = {"/textbarrightenable","/tbrenable","/textbarrightdisable","/tbrdisable","/textbarrighttoggle","/tbrtoggle"};
		Cosmos_RegisterChatCommand (
			"TEXTBARRIGHT_ENABLE_COMMANDS", -- Some Unique Group ID
			TextBarRightEnableCommands, -- The Commands
			TextBarRight_Enable_ChatCommandHandler,
			TEXTBARRIGHT_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end

-- Handles chat - e.g. slashcommands - enabling/disabling the TextBarRight
function TextBarRight_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		TextBarRight_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			TextBarRight_Toggle_Enabled(0);
		else
			TextBarRight_Toggle_Enabled(-1);
		end
	end
end

-- Hooks/unhooks functions. If toggle is 1, hooks functions, otherwise it unhooks functions.
--  Hooking functions mean that you replace them with your own functions and then call the 
--  original function at your leisure.
function TextBarRight_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( TextStatusBar_UpdateTextString ~= TextBarRight_TextStatusBar_UpdateTextString ) and (TextBarRight_Saved_TextStatusBar_UpdateTextString == nil) ) then
			TextBarRight_Saved_TextStatusBar_UpdateTextString = TextStatusBar_UpdateTextString;
			TextStatusBar_UpdateTextString = TextBarRight_TextStatusBar_UpdateTextString;
		end
	else
		if ( TextStatusBar_UpdateTextString == TextBarRight_TextStatusBar_UpdateTextString) then
			TextStatusBar_UpdateTextString = TextBarRight_Saved_TextStatusBar_UpdateTextString;
			TextBarRight_Saved_TextStatusBar_UpdateTextString = nil;
		end
	end
end

-- Handles events
function TextBarRight_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( TextBarRight_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_TEXTBARRIGHT_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			TextBarRight_Toggle_Enabled(value);
		end
	end
end

function TextBarRight_HideBars()
	local textRight;
	for k, v in TEXTBARRIGHT_BAR_NAMES do
		for key, size in TEXTBARRIGHT_PREFIXNAME do
			textRight = getglobal("TextBarRight"..size..v);
			if ( ( textRight ) and ( textRight:IsVisible() ) ) then
				textRight:Hide();
			end
		end
	end
end

function TextBarRight_ChangeFontSize_Enabled(toggle, value)
	if ( toggle == 1 ) then
		TextBarRight_ChangeSize(value);
	else
		TextBarRight_ChangeSize(TEXTBARRIGHT_DEFAULT_FONTSIZE);
	end
end

function TextBarRight_ChangeSize(newSize)
	local textRight;
	if ( ( newSize > 0 ) and ( newSize <= getn(TEXTBARRIGHT_PREFIXNAME) ) ) then
		for k, v in TEXTBARRIGHT_BAR_NAMES do
			for key, size in TEXTBARRIGHT_PREFIXNAME do
				textRight = getglobal("TextBarRight"..size..v);
				if ( key == TextBarRight_FontSize) then
					if ( ( textRight ) and ( textRight:IsVisible() ) ) then
						textRight:Hide();
					end
				elseif ( key == newSize) then
					if ( ( textRight ) and ( not textRight:IsVisible() ) ) then
						textRight:Show();
					end
				end
			end
		end
		TextBarRight_FontSize = newSize;
		local str = TEXTBARRIGHT_PREFIXNAME[TextBarRight_FontSize];
		if ( ( not str) or ( strlen(str) <= 0) ) then
			str = "Normal";
		end
		TextBarRight_Print(format(TEXTBARRIGHT_CHAT_NEW_FONTSIZE, str));
	else
		TextBarRight_Print(TEXTBARRIGHT_CHAT_INVALID_FONTSIZE);
	end
end

function TextBarRight_GetPrefixName()
	if ( ( TextBarRight_FontSize >= 1 ) and ( TextBarRight_FontSize <= getn(TEXTBARRIGHT_PREFIXNAME) ) ) then
		return "TextBarRight"..TEXTBARRIGHT_PREFIXNAME[TextBarRight_FontSize];
	else
		return "TextBarRight";
	end
end

function TextBarRight_HealthBar_Toggle_Enabled(toggle)
	TextBarRight_Generic_Toggle(toggle, "TextBarRight_HealthBar_Enabled", "COS_TEXTBARRIGHT_HEALTHBAR_ENABLED_X", "TEXTBARRIGHT_CHAT_HEALTHBAR_ENABLED", "TEXTBARRIGHT_CHAT_HEALTHBAR_DISABLED");
end

function TextBarRight_ManaBar_Toggle_Enabled(toggle)
	TextBarRight_Generic_Toggle(toggle, "TextBarRight_ManaBar_Enabled", "COS_TEXTBARRIGHT_MANABAR_ENABLED_X", "TEXTBARRIGHT_CHAT_MANABAR_ENABLED", "TEXTBARRIGHT_CHAT_MANABAR_DISABLED");
end

function TextBarRight_HealthBar_Toggle_Percent(toggle)
	TextBarRight_Generic_Toggle(toggle, "TextBarRight_HealthBarPercentEnabled", "COS_TEXTBARRIGHT_HEALTHBAR_PERCENT_X", "TEXTBARRIGHT_CHAT_HEALTHBAR_PERCENT_ENABLED", "TEXTBARRIGHT_CHAT_HEALTHBAR_PERCENT_DISABLED");
end

function TextBarRight_ManaBar_Toggle_Percent(toggle)
	TextBarRight_Generic_Toggle(toggle, "TextBarRight_ManaBarPercentEnabled", "COS_TEXTBARRIGHT_MANABAR_PERCENT_X", "TEXTBARRIGHT_CHAT_MANABAR_PERCENT_ENABLED", "TEXTBARRIGHT_CHAT_MANABAR_PERCENT_DISABLED");
end

-- Toggles the enabled/disabled state of the TextBarRight
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function TextBarRight_Toggle_Enabled(toggle)
	local newvalue = TextBarRight_Generic_Toggle(toggle, "TextBarRight_Enabled", "COS_TEXTBARRIGHT_ENABLED_X", "TEXTBARRIGHT_CHAT_ENABLED", "TEXTBARRIGHT_CHAT_DISABLED");
	TextBarRight_Setup_Hooks(newvalue);
	if ( newvalue ~= 1 ) then
		TextBarRight_HideBars();
	end
end

-- Toggles the enabled/disabled state of an option and returns the new state
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function TextBarRight_Generic_Toggle(toggle, variableName, CVarName, enableMessage, disableMessage)
	local oldvalue = getglobal(variableName);
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	setglobal(variableName, newvalue);
	setglobal(CVarName, newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			TextBarRight_Print(TEXT(enableMessage));
		else
			TextBarRight_Print(TEXT(disableMessage));
		end
	end
	TextBarRight_Register_Cosmos();
	if ( TextBarRight_Cosmos_Registered == 0 ) then 
		RegisterForSave(CVarName);
	end
	return newvalue;
end

function TextBarRight_TextStatusBar_UpdateTextString()
	TextBarRight_Saved_TextStatusBar_UpdateTextString();
	local string = this.TextString;
	if(string) then
		local textBarName = TextBarRight_GetPrefixName()..this:GetName().."TextRight";
		local textBarRight = getglobal(textBarName);
		if ( not textBarRight ) then
			TextBarRight_Print(format("Could not find \"%s\"", textBarName));
			return;
		end
		if ( TextBarRight_Enabled == 0 ) then
			if ( textBarRight:IsVisible() ) then
				textBarRight:Hide();
			end
			return;
		end
		if ( ( ( strfind(textBarName, "HealthBar") ) and ( TextBarRight_HealthBarEnabled == 1 ) ) or
		( ( strfind(textBarName, "ManaBar") ) and ( TextBarRight_ManaBarEnabled == 1 ) ) ) then
			local value = this:GetValue();
			local valueMin, valueMax = this:GetMinMaxValues();
			local text = value.." / "..valueMax;
			if ( ( ( strfind(textBarName, "HealthBar") ) and ( TextBarRight_HealthBarPercentEnabled == 1 ) ) or
				( ( strfind(textBarName, "ManaBar") ) and ( TextBarRight_ManaBarPercentEnabled == 1 ) ) ) then
				local percentValue = value / valueMax;
				if ( percentValue - math.floor(percentValue) > 0.5 ) then
					percentValue = percentValue + 0.5;
				end
				local percent = math.floor(percentValue) * 100;
				text = percent.."%";
			else
				text = value.." / "..valueMax;
			end
			textBarRight:SetText(text);
			textBarRight:Show();
		else
			textBarRight:Hide();
		end
		if ( this:IsVisible() ) then
			if ( string:IsVisible() ) then
				local value = this:GetValue();
				local valueMin, valueMax = this:GetMinMaxValues();
				local text = value.." / "..valueMax;
				if ( ( not text ) or ( strlen(text) <= 0) ) then
					text = "MOMMA!";
				end
				textBarRight:SetText(text);
				--local valueMin, valueMax = this:GetMinMaxValues();
				--textBarRight:SetText(valueMin.." / "..valueMax);
				--textBarRight:SetText("MOMMA!");
				textBarRight:Show();
			else
				textBarRight:Hide();
			end
		else
			textBarRight:Hide();
		end
	end
end

-- Prints out text to a chat box.
function TextBarRight_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
